/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.requirement.connector.sei31.model;

import java.io.Serializable;

public class Serie
implements Serializable {
    private String id;
    private String nome;
    private String aplicabilidade;

    public Serie(String id, String nome, String aplicabilidade) {
        this.id = id;
        this.nome = nome;
        this.aplicabilidade = aplicabilidade;
    }

    public Serie(String id, String nome) {
        this(id, nome, null);
    }

    public static SerieType[] getAplicabilidadeWithModelo() {
        return new SerieType[]{SerieType.DOC_INTERNO_EXTERNO, SerieType.DOC_INTERNO};
    }

    public String getNome() {
        return this.nome;
    }

    public String getId() {
        return this.id;
    }

    public String getAplicabilidade() {
        return this.aplicabilidade;
    }

    public static enum SerieType {
        DOC_INTERNO_EXTERNO("T"),
        DOC_INTERNO("I"),
        DOC_EXTERNO("E"),
        FORMULARIO("F");

        private String description;

        private SerieType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public static SerieType valueOfEnumByDescription(String description) {
            for (SerieType type : SerieType.values()) {
                if (!description.trim().equals(type.getDescription())) continue;
                return type;
            }
            return null;
        }
    }
}

