/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.requirement.connector.sei31.builder;

import java.util.Arrays;
import org.opensingular.requirement.connector.sei31.model.AssuntoSei;
import org.opensingular.requirement.connector.sei31.model.NivelAcesso;
import org.opensingular.requirement.connector.sei31.model.TipoProcedimento;
import org.opensingular.requirement.connector.sei31.util.SEIUtil;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfAssunto;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfInteressado;
import org.opensingular.requirement.connector.sei31.ws.Interessado;
import org.opensingular.requirement.connector.sei31.ws.Procedimento;

public class ProcedimentoBuilder {
    private Procedimento procedimento = new Procedimento();

    public ProcedimentoBuilder() {
        this.procedimento.setAssuntos(new ArrayOfAssunto());
        this.procedimento.setInteressados(new ArrayOfInteressado());
        this.procedimento.setNivelAcesso(NivelAcesso.PUBLICO.getCodigo());
    }

    public ProcedimentoBuilder setTipoProcedimento(TipoProcedimento tipoProcedimento) {
        this.procedimento.setIdTipoProcedimento(tipoProcedimento != null ? tipoProcedimento.getId() : null);
        return this;
    }

    public ProcedimentoBuilder setEspecificacao(String value) {
        this.procedimento.setEspecificacao(SEIUtil.truncate(value, 100));
        return this;
    }

    public ProcedimentoBuilder setAssuntos(AssuntoSei ... assuntos) {
        this.procedimento.getAssuntos().getItem().clear();
        if (assuntos != null) {
            for (AssuntoSei assuntoSei : Arrays.asList(assuntos)) {
                this.procedimento.getAssuntos().getItem().add(assuntoSei.toAssunto());
            }
        }
        return this;
    }

    public ProcedimentoBuilder setInteressados(String ... interessados) {
        this.procedimento.getInteressados().getItem().clear();
        if (interessados != null) {
            for (String nome : interessados) {
                Interessado e = new Interessado();
                e.setNome(nome);
                this.procedimento.getInteressados().getItem().add(e);
            }
        }
        return this;
    }

    public ProcedimentoBuilder addnteressado(String sigla, String nome) {
        Interessado e = new Interessado();
        e.setSigla(sigla);
        e.setNome(nome);
        this.procedimento.getInteressados().getItem().add(e);
        return this;
    }

    public ProcedimentoBuilder setObservacao(String value) {
        this.procedimento.setObservacao(value);
        return this;
    }

    public ProcedimentoBuilder setNivelAcesso(NivelAcesso nivelAcesso) {
        this.procedimento.setNivelAcesso(nivelAcesso != null ? nivelAcesso.getCodigo() : NivelAcesso.PUBLICO.getCodigo());
        return this;
    }

    public Procedimento createProcedimento() {
        return this.procedimento;
    }
}

