/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.web;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.Environment;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.resources.WarResourceFetcher;
import org.bimserver.servlets.websockets.jsr356.Jsr356Impl;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarServerInitializer
implements ServletContextListener {
    private BimServer bimServer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        String realPath;
        ServletContext servletContext = servletContextEvent.getServletContext();
        Path homeDir = null;
        if (servletContext.getAttribute("homedir") != null) {
            homeDir = Paths.get((String)servletContext.getAttribute("homedir"), new String[0]);
        }
        if (homeDir == null && servletContext.getInitParameter("homedir") != null) {
            homeDir = Paths.get(servletContext.getInitParameter("homedir"), new String[0]);
        }
        boolean autoMigrate = false;
        if (servletContext.getAttribute("autoMigrate") != null) {
            autoMigrate = (Boolean)servletContext.getAttribute("autoMigrate");
        }
        if (!autoMigrate && servletContext.getInitParameter("autoMigrate") != null) {
            autoMigrate = Boolean.valueOf(servletContext.getInitParameter("autoMigrate"));
        }
        if (!(realPath = servletContext.getRealPath("/")).endsWith("/")) {
            realPath = realPath + "/";
        }
        Path baseDir = Paths.get(realPath + "WEB-INF", new String[0]);
        if (homeDir == null) {
            homeDir = baseDir;
        }
        WarResourceFetcher resourceFetcher = new WarResourceFetcher(servletContext, homeDir);
        BimServerConfig config = new BimServerConfig();
        config.setAutoMigrate(autoMigrate);
        config.setEnvironment(Environment.WAR);
        config.setHomeDir(homeDir);
        config.setResourceFetcher((ResourceFetcher)resourceFetcher);
        if (homeDir != null) {
            try {
                BimServer.initHomeDir((BimServerConfig)config);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setupLogging(homeDir);
        try {
            this.fixLogging(config);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        config.setStartEmbeddedWebServer(false);
        this.bimServer = new BimServer(config);
        Jsr356Impl.setDefaultServletContext((ServletContext)servletContextEvent.getServletContext());
        Logger LOGGER = LoggerFactory.getLogger(WarServerInitializer.class);
        LOGGER.info("Servlet Context Name: " + servletContext.getServletContextName());
        try {
            this.bimServer.start();
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseInitException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseRestartRequiredException e) {
            LOGGER.error("", (Throwable)e);
        }
        servletContext.setAttribute("bimserver", (Object)this.bimServer);
    }

    private void setupLogging(Path homeDir) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(homeDir.resolve("logback.xml").toFile());
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    private String makeClassPath(Path file) {
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (Path f : PathUtils.list((Path)file)) {
                if (!f.getFileName().toString().toLowerCase().endsWith(".jar")) continue;
                sb.append(f.toString() + File.pathSeparator);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        servletContextEvent.getServletContext().removeAttribute("bimserver");
        if (this.bimServer != null) {
            this.bimServer.stop();
        }
    }

    private void fixLogging(BimServerConfig config) throws IOException {
        Path logFolder = config.getHomeDir().resolve("logs");
        if (!Files.isDirectory(logFolder, new LinkOption[0])) {
            Files.createDirectories(logFolder, new FileAttribute[0]);
        }
        Path file = logFolder.resolve("bimserver.log");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        String filename = file.toAbsolutePath().toString();
        if (lc instanceof LoggerContext && !lc.isStarted()) {
            lc.start();
        }
        System.out.println("Logging to " + filename);
        fileAppender.setFile(filename);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        for (ch.qos.logback.classic.Logger log : lc.getLoggerList()) {
            if (log.getLevel() == null) continue;
            log.addAppender((Appender)fileAppender);
        }
    }
}

