/*
 * Decompiled with CFR 0.152.
 */
package org.openstrategies.metc.strategy.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.MSymbol;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.openstrategies.metc.strategy.base.OpenStrategy;
import org.openstrategies.metc.strategy.base.SuggestionIdentifier;
import org.openstrategies.metc.strategy.base.SuggestionIdentifierFactory;
import org.openstrategies.metc.strategy.util.Direction;

public class Trade {
    static final SuggestionIdentifier SUGGESTION_IDENTIFIER = SuggestionIdentifierFactory.make();
    private OpenStrategy strategy;
    private Map<String, String> customFields;
    private boolean conditional = true;
    public static final String DESCRIPTION = "description";
    public static final String DIRECTION = "direction";

    private Trade() {
    }

    public static Trade forStrategy(OpenStrategy strat) {
        Trade instance = new Trade();
        instance.strategy = strat;
        return instance;
    }

    private Map<String, String> getCustomFields() {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        return this.customFields;
    }

    public Trade ifTrue(boolean b) {
        this.conditional = b;
        return this;
    }

    public Trade comment(String note) {
        this.getCustomFields().put(DESCRIPTION, note);
        return this;
    }

    public Trade direction(Direction direction) {
        this.getCustomFields().put(DIRECTION, direction.toString());
        return this;
    }

    public void suggest(String symbol, Side side, double price) {
        if (this.conditional) {
            Direction direction = side.equals((Object)Side.SellShort) ? Direction.Short : Direction.Long;
            this.suggest(symbol, side, direction, price);
        }
    }

    public void suggest(String symbol, Side side, Direction direction, double price) {
        this.suggest(symbol, side, direction, new BigDecimal(price));
    }

    public void suggest(String symbol, Side side, Direction direction, BigDecimal price) {
        if (this.conditional) {
            OrderSingle order = Factory.getInstance().createOrderSingle();
            order.setSide(side);
            order.setSymbol(new MSymbol(symbol, SecurityType.CommonStock));
            order.setPrice(price);
            order.setCustomFields(this.customFields);
            this.strategy.suggestTrade(new OpenStrategy.OpenDelegate(order, new BigDecimal(0), SUGGESTION_IDENTIFIER.resolveIdentifier(this.strategy)));
        }
    }

    public void order(String symbol, Side side, Direction direction, BigDecimal price) {
        if (this.conditional) {
            OrderSingle order = Factory.getInstance().createOrderSingle();
            order.setSide(side);
            order.setSymbol(new MSymbol(symbol, SecurityType.CommonStock));
            order.setPrice(price);
            order.setCustomFields(this.customFields);
            this.strategy.sendOrder(new OpenStrategy.OpenDelegate(order));
        }
    }
}

