/*
 * Decompiled with CFR 0.152.
 */
package org.openstrategies.metc.strategy;

import java.util.Map;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.trade.Side;
import org.openstrategies.metc.strategy.base.OpenStrategy;
import org.openstrategies.metc.strategy.util.Direction;
import org.openstrategies.metc.strategy.util.EPL;
import org.openstrategies.metc.strategy.util.Trade;

public class RealTimeMovingAverageSuggestions
extends OpenStrategy {
    public static final String[] SYMBOLS = new String[]{"zzz"};
    public static final String[] CEP_QUERY = EPL.MA_2_4_8;
    public static final int MIN_ITERATIONS = 8;
    private int iteration = 0;
    private boolean isBuy = false;
    private boolean isSellShort = false;

    @Override
    public void onStart() {
        this.requestProcessedMarketData(MarketDataRequest.newRequest().withSymbols(SYMBOLS).fromProvider("marketcetera").withContent(new MarketDataRequest.Content[]{MarketDataRequest.Content.TOP_OF_BOOK}), CEP_QUERY, "esper");
    }

    @Override
    public void onOther(Object inEvent) {
        super.onOther(inEvent);
        if (inEvent instanceof Map) {
            Map map = (Map)inEvent;
            Data currData = new Data(map);
            if (currData.ma4.compareTo(currData.ma8) > 0 && !this.isBuy) {
                this.isBuy = true;
                Trade.forStrategy(this).ifTrue(this.iteration >= 8).comment("Ma-4 up-cross of ma-8.").suggest(currData.symbol, Side.Buy, currData.price);
                this.info("Buy - Ma-4 up-cross of ma-8.");
            } else if (currData.ma2.compareTo(currData.ma4) < 0 && this.isBuy) {
                this.isBuy = false;
                Trade.forStrategy(this).ifTrue(this.iteration >= 8).comment("Ma-2 down-cross of ma-4.").suggest(currData.symbol, Side.Sell, currData.price);
                this.info("Sell - Ma-2 down-cross of ma-4.");
            }
            if (currData.ma4.compareTo(currData.ma8) < 0 && !this.isSellShort) {
                this.isSellShort = true;
                Trade.forStrategy(this).ifTrue(this.iteration >= 8).comment("Ma-4 down-cross of ma-8.").suggest(currData.symbol, Side.SellShort, currData.price);
                this.info("SellShort - Ma-4 down-cross of ma-8.");
            } else if (currData.ma2.compareTo(currData.ma4) > 0 && this.isSellShort) {
                this.isSellShort = false;
                Trade.forStrategy(this).ifTrue(this.iteration >= 8).comment("Ma-2 up-cross of ma-4.").suggest(currData.symbol, Side.Buy, Direction.Short, currData.price);
                this.info("BuyToCover - Ma-2 up-cross of ma-4.");
            }
            if (this.iteration < 8) {
                ++this.iteration;
            }
        }
    }

    private static class Data {
        String symbol;
        Double price;
        Double ma2;
        Double ma4;
        Double ma8;

        public Data(Map map) {
            this.symbol = (String)map.get("symbol");
            this.price = (Double)map.get("price");
            this.ma2 = (Double)map.get("ma2");
            this.ma4 = (Double)map.get("ma4");
            this.ma8 = (Double)map.get("ma8");
        }
    }
}

