/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.numbers;

import java.io.Serializable;
import org.opentorah.numbers.BigRational;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class BigRational$
implements Serializable {
    public static final BigRational$ MODULE$ = new BigRational$();
    private static final BigRational zero = new BigRational(BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(1));
    private static final BigRational oneHalf = MODULE$.apply(BigInt$.MODULE$.int2bigInt(1), BigInt$.MODULE$.int2bigInt(2));
    private static final BigRational one = MODULE$.apply(BigInt$.MODULE$.int2bigInt(1), BigInt$.MODULE$.int2bigInt(1));

    public BigRational zero() {
        return zero;
    }

    public BigRational oneHalf() {
        return oneHalf;
    }

    public BigRational one() {
        return one;
    }

    public final BigRational apply(BigInt numerator, BigInt denominator) {
        BigRational bigRational;
        if (BoxesRunTime.equalsNumObject((Number)denominator, (Object)BoxesRunTime.boxToInteger((int)0))) {
            throw new ArithmeticException("Division by 0");
        }
        if (BoxesRunTime.equalsNumObject((Number)numerator, (Object)BoxesRunTime.boxToInteger((int)0))) {
            bigRational = this.zero();
        } else {
            BigInt gcd = numerator.gcd(denominator);
            bigRational = new BigRational(numerator.$div(gcd).$times(BigInt$.MODULE$.int2bigInt(denominator.signum())), denominator.$div(gcd).abs());
        }
        return bigRational;
    }

    public final BigRational apply(int numerator) {
        return this.apply(BigInt$.MODULE$.int2bigInt(numerator), BigInt$.MODULE$.int2bigInt(1));
    }

    public final BigRational apply(String value) {
        String[] values = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(value), '/');
        if (values.length != 2) {
            throw new ArithmeticException(new StringBuilder(21).append("Invalid BigRational: ").append(value).toString());
        }
        return this.apply(package$.MODULE$.BigInt().apply(values[0].trim()), package$.MODULE$.BigInt().apply(values[1].trim()));
    }

    public final Seq<Object> continuedFraction(BigRational value, int length) {
        Seq seq;
        Predef$.MODULE$.require(length >= 1);
        int whole = value.whole();
        BigRational fraction = value.fraction();
        if (fraction.isZero() || length == 1) {
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{whole}));
        } else {
            int n = whole;
            seq = (Seq)this.continuedFraction(fraction.invert(), length - 1).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return seq;
    }

    public Option<Tuple2<BigInt, BigInt>> unapply(BigRational x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.numerator(), (Object)x$0.denominator()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BigRational$.class);
    }

    private BigRational$() {
    }
}

