/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.site;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.opentorah.util.Files$;
import org.opentorah.util.Strings$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\f\u0018\u0005yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tc\u0001\u0011\t\u0011)A\u0005M!A!\u0007\u0001B\u0001B\u0003%a\u0005\u0003\u00054\u0001\t\u0005\t\u0015!\u0003'\u0011!!\u0004A!A!\u0002\u0013)\u0004\"\u0002\u001d\u0001\t\u0003I\u0004bB!\u0001\u0005\u0004%IA\u0011\u0005\u0007\u0013\u0002\u0001\u000b\u0011B\"\t\u000b)\u0003A\u0011B&\t\u000fE\u0003!\u0019!C\u0005%\"1q\f\u0001Q\u0001\nMCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004j\u0001\u0001\u0006IA\u0019\u0005\u0006U\u0002!\ta\u001b\u0005\u0006Y\u0002!I!\u001c\u0005\u0006i\u0002!I!\u001e\u0005\u0006q\u0002!I!\u001f\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002>\u0001!I!a\u0010\u0003=\u001d{wn\u001a7f\u00072|W\u000fZ*u_J\fw-Z*z]\u000eD'o\u001c8ju\u0016\u0014(B\u0001\r\u001a\u0003\u0011\u0019\u0018\u000e^3\u000b\u0005iY\u0012!C8qK:$xN]1i\u0015\u0005a\u0012aA8sO\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fM\u0006\t2/\u001a:wS\u000e,\u0017iY2pk:$8*Z=\u0011\u0005\u001drcB\u0001\u0015-!\tI\u0013%D\u0001+\u0015\tYS$\u0001\u0004=e>|GOP\u0005\u0003[\u0005\na\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q&I\u0001\u000bEV\u001c7.\u001a;OC6,\u0017\u0001\u00042vG.,G\u000f\u0015:fM&D\u0018!\u00043je\u0016\u001cGo\u001c:z!\u0006$\b.\u0001\u0004eef\u0014VO\u001c\t\u0003AYJ!aN\u0011\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"bA\u000f\u001f>}}\u0002\u0005CA\u001e\u0001\u001b\u00059\u0002\"B\u0013\u0007\u0001\u00041\u0003\"B\u0019\u0007\u0001\u00041\u0003\"\u0002\u001a\u0007\u0001\u00041\u0003\"B\u001a\u0007\u0001\u00041\u0003\"\u0002\u001b\u0007\u0001\u0004)\u0014A\u00027pO\u001e,'/F\u0001D!\t!u)D\u0001F\u0015\t15$A\u0003tY\u001a$$.\u0003\u0002I\u000b\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0002m_\u001e$\"\u0001T(\u0011\u0005\u0001j\u0015B\u0001(\"\u0005\u0011)f.\u001b;\t\u000bAK\u0001\u0019\u0001\u0014\u0002\u000f5,7o]1hK\u0006Y1M]3eK:$\u0018.\u00197t+\u0005\u0019\u0006C\u0001+^\u001b\u0005)&B\u0001,X\u0003\u0019y\u0017-\u001e;ie)\u0011\u0001,W\u0001\u0005CV$\bN\u0003\u0002[7\u00061qm\\8hY\u0016T\u0011\u0001X\u0001\u0004G>l\u0017B\u00010V\u0005e\u0019VM\u001d<jG\u0016\f5mY8v]R\u001c%/\u001a3f]RL\u0017\r\\:\u0002\u0019\r\u0014X\rZ3oi&\fGn\u001d\u0011\u0002\u000fM$xN]1hKV\t!\r\u0005\u0002dO6\tAM\u0003\u0002aK*\u0011a-W\u0001\u0006G2|W\u000fZ\u0005\u0003Q\u0012\u0014qa\u0015;pe\u0006<W-\u0001\u0005ti>\u0014\u0018mZ3!\u0003\u0011\u0019\u0018P\\2\u0015\u00031\u000b1A];o)\raen\u001c\u0005\u0006!>\u0001\rA\n\u0005\u0007a>!\t\u0019A9\u0002\r\u0005\u001cG/[8o!\r\u0001#\u000fT\u0005\u0003g\u0006\u0012\u0001\u0002\u00102z]\u0006lWMP\u0001\u0014GJ,\u0017\r^3ESJ,7\r^8ss\ncwN\u0019\u000b\u0003\u0019ZDQa\u001e\tA\u0002\u0019\n\u0001B\u00197pE:\u000bW.Z\u0001\u0006oJLG/\u001a\u000b\u0004\u0019j\\\b\"B<\u0012\u0001\u00041\u0003\"\u0002?\u0012\u0001\u0004i\u0018\u0001\u00024jY\u0016\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t!![8\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u00111\u0015\u000e\\3\u0002\u001b1L7\u000f\u001e#je\u0016\u001cGo\u001c:z)\u0011\ty!!\u0006\u0011\u000b\u001d\n\tBJ?\n\u0007\u0005M\u0001GA\u0002NCBDQa\r\nA\u0002\u0019\n1\u0003\\5ti\n+8m[3u\t&\u0014Xm\u0019;pef$B!a\u0007\u0002$A1q%!\u0005'\u0003;\u00012aYA\u0010\u0013\r\t\t\u0003\u001a\u0002\u0005\u00052|'\rC\u00033'\u0001\u0007a%A\bmSN$()^2lKR4\u0015\u000e\\3t)\u0011\tI#a\u000f\u0011\r\u0005-\u0012QGA\u000f\u001d\u0011\ti#!\r\u000f\u0007%\ny#C\u0001#\u0013\r\t\u0019$I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9$!\u000f\u0003\t1K7\u000f\u001e\u0006\u0004\u0003g\t\u0003\"\u0002\u001a\u0015\u0001\u00041\u0013aC5t\t&\u0014Xm\u0019;pef$2!NA!\u0011\u001d\t\u0019%\u0006a\u0001\u0003;\tAA\u00197pE\u0002")
public final class GoogleCloudStorageSynchronizer {
    private final String bucketName;
    private final String bucketPrefix;
    private final String directoryPath;
    private final boolean dryRun;
    private final Logger logger;
    private final ServiceAccountCredentials credentials;
    private final Storage storage;

    private Logger logger() {
        return this.logger;
    }

    private void log(String message) {
        this.logger().info(message);
    }

    private ServiceAccountCredentials credentials() {
        return this.credentials;
    }

    private Storage storage() {
        return this.storage;
    }

    public void sync() {
        block4: {
            this.log(new StringBuilder(0).append(new StringBuilder(19).append("Synchronizing ").append(this.directoryPath).append(" to ").append(this.bucketName).append("/").append(this.bucketPrefix).toString()).append((Object)(this.dryRun ? " (dry run)" : "")).toString());
            this.log(new StringBuilder(17).append("Listing files in ").append(this.directoryPath).toString());
            Map<String, File> files = this.listDirectory(this.directoryPath);
            this.log(new StringBuilder(12).append("Found ").append(files.size()).append(" files").toString());
            this.log(new StringBuilder(18).append("Listing blobs in ").append(this.bucketName).append("/").append(this.bucketPrefix).toString());
            Map<String, Blob> blobs = this.listBucketDirectory(this.bucketPrefix);
            this.log(new StringBuilder(12).append("Found ").append(blobs.size()).append(" blobs").toString());
            List toDelete = (List)blobs.values().toList().filter((Function1 & Serializable)blob -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$1(files, blob))).sortBy((Function1 & Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$);
            this.log(new StringBuilder(22).append("Found ").append(toDelete.length()).append(" blobs to delete").toString());
            List newFiles = (List)files.toList().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$3(blobs, x0$1))).sortBy((Function1 & Serializable)x0$2 -> {
                String name;
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String string = name = (String)tuple2._1();
                return string;
            }, (Ordering)Ordering.String$.MODULE$);
            List toCreateDirectories = newFiles.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$5(x0$3))).map((Function1 & Serializable)x0$4 -> {
                String name;
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String string = name = (String)tuple2._1();
                return string;
            });
            this.log(new StringBuilder(28).append("Found ").append(toCreateDirectories.length()).append(" directories to create").toString());
            List toUpload = newFiles.filter((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$7(x0$5)));
            this.log(new StringBuilder(22).append("Found ").append(toUpload.length()).append(" files to upload").toString());
            List existing = (List)blobs.toList().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$8(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                Blob blob = (Blob)tuple2._2();
                Option option = files.get((Object)name).map((Function1 & Serializable)file -> new Tuple2((Object)blob, file));
                return option;
            });
            List flavourChanged = existing.filter((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$11(this, x0$6))).map((Function1 & Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Blob blob = (Blob)tuple2._1();
                File file = (File)tuple2._2();
                String string = new StringBuilder(17).append("Blob ").append(blob).append(" ").append(GoogleCloudStorageSynchronizer.status$1(this.isDirectory(blob))).append(" but file ").append(file).append(" ").append(GoogleCloudStorageSynchronizer.status$1(file.isDirectory())).toString();
                return string;
            });
            if (flavourChanged.nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(21).append("isDirectory changes: ").append(flavourChanged.mkString("\n")).toString());
            }
            List toUpdate = (List)existing.filter((Function1 & Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$13(x0$8))).filter((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$14(x0$9))).filter((Function1 & Serializable)x0$10 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$15(x0$10))).sortBy((Function1 & Serializable)x0$11 -> {
                Tuple2 tuple2 = x0$11;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Blob blob = (Blob)tuple2._1();
                String string = blob.getName();
                return string;
            }, (Ordering)Ordering.String$.MODULE$);
            this.log(new StringBuilder(22).append("Found ").append(toUpdate.length()).append(" blobs to update").toString());
            if (toDelete.nonEmpty()) {
                this.log(new StringBuilder(15).append("Deleting ").append(toDelete.length()).append(" blobs").toString());
                toDelete.foreach((Function1 & Serializable)blob -> {
                    this.run(new StringBuilder(14).append("Deleting blob ").append(blob.getName()).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> blob.delete(new Blob.BlobSourceOption[0]));
                    return BoxedUnit.UNIT;
                });
                this.log("Done deleting");
            }
            if (toCreateDirectories.nonEmpty()) {
                this.log(new StringBuilder(29).append("Creating ").append(toCreateDirectories.length()).append(" new directory blobs").toString());
                toCreateDirectories.foreach((Function1 & Serializable)newDirectory -> {
                    this.run(new StringBuilder(28).append("Creating new directory blob ").append(newDirectory).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.createDirectoryBlob(newDirectory));
                    return BoxedUnit.UNIT;
                });
                this.log("Done creating directory blobs");
            }
            if (toUpload.nonEmpty()) {
                this.log(new StringBuilder(16).append("Uploading ").append(toUpload.length()).append(" files").toString());
                toUpload.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$21(check$ifrefutable$2))).foreach((Function1 & Serializable)x$3 -> {
                    GoogleCloudStorageSynchronizer.$anonfun$sync$22(this, x$3);
                    return BoxedUnit.UNIT;
                });
                this.log("Done uploading");
            }
            if (!toUpdate.nonEmpty()) break block4;
            this.log(new StringBuilder(15).append("Updating ").append(toUpdate.length()).append(" blobs").toString());
            toUpdate.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$sync$24(check$ifrefutable$3))).foreach((Function1 & Serializable)x$4 -> {
                GoogleCloudStorageSynchronizer.$anonfun$sync$25(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.log("Done updating");
        }
    }

    private void run(String message, Function0<BoxedUnit> action) {
        if (this.dryRun) {
            this.log(new StringBuilder(4).append("NOT ").append(message).toString());
        } else {
            this.log(message);
            action.apply$mcV$sp();
        }
    }

    private void createDirectoryBlob(String blobName) {
        this.storage().create(BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)blobName)).build(), new Storage.BlobTargetOption[0]);
    }

    private void write(String blobName, File file) {
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(file.getName());
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)blobName)).setContentType(contentType).build();
        byte[] content = Files$.MODULE$.readFile(file);
        WriteChannel writer = this.storage().writer(blobInfo, new Storage.BlobWriteOption[0]);
        writer.write(ByteBuffer.wrap(content, 0, content.length));
        writer.close();
    }

    private Map<String, File> listDirectory(String directoryPath) {
        return this.listDirectories$1(package$.MODULE$.List().empty(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{new File(directoryPath)}))).map((Function1 & Serializable)file -> {
            String name = Strings$.MODULE$.drop(file.getAbsolutePath(), directoryPath);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(file.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : name)), file);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Blob> listBucketDirectory(String bucketPrefix) {
        return this.listDirectories$2(package$.MODULE$.List().empty(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{bucketPrefix}))).map((Function1 & Serializable)blob -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blob.getName()), blob)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private List<Blob> listBucketFiles(String bucketPrefix) {
        return this.listPages$1(package$.MODULE$.List().empty(), this.storage().list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)bucketPrefix)}));
    }

    private boolean isDirectory(Blob blob) {
        return blob.getName().endsWith("/");
    }

    public static final /* synthetic */ boolean $anonfun$sync$1(Map files$1, Blob blob) {
        return !files$1.contains((Object)blob.getName());
    }

    public static final /* synthetic */ boolean $anonfun$sync$3(Map blobs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        boolean bl = !blobs$1.contains((Object)name);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$5(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._2();
        boolean bl = file.isDirectory();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$7(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._2();
        boolean bl = !file.isDirectory();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$11(GoogleCloudStorageSynchronizer $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Blob blob = (Blob)tuple2._1();
        File file = (File)tuple2._2();
        boolean bl = $this.isDirectory(blob) != file.isDirectory();
        return bl;
    }

    private static final String status$1(boolean isDirectory) {
        return isDirectory ? "is" : "is not ";
    }

    public static final /* synthetic */ boolean $anonfun$sync$13(Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._2();
        boolean bl = !file.isDirectory();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$14(Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Blob blob = (Blob)tuple2._1();
        File file = (File)tuple2._2();
        boolean bl = file.lastModified() > Predef$.MODULE$.Long2long(blob.getUpdateTime());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$15(Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Blob blob = (Blob)tuple2._1();
        File file = (File)tuple2._2();
        String string = blob.getCrc32cToHexString();
        String string2 = Strings$.MODULE$.bytes2hex((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.byteArrayOps(Hashing.crc32c().hashBytes(Files$.MODULE$.readFile(file)).asBytes())).reverse());
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sync$21(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$sync$22(GoogleCloudStorageSynchronizer $this, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        File file = (File)tuple2._2();
        $this.run(new StringBuilder(14).append("Uploading ").append(file).append(" to ").append(name).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.write(name, file));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$sync$24(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$sync$25(GoogleCloudStorageSynchronizer $this, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Blob blob = (Blob)tuple2._1();
        File file = (File)tuple2._2();
        $this.run(new StringBuilder(15).append("Updating ").append(blob.getName()).append(" from ").append(file).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.write(blob.getName(), file));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final List listDirectories$1(List result, List directoriesToList) {
        block3: {
            List list;
            while (true) {
                List list2;
                List files;
                List tail;
                block5: {
                    Tuple2 tuple2;
                    block4: {
                        list = directoriesToList;
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list3 = list;
                        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) break block3;
                        if (!(list instanceof .colon.colon)) break;
                        .colon.colon colon2 = (.colon.colon)list;
                        File current = (File)colon2.head();
                        tail = colon2.next$access$1();
                        File gsignore = new File(current, ".gsignore");
                        Set ignore = !gsignore.exists() ? Predef$.MODULE$.Set().empty() : (Set)Files$.MODULE$.read(gsignore).toSet().$plus((Object)".gsignore");
                        tuple2 = Predef$.MODULE$.wrapRefArray((Object[])current.listFiles()).toList().filterNot((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ignore.contains((Object)file.getName()))).partition((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDirectory()));
                        if (tuple2 == null) break block4;
                        List directories = (List)tuple2._1();
                        files = (List)tuple2._2();
                        if (directories == null) break block4;
                        list2 = directories;
                        if (files != null) break block5;
                    }
                    throw new MatchError((Object)tuple2);
                }
                List list4 = files;
                Tuple2 tuple2 = new Tuple2((Object)list2, (Object)list4);
                Tuple2 tuple22 = tuple2;
                List directories = (List)tuple22._1();
                List files2 = (List)tuple22._2();
                directoriesToList = (List)tail.$plus$plus((IterableOnce)directories);
                result = (List)((IterableOps)result.$plus$plus((IterableOnce)directories)).$plus$plus((IterableOnce)files2);
            }
            throw new MatchError((Object)list);
        }
        List list = result;
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$listBucketDirectory$3(Blob directory$1, Blob x$8) {
        String string = x$8.getName();
        String string2 = directory$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final List listDirectories$2(List result, List directoriesToList) {
        block3: {
            List list;
            while (true) {
                List list2;
                List files;
                List tail;
                block5: {
                    Tuple2 tuple2;
                    block4: {
                        list = directoriesToList;
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list3 = list;
                        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) break block3;
                        if (!(list instanceof .colon.colon)) break;
                        .colon.colon colon2 = (.colon.colon)list;
                        String current = (String)colon2.head();
                        tail = colon2.next$access$1();
                        tuple2 = this.listBucketFiles(current).partition((Function1 & Serializable)blob -> BoxesRunTime.boxToBoolean((boolean)this.isDirectory(blob)));
                        if (tuple2 == null) break block4;
                        List directories = (List)tuple2._1();
                        files = (List)tuple2._2();
                        if (directories == null) break block4;
                        list2 = directories;
                        if (files != null) break block5;
                    }
                    throw new MatchError((Object)tuple2);
                }
                List list4 = files;
                Tuple2 tuple2 = new Tuple2((Object)list2, (Object)list4);
                Tuple2 tuple22 = tuple2;
                List directories = (List)tuple22._1();
                List files2 = (List)tuple22._2();
                List newDirectories = directories.filterNot((Function1 & Serializable)directory -> BoxesRunTime.boxToBoolean((boolean)result.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)GoogleCloudStorageSynchronizer.$anonfun$listBucketDirectory$3(directory, x$8)))));
                directoriesToList = (List)tail.$plus$plus((IterableOnce)newDirectories.map((Function1 & Serializable)x$9 -> x$9.getName()));
                result = (List)((IterableOps)result.$plus$plus((IterableOnce)newDirectories)).$plus$plus((IterableOnce)files2);
            }
            throw new MatchError((Object)list);
        }
        List list = result;
        return list;
    }

    private final List listPages$1(List result, Page page) {
        while (page != null) {
            List list = (List)result.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala(page.iterateAll()).asScala().toList());
            page = page.getNextPage();
            result = list;
        }
        return result;
    }

    public GoogleCloudStorageSynchronizer(String serviceAccountKey, String bucketName, String bucketPrefix, String directoryPath, boolean dryRun) {
        this.bucketName = bucketName;
        this.bucketPrefix = bucketPrefix;
        this.directoryPath = directoryPath;
        this.dryRun = dryRun;
        Predef$.MODULE$.require(directoryPath.endsWith("/"));
        this.logger = LoggerFactory.getLogger(GoogleCloudStorageSynchronizer.class);
        this.credentials = ServiceAccountCredentials.fromStream((InputStream)Strings$.MODULE$.string2stream(serviceAccountKey));
        this.storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)this.credentials())).build().getService();
    }
}

