/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.site;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.opentorah.docbook.DocBook$;
import org.opentorah.site.DocBookHtmlContent;
import org.opentorah.site.Site;
import org.opentorah.site.Site$;
import org.opentorah.site.SiteDocBook$;
import org.opentorah.store.Caching;
import org.opentorah.store.Caching$;
import org.opentorah.util.Files$;
import org.opentorah.xml.Catalog$;
import org.opentorah.xml.ContentType;
import org.opentorah.xml.Context;
import org.opentorah.xml.Elements;
import org.opentorah.xml.From;
import org.opentorah.xml.Parsable;
import org.opentorah.xml.Parser$;
import org.opentorah.xml.Redirect;
import org.opentorah.xml.Resolver;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.xml.Elem;
import zio.Has;
import zio.ZIO;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u000e\u001d\u0005\rB\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005Y!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u00039\u0011!!\u0005A!b\u0001\n\u0003\u0011\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\u0019\u0003!Q1A\u0005\u0002\u001dC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0019\u0002\u0011)\u0019!C\u0001\u001b\"A\u0011\u000b\u0001B\u0001B\u0003%a\nC\u0003S\u0001\u0011\u00051\u000bC\u0003\\\u0001\u0011%A\fC\u0003d\u0001\u0011\u0005A\rC\u0003v\u0001\u0011\u0005aoB\u0003x9!\u0005\u0001PB\u0003\u001c9!\u0005\u0011\u0010\u0003\u0004S!\u0011\u0005\u0011\u0011\u0001\u0005\n\u0003\u0007\u0001\"\u0019!C\u0005\u0003\u000bA\u0001\"!\u0006\u0011A\u0003%\u0011q\u0001\u0005\n\u0003/\u0001\"\u0019!C\u0005\u0003\u000bA\u0001\"!\u0007\u0011A\u0003%\u0011q\u0001\u0005\n\u00037\u0001\"\u0019!C\u0005\u0003\u000bA\u0001\"!\b\u0011A\u0003%\u0011q\u0001\u0005\n\u0003?\u0001\"\u0019!C\u0005\u0003CA\u0001\"!\u000b\u0011A\u0003%\u00111\u0005\u0005\b\u0003W\u0001B\u0011IA\u0017\u0005-\u0019\u0016\u000e^3E_\u000e\u0014un\\6\u000b\u0005uq\u0012\u0001B:ji\u0016T!a\b\u0011\u0002\u0013=\u0004XM\u001c;pe\u0006D'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-A\u0005e_\u000e,X.\u001a8ugV\tA\u0006E\u0002.kar!AL\u001a\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u0012\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\t!d%A\u0004qC\u000e\\\u0017mZ3\n\u0005Y:$aA*fc*\u0011AG\n\t\u0003sur!AO\u001e\u0011\u0005=2\u0013B\u0001\u001f'\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q2\u0013A\u00033pGVlWM\u001c;tA\u0005yq.\u001e;qkR$\u0015N]3di>\u0014\u00180F\u00019\u0003AyW\u000f\u001e9vi\u0012K'/Z2u_JL\b%\u0001\bck&dG\rR5sK\u000e$xN]=\u0002\u001f\t,\u0018\u000e\u001c3ESJ,7\r^8ss\u0002\n!\u0003Z1uC\u001e+g.\u001a:bi>\u00148\t\\1tgV\t\u0001\nE\u0002&\u0013bJ!A\u0013\u0014\u0003\r=\u0003H/[8o\u0003M!\u0017\r^1HK:,'/\u0019;pe\u000ec\u0017m]:!\u00035\u0019XOY:uSR,H/[8ogV\ta\n\u0005\u0003:\u001fbB\u0014B\u0001)@\u0005\ri\u0015\r]\u0001\u000fgV\u00147\u000f^5ukRLwN\\:!\u0003\u0019a\u0014N\\5u}Q1AKV,Y3j\u0003\"!\u0016\u0001\u000e\u0003qAQAK\u0006A\u00021BQ!Q\u0006A\u0002aBQ\u0001R\u0006A\u0002aBQAR\u0006A\u0002!CQ\u0001T\u0006A\u00029\u000ba\u0001\\8hO\u0016\u0014X#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u0004\u0013!B:mMRR\u0017B\u00012`\u0005\u0019aunZ4fe\u00069\u0001O]8dKN\u001cXCA3p)\t1\u0017\u000e\u0005\u0002&O&\u0011\u0001N\n\u0002\u0005+:LG\u000fC\u0003\u001e\u001b\u0001\u0007!\u000eE\u0002VW6L!\u0001\u001c\u000f\u0003\tMKG/\u001a\t\u0003]>d\u0001\u0001B\u0003q\u001b\t\u0007\u0011OA\u0001T#\t\u0011(\u000e\u0005\u0002&g&\u0011AO\n\u0002\b\u001d>$\b.\u001b8h\u0003-\u0001(/\u001a;usB\u0013\u0018N\u001c;\u0015\u0003\u0019\f1bU5uK\u0012{7MQ8pWB\u0011Q\u000bE\n\u0003!i\u00042a\u001f@U\u001b\u0005a(BA?\u001f\u0003\rAX\u000e\\\u0005\u0003\u007fr\u0014q!\u00127f[\u0016tG\u000fF\u0001y\u0003I!wnY;nK:$8/\u0011;ue&\u0014W\u000f^3\u0016\u0005\u0005\u001d\u0001#BA\u0005\u0003\u001fAdbA>\u0002\f%\u0019\u0011Q\u0002?\u0002\u0013\u0005#HO]5ckR,\u0017\u0002BA\t\u0003'\u0011\u0001BU3rk&\u0014X\r\u001a\u0006\u0004\u0003\u001ba\u0018a\u00053pGVlWM\u001c;t\u0003R$(/\u001b2vi\u0016\u0004\u0013\u0001G8viB,H\u000fR5sK\u000e$xN]=BiR\u0014\u0018NY;uK\u0006Ir.\u001e;qkR$\u0015N]3di>\u0014\u00180\u0011;ue&\u0014W\u000f^3!\u0003]\u0011W/\u001b7e\t&\u0014Xm\u0019;pef\fE\u000f\u001e:jEV$X-\u0001\rck&dG\rR5sK\u000e$xN]=BiR\u0014\u0018NY;uK\u0002\n1\u0004Z1uC\u001e+g.\u001a:bi>\u00148\t\\1tg\u0006#HO]5ckR,WCAA\u0012!\u0015\tI!!\n9\u0013\u0011\t9#a\u0005\u0003\u0011=\u0003H/[8oC2\fA\u0004Z1uC\u001e+g.\u001a:bi>\u00148\t\\1tg\u0006#HO]5ckR,\u0007%A\bd_:$XM\u001c;QCJ\u001c\u0018M\u00197f+\t\ty\u0003\u0005\u0003|\u0003c!\u0016bAA\u001ay\nA\u0001+\u0019:tC\ndW\r")
public final class SiteDocBook {
    private final Seq<String> documents;
    private final String outputDirectory;
    private final String buildDirectory;
    private final Option<String> dataGeneratorClass;
    private final Map<String, String> substitutions;

    public static Parsable<SiteDocBook> contentParsable() {
        return SiteDocBook$.MODULE$.contentParsable();
    }

    public static Elem xmlElement(Object value) {
        return SiteDocBook$.MODULE$.xmlElement(value);
    }

    public static ContentType contentType() {
        return SiteDocBook$.MODULE$.contentType();
    }

    public static String elementName() {
        return SiteDocBook$.MODULE$.elementName();
    }

    public static Elements.HandleRedirect<SiteDocBook, Either<Redirect<SiteDocBook>, SiteDocBook>> withRedirect(boolean follow) {
        return SiteDocBook$.MODULE$.withRedirect(follow);
    }

    public static Elements.HandleRedirect<SiteDocBook, Either<Redirect<SiteDocBook>, SiteDocBook>> orRedirect() {
        return SiteDocBook$.MODULE$.orRedirect();
    }

    public static Elements.HandleRedirect<SiteDocBook, SiteDocBook> followRedirects() {
        return SiteDocBook$.MODULE$.followRedirects();
    }

    public static Elements.Sequence<SiteDocBook> seq() {
        return SiteDocBook$.MODULE$.seq();
    }

    public static Elements.Required<SiteDocBook> required() {
        return SiteDocBook$.MODULE$.required();
    }

    public static Elements.Optional<SiteDocBook> optional() {
        return SiteDocBook$.MODULE$.optional();
    }

    public static ZIO<Has<Context>, String, SiteDocBook> parse(URL fromUrl) {
        return SiteDocBook$.MODULE$.parse(fromUrl);
    }

    public static ZIO<Has<Context>, String, SiteDocBook> parse(From from) {
        return SiteDocBook$.MODULE$.parse(from);
    }

    public Seq<String> documents() {
        return this.documents;
    }

    public String outputDirectory() {
        return this.outputDirectory;
    }

    public String buildDirectory() {
        return this.buildDirectory;
    }

    public Option<String> dataGeneratorClass() {
        return this.dataGeneratorClass;
    }

    public Map<String, String> substitutions() {
        return this.substitutions;
    }

    private Logger logger() {
        return Site$.MODULE$.logger();
    }

    public <S extends Site<S>> void process(Site<S> site) {
        Object object;
        URL baseUrl = site.fromUrl().url();
        Seq documentFiles = (Seq)this.documents().map((Function1 & Serializable)x$1 -> Files$.MODULE$.subFile(baseUrl, x$1));
        File outputDirectoryFile = Files$.MODULE$.subFile(baseUrl, this.outputDirectory());
        File buildDirectoryFile = Files$.MODULE$.subFile(baseUrl, this.buildDirectory());
        this.logger().warn(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("Processing DocBook:\n"), new StringBuilder(20).append("  inputDocuments : ").append(documentFiles).append("\n").toString())), new StringBuilder(20).append("  buildDirectory : ").append(buildDirectoryFile).append("\n").toString())), new StringBuilder(20).append("  outputDirectory: ").append(outputDirectoryFile).append("\n").toString())), new StringBuilder(20).append("  substitutions  : ").append(this.substitutions()).append("\n").toString()));
        File catalogDirectory = new File(buildDirectoryFile, "docBookCatalog");
        File dtdFile = new File(catalogDirectory, "substitutions.dtd");
        File catalogFile = new File(catalogDirectory, "catalog.xml");
        File dataDirectory = new File(buildDirectoryFile, "data");
        if (this.dataGeneratorClass().isEmpty()) {
            this.logger().warn("skipping DocBook data generation: 'dataGenerationClass' is not set");
            object = BoxedUnit.UNIT;
        } else {
            this.logger().warn(new StringBuilder(37).append("running DocBook data generator ").append(this.dataGeneratorClass().get()).append(" into ").append(dataDirectory).toString());
            object = Class.forName((String)this.dataGeneratorClass().get()).getMethod("main", String[].class).invoke(null, new Object[]{new String[]{dataDirectory.toString()}});
        }
        this.logger().warn(new StringBuilder(25).append("writing XML Catalog into ").append(catalogFile).toString());
        DocBook$.MODULE$.writeDtd(dtdFile, this.substitutions());
        Catalog$.MODULE$.write(catalogFile, true, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Elem[]{Catalog$.MODULE$.nextCatalogSystem(), DocBook$.MODULE$.dtdLink(dtdFile)})).$plus$plus(DocBook$.MODULE$.data(dataDirectory)));
        this.logger().warn(new StringBuilder(9).append("deleting ").append(outputDirectoryFile).toString());
        Files$.MODULE$.deleteFiles(outputDirectoryFile);
        boolean prefixed = documentFiles.length() > 1;
        Resolver resolver = new Resolver(catalogFile);
        documentFiles.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SiteDocBook.$anonfun$process$2(check$ifrefutable$1))).foreach((Function1 & Serializable)documentFile -> {
            SiteDocBook.$anonfun$process$3(this, outputDirectoryFile, prefixed, resolver, site, documentFile);
            return BoxedUnit.UNIT;
        });
    }

    public void prettyPrint() {
    }

    public static final /* synthetic */ boolean $anonfun$process$2(File check$ifrefutable$1) {
        File file = check$ifrefutable$1;
        boolean bl = file != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$process$3(SiteDocBook $this, File outputDirectoryFile$1, boolean prefixed$1, Resolver resolver$1, Site site$1, File documentFile) {
        String documentName = (String)Files$.MODULE$.nameAndExtension(documentFile.getName())._1();
        File outputFile = Files$.MODULE$.file(outputDirectoryFile$1, (Seq)(!prefixed$1 ? package$.MODULE$.Seq().empty() : package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{documentName}))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"html", "index.html"}))));
        $this.logger().warn(new StringBuilder(34).append("processing '").append(documentName).append("'\n  from '").append(documentFile).append("'\n  to   '").append(outputFile).append("'.").toString());
        DocBookHtmlContent htmlContent = new DocBookHtmlContent(documentFile, resolver$1);
        String content = (String)Parser$.MODULE$.run(Caching$.MODULE$.provide((Caching)site$1.caching(), site$1.renderHtmlContent(htmlContent)));
        Files$.MODULE$.write(outputFile, content);
    }

    public SiteDocBook(Seq<String> documents, String outputDirectory, String buildDirectory, Option<String> dataGeneratorClass, Map<String, String> substitutions) {
        this.documents = documents;
        this.outputDirectory = outputDirectory;
        this.buildDirectory = buildDirectory;
        this.dataGeneratorClass = dataGeneratorClass;
        this.substitutions = substitutions;
    }
}

