/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.site;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.opentorah.docbook.DocBook;
import org.opentorah.docbook.DocBook$;
import org.opentorah.site.Site;
import org.opentorah.site.Site$;
import org.opentorah.site.SiteDocBook$;
import org.opentorah.store.Context;
import org.opentorah.store.Store;
import org.opentorah.util.Effects;
import org.opentorah.util.Files$;
import org.opentorah.xml.Caching;
import org.opentorah.xml.Caching$;
import org.opentorah.xml.Catalog$;
import org.opentorah.xml.Element;
import org.opentorah.xml.Elements;
import org.opentorah.xml.From;
import org.opentorah.xml.Parsable;
import org.opentorah.xml.Parsing;
import org.opentorah.xml.Resolver;
import org.opentorah.xml.Xml;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.xml.Elem;
import zio.Has;
import zio.ZIO;

public final class SiteDocBook {
    private final Seq documents;
    private final String outputDirectory;
    private final String buildDirectory;
    private final Option dataGeneratorClass;
    private final Map substitutions;

    public static Parsable<SiteDocBook> contentParsable() {
        return SiteDocBook$.MODULE$.contentParsable();
    }

    public static Element.ContentType contentType() {
        return SiteDocBook$.MODULE$.contentType();
    }

    public static Option<Element.AndParser<SiteDocBook>> elementAndParser(String string) {
        return SiteDocBook$.MODULE$.elementAndParser(string);
    }

    public static String elementName() {
        return SiteDocBook$.MODULE$.elementName();
    }

    public static Elements.HandleRedirect<SiteDocBook, SiteDocBook> followRedirects() {
        return SiteDocBook$.MODULE$.followRedirects();
    }

    public static Elements.Optional<SiteDocBook> optional() {
        return SiteDocBook$.MODULE$.optional();
    }

    public static Elements.HandleRedirect<SiteDocBook, Either<Elements.Redirect<SiteDocBook>, SiteDocBook>> orRedirect() {
        return SiteDocBook$.MODULE$.orRedirect();
    }

    public static ZIO<Has<Parsing>, Effects.Error, SiteDocBook> parse(From from) {
        return SiteDocBook$.MODULE$.parse(from);
    }

    public static ZIO<Has<Parsing>, Effects.Error, SiteDocBook> parse(URL uRL, Xml xml) {
        return SiteDocBook$.MODULE$.parse(uRL, xml);
    }

    public static Elements.Required<SiteDocBook> required() {
        return SiteDocBook$.MODULE$.required();
    }

    public static Elements.Sequence<SiteDocBook> seq() {
        return SiteDocBook$.MODULE$.seq();
    }

    public static Elements.HandleRedirect<SiteDocBook, Either<Elements.Redirect<SiteDocBook>, SiteDocBook>> withRedirect(boolean bl) {
        return SiteDocBook$.MODULE$.withRedirect(bl);
    }

    public static Element<Seq<SiteDocBook>> wrappedSeq(String string) {
        return SiteDocBook$.MODULE$.wrappedSeq(string);
    }

    public static Elem xmlElement(Object object) {
        return SiteDocBook$.MODULE$.xmlElement(object);
    }

    public static Xml parse$default$2() {
        return SiteDocBook$.MODULE$.parse$default$2();
    }

    public SiteDocBook(Seq<String> documents, String outputDirectory, String buildDirectory, Option<String> dataGeneratorClass, Map<String, String> substitutions) {
        this.documents = documents;
        this.outputDirectory = outputDirectory;
        this.buildDirectory = buildDirectory;
        this.dataGeneratorClass = dataGeneratorClass;
        this.substitutions = substitutions;
    }

    public Seq<String> documents() {
        return this.documents;
    }

    public String outputDirectory() {
        return this.outputDirectory;
    }

    public String buildDirectory() {
        return this.buildDirectory;
    }

    public Option<String> dataGeneratorClass() {
        return this.dataGeneratorClass;
    }

    public Map<String, String> substitutions() {
        return this.substitutions;
    }

    private Logger logger() {
        return Site$.MODULE$.logger();
    }

    public void process(Context context) {
        Object object;
        Site site = (Site)context;
        URL baseUrl = site.fromUrl().url();
        Seq documentFiles = (Seq)this.documents().map((Function1 & Serializable)_$1 -> Files$.MODULE$.subFile(baseUrl, _$1));
        File outputDirectoryFile = Files$.MODULE$.subFile(baseUrl, this.outputDirectory());
        File buildDirectoryFile = Files$.MODULE$.subFile(baseUrl, this.buildDirectory());
        this.logger().warn(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("Processing DocBook:\n"), new StringBuilder(20).append("  inputDocuments : ").append(documentFiles).append("\n").toString())), new StringBuilder(20).append("  buildDirectory : ").append(buildDirectoryFile).append("\n").toString())), new StringBuilder(20).append("  outputDirectory: ").append(outputDirectoryFile).append("\n").toString())), new StringBuilder(20).append("  substitutions  : ").append(this.substitutions()).append("\n").toString()));
        File catalogDirectory = new File(buildDirectoryFile, "docBookCatalog");
        File dtdFile = new File(catalogDirectory, "substitutions.dtd");
        File catalogFile = new File(catalogDirectory, "catalog.xml");
        File dataDirectory = new File(buildDirectoryFile, "data");
        if (this.dataGeneratorClass().isEmpty()) {
            this.logger().warn("skipping DocBook data generation: 'dataGenerationClass' is not set");
            object = BoxedUnit.UNIT;
        } else {
            this.logger().warn(new StringBuilder(37).append("running DocBook data generator ").append(this.dataGeneratorClass().get()).append(" into ").append(dataDirectory).toString());
            object = Class.forName((String)this.dataGeneratorClass().get()).getMethod("main", String[].class).invoke(null, new Object[]{new String[]{dataDirectory.toString()}});
        }
        this.logger().warn(new StringBuilder(25).append("writing XML Catalog into ").append(catalogFile).toString());
        DocBook$.MODULE$.writeDtd(dtdFile, this.substitutions());
        Catalog$.MODULE$.write(catalogFile, true, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Elem[]{Catalog$.MODULE$.nextCatalogSystem(), DocBook$.MODULE$.dtdLink(dtdFile)})).$plus$plus(DocBook$.MODULE$.data(dataDirectory)));
        this.logger().warn(new StringBuilder(9).append("deleting ").append(outputDirectoryFile).toString());
        Files$.MODULE$.deleteFiles(outputDirectoryFile);
        boolean prefixed = documentFiles.length() > 1;
        Resolver resolver = new Resolver(catalogFile);
        documentFiles.foreach((Function1)(JProcedure1 & Serializable)documentFile -> {
            String documentName = (String)Files$.MODULE$.nameAndExtension(documentFile.getName())._1();
            File outputFile = Files$.MODULE$.file(outputDirectoryFile, (Seq)(!prefixed ? (Seq)package$.MODULE$.Seq().empty() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{documentName}))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"html", "index.html"}))));
            this.logger().warn(new StringBuilder(34).append("processing '").append(documentName).append("'\n  from '").append(documentFile).append("'\n  to   '").append(outputFile).append("'.").toString());
            DocBook store = new DocBook((File)documentFile, resolver);
            String content = (String)Caching$.MODULE$.unsafeRun((Caching)site.caching(), site.render((Seq<Store>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DocBook[]{store})))));
            Files$.MODULE$.write(outputFile, content);
        });
    }

    public void prettyPrint() {
    }
}

