/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.site;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import org.opentorah.site.Site;
import org.opentorah.site.Site$;
import org.opentorah.site.SiteService$;
import org.opentorah.sync.GoogleCloudStorageSynchronizer;
import org.opentorah.util.Effects$;
import org.opentorah.util.Files$;
import org.opentorah.util.Logging$;
import org.opentorah.util.Zhttp$;
import org.opentorah.xml.Element;
import org.opentorah.xml.Parser;
import org.opentorah.xml.ScalaXml$;
import org.opentorah.xml.Xml;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import scala.util.Properties$;
import zhttp.http.Header;
import zhttp.http.Header$;
import zhttp.http.Http;
import zhttp.http.Http$;
import zhttp.http.HttpData;
import zhttp.http.HttpData$;
import zhttp.http.Method;
import zhttp.http.PathModule;
import zhttp.http.Request;
import zhttp.http.Response;
import zhttp.http.Response$;
import zhttp.http.Status;
import zio.App;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ExitCode;
import zio.Has;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.clock.package;
import zio.stream.ZStream$;

public abstract class SiteService<S extends Site>
extends Element<S>
implements App {
    private final Option<String> serviceName = Option$.MODULE$.apply((Object)System.getenv("K_SERVICE"));

    public SiteService() {
        super("site");
        Logging$.MODULE$.configureLogBack(this.serviceName.isDefined());
    }

    public final ZIO<Object, Throwable, S> readSite(String url) {
        return this.readSite(Files$.MODULE$.string2url(url));
    }

    private final ZIO<Object, Throwable, S> readSite(URL url) {
        URL siteFileUrl = Files$.MODULE$.fileInDirectory(url, "site.xml");
        ZIO result = Effects$.MODULE$.effect((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$1(siteFileUrl))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this.parse(siteFileUrl, (Xml)ScalaXml$.MODULE$).flatMap((Function1 & Serializable)result -> Effects$.MODULE$.effect((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$2$$anonfun$1$$anonfun$1(siteFileUrl))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return result;
            }));
        });
        return Parser.package.Parser$.MODULE$.toTask(result);
    }

    public abstract String projectId();

    public abstract String bucketName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ZIO<Has<package.Clock.Service>, Nothing$, ExitCode> run(List<String> args) {
        Object object;
        if (args.isEmpty()) {
            object = this.serve((Option<String>)None$.MODULE$);
            return object.exitCode();
        }
        String string = (String)args.head();
        switch (string == null ? 0 : string.hashCode()) {
            case -1628016664: {
                if (!"uploadSiteDryRun".equals(string)) throw new MatchError((Object)string);
                object = this.upload((String)args.apply(1), (String)args.apply(2), true);
                return object.exitCode();
            }
            case -1401015595: {
                if (!"buildSite".equals(string)) throw new MatchError((Object)string);
                object = this.build((String)args.apply(1), false);
                return object.exitCode();
            }
            case -1352040164: {
                if (!"serveRemoteSite".equals(string)) throw new MatchError((Object)string);
                object = this.serve((Option<String>)None$.MODULE$);
                return object.exitCode();
            }
            case -243107608: {
                if (!"uploadSite".equals(string)) throw new MatchError((Object)string);
                object = this.upload((String)args.apply(1), (String)args.apply(2), false);
                return object.exitCode();
            }
            case -198351114: {
                if (!"serveSite".equals(string)) throw new MatchError((Object)string);
                object = this.serve((Option<String>)((Option)args.lift().apply((Object)BoxesRunTime.boxToInteger((int)1))));
                return object.exitCode();
            }
            case 81902581: {
                if (!"buildAndPrettyPrintSite".equals(string)) throw new MatchError((Object)string);
                object = this.build((String)args.apply(1), true);
                return object.exitCode();
            }
            default: {
                throw new MatchError((Object)string);
            }
        }
    }

    private ZIO<Object, Throwable, BoxedUnit> build(String urlString, boolean withPrettyPrint) {
        URL url = Files$.MODULE$.file2url(new File(urlString));
        return this.readSite(url).flatMap((Function1 & Serializable)_$1 -> _$1.build(withPrettyPrint));
    }

    private ZIO<Object, Throwable, BoxedUnit> upload(String directoryPath, String serviceAccountKey, boolean dryRun) {
        return Effects$.MODULE$.effectTotal((Function0)((JFunction0.mcV.sp & Serializable)() -> this.upload$$anonfun$1(directoryPath, serviceAccountKey, dryRun)));
    }

    /*
     * WARNING - void declaration
     */
    private ZIO<Has<package.Clock.Service>, Nothing$, ExitCode> serve(Option<String> urlString) {
        String string;
        if (urlString.nonEmpty()) {
            void var3_2;
            String result = (String)urlString.get();
            this.info(new StringBuilder(27).append("siteUri argument supplied: ").append(result).toString());
            string = var3_2;
        } else {
            string = this.getParameter$1("STORE", new StringBuilder(8).append("http://").append(this.bucketName()).append("/").toString());
        }
        String siteUrl = string;
        int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.getParameter$1("PORT", "8080")));
        this.warning(new StringBuilder(12).append("serviceName=").append(this.serviceName).toString());
        return Zhttp$.MODULE$.start(port, this.routes(siteUrl), Zhttp$.MODULE$.start$default$3());
    }

    private Http<Has<package.Clock.Service>, Throwable, Request, Response<Has<package.Clock.Service>, Throwable>> routes(String siteUrl) {
        ObjectRef cachedSite = ObjectRef.create((Object)None$.MODULE$);
        Effects$.MODULE$.unsafeRun(() -> this.routes$$anonfun$1(siteUrl, cachedSite));
        BoxedUnit boxedUnit = Http$.MODULE$.collectM();
        return Http.MakeCollectM$.MODULE$.apply$extension(boxedUnit, (PartialFunction)new Serializable(siteUrl, cachedSite, this){
            private final String siteUrl$8;
            private final ObjectRef cachedSite$9;
            private final SiteService $outer;
            {
                this.siteUrl$8 = siteUrl$9;
                this.cachedSite$9 = cachedSite$10;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Request x) {
                Option option;
                Request request = x;
                if (request != null && !(option = zhttp.http.package$.MODULE$.$minus$greater().unapply(request)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option.get();
                    PathModule.Path path = (PathModule.Path)tuple2._2();
                    if (Method.GET$.MODULE$.equals(tuple2._1()) && path instanceof PathModule.$div && ((PathModule.$div)path).zhttp$http$PathModule$$div$$$outer() == zhttp.http.package$.MODULE$) {
                        PathModule.$div $div2 = zhttp.http.package$.MODULE$.$div().unapply((PathModule.$div)path);
                        PathModule.Path path2 = $div2._1();
                        String string = $div2._2();
                        if (zhttp.http.package$.MODULE$.Root().equals(path2) && "reset-cached-site".equals(string)) {
                            Request request2 = request;
                            return true;
                        }
                    }
                }
                Request request3 = request;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Request x, Function1 function1) {
                ZIO zIO;
                Option option;
                Request request = x;
                if (request != null && !(option = zhttp.http.package$.MODULE$.$minus$greater().unapply(request)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option.get();
                    PathModule.Path path = (PathModule.Path)tuple2._2();
                    if (Method.GET$.MODULE$.equals(tuple2._1()) && path instanceof PathModule.$div && ((PathModule.$div)path).zhttp$http$PathModule$$div$$$outer() == zhttp.http.package$.MODULE$) {
                        PathModule.$div $div2 = zhttp.http.package$.MODULE$.$div().unapply((PathModule.$div)path);
                        PathModule.Path path2 = $div2._1();
                        String string = $div2._2();
                        if (zhttp.http.package$.MODULE$.Root().equals(path2) && "reset-cached-site".equals(string)) {
                            Request request2 = request;
                            zIO = this.$outer.org$opentorah$site$SiteService$$_$reset$1(this.siteUrl$8, this.cachedSite$9, request2);
                            return zIO;
                        }
                    }
                }
                Request request3 = request;
                zIO = this.$outer.org$opentorah$site$SiteService$$time(request3, (ZIO<Has<package.Blocking.Service>, Throwable, Response<Has<package.Blocking.Service>, Throwable>>)this.$outer.org$opentorah$site$SiteService$$_$get$1(this.siteUrl$8, this.cachedSite$9, request3));
                return zIO;
            }
        });
    }

    public ZIO<Has<package.Clock.Service>, Throwable, Response<Has<package.Clock.Service>, Throwable>> org$opentorah$site$SiteService$$time(Request request, ZIO<Has<package.Blocking.Service>, Throwable, Response<Has<package.Blocking.Service>, Throwable>> response) {
        return response.timed().mapEffect((Function1 & Serializable)x$1 -> {
            boolean isWarning;
            String string;
            block6: {
                Tuple2 tuple2;
                block5: {
                    Response.HttpResponse response;
                    Status status;
                    Response response2 = SiteService.response$1(x$1);
                    Tuple2 tuple22 = response2 instanceof Response.HttpResponse ? (Status.OK$.MODULE$.equals(status = (response = (Response.HttpResponse)response2).status()) ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"GOT") : (Status.NOT_FOUND$.MODULE$.equals(status) ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"NOT") : (Status.NOT_MODIFIED$.MODULE$.equals(status) ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"UNM") : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"---")))) : (tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"???"));
                    if (tuple2 == null) break block5;
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
                    string = (String)tuple2._2();
                    if (!true) break block5;
                    isWarning = bl;
                    if (string != null) break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            String code = string;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)isWarning), (Object)code);
            boolean isWarning2 = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
            String code2 = (String)tuple2._2();
            String durationStr = SiteService$.MODULE$.org$opentorah$site$SiteService$$$formatDuration(SiteService.duration$1(x$1));
            String message = new StringBuilder(2).append(code2).append(" ").append(durationStr).append(" ").append(request.url().path().asString()).toString();
            if (isWarning2) {
                this.warning(request, message);
            } else {
                this.info(request, message);
            }
            return SiteService.response$1(x$1);
        }, (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void info(Option<Request> request, String message) {
        this.log(request, message, "INFO");
    }

    private void info(Request request, String message) {
        this.log((Option<Request>)Some$.MODULE$.apply((Object)request), message, "INFO");
    }

    private void info(String message) {
        this.log((Option<Request>)None$.MODULE$, message, "INFO");
    }

    private void notice(Request request, String message) {
        this.log((Option<Request>)Some$.MODULE$.apply((Object)request), message, "NOTICE");
    }

    private void notice(String message) {
        this.log((Option<Request>)None$.MODULE$, message, "NOTICE");
    }

    private void warning(Request request, String message) {
        this.log((Option<Request>)Some$.MODULE$.apply((Object)request), message, "WARNING");
    }

    private void warning(String message) {
        this.log((Option<Request>)None$.MODULE$, message, "WARNING");
    }

    private final Logger logger() {
        return Site$.MODULE$.logger();
    }

    private void log(Option<Request> request, String message, String severity) {
        Option trace2 = request.flatMap((Function1 & Serializable)_$3 -> _$3.getHeaderValue((CharSequence)"X-Cloud-Trace-Context")).map((Function1 & Serializable)_$4 -> _$4.split("/")[0]);
        Seq arguments = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructuredArgument[]{StructuredArguments.keyValue((String)"severity", (Object)severity)})).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(trace2).toSeq().map((Function1 & Serializable)trace -> StructuredArguments.keyValue((String)"logging.googleapis.com/trace", (Object)new StringBuilder(17).append("projects/").append(this.projectId()).append("/traces/").append((String)trace).toString())));
        this.logger().info(message, (Object[])((StructuredArgument[])Arrays$.MODULE$.seqToArray(arguments, StructuredArgument.class)));
    }

    private final void $anonfun$1(URL siteFileUrl$1) {
        this.logger().info(new StringBuilder(18).append("Reading site from ").append(siteFileUrl$1).toString());
    }

    private final void $anonfun$2$$anonfun$1$$anonfun$1(URL siteFileUrl$4) {
        this.logger().info(new StringBuilder(25).append("Reading site from ").append(siteFileUrl$4).append(" - done").toString());
    }

    private final void upload$$anonfun$1(String directoryPath$1, String serviceAccountKey$1, boolean dryRun$1) {
        new GoogleCloudStorageSynchronizer(serviceAccountKey$1, this.bucketName(), "", new StringBuilder(1).append(directoryPath$1).append("/").toString(), dryRun$1).sync();
    }

    private final String getParameter$1$$anonfun$1(String name$1, String defaultValue$1) {
        this.info(new StringBuilder(53).append("No value for '").append(name$1).append("' in the environment; using default: '").append(defaultValue$1).append("'").toString());
        return defaultValue$1;
    }

    private final String getParameter$1(String name, String defaultValue) {
        return (String)Properties$.MODULE$.envOrNone(name).fold(() -> this.getParameter$1$$anonfun$1(name, defaultValue), (Function1 & Serializable)value -> {
            this.info(new StringBuilder(36).append("Value    for '").append(name).append("' in the environment: ").append((String)value).toString());
            return value;
        });
    }

    private static final Site getSite$1$$anonfun$1$$anonfun$1(Site _$2$1) {
        return _$2$1;
    }

    private final ZIO getSite$1$$anonfun$2(String siteUrl$2, ObjectRef cachedSite$2) {
        return this.readSite(siteUrl$2).map((Function1 & Serializable)result -> {
            Some some = Some$.MODULE$.apply(result);
            cachedSite$3.elem = some;
            return result;
        });
    }

    private final ZIO getSite$1(String siteUrl$1, ObjectRef cachedSite$1) {
        return (ZIO)((Option)cachedSite$1.elem).map((Function1 & Serializable)_$2 -> Task$.MODULE$.succeed(() -> SiteService.getSite$1$$anonfun$1$$anonfun$1(_$2))).getOrElse(() -> this.getSite$1$$anonfun$2(siteUrl$1, cachedSite$1));
    }

    private final ZIO routes$$anonfun$1(String siteUrl$6, ObjectRef cachedSite$7) {
        return this.getSite$1(siteUrl$6, cachedSite$7);
    }

    private final void reset$1$$anonfun$1(ObjectRef cachedSite$4, Request request$1) {
        this.info(request$1, "RST");
        None$ none$ = None$.MODULE$;
        cachedSite$4.elem = none$;
    }

    public final ZIO org$opentorah$site$SiteService$$_$reset$1(String siteUrl$3, ObjectRef cachedSite$5, Request request) {
        return Effects$.MODULE$.effectTotal((Function0)((JFunction0.mcV.sp & Serializable)() -> this.reset$1$$anonfun$1(cachedSite$5, request))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return this.getSite$1(siteUrl$3, cachedSite$5).map((Function1 & Serializable)x$1 -> {
                Site site = x$1;
                List list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.contentTypeTextPlain()}));
                HttpData.CompleteData completeData = Zhttp$.MODULE$.textData("Site reset!");
                Status status = Response$.MODULE$.http$default$1();
                return Response$.MODULE$.http(status, list, (HttpData)completeData);
            });
        });
    }

    private static final Chunk $anonfun$3(byte[] bytes$1) {
        return Chunk$.MODULE$.fromArray((Object)bytes$1);
    }

    private static final Response get$1$$anonfun$2$$anonfun$1(String pathString$3, Throwable error$1) {
        return Zhttp$.MODULE$.notFound(new StringBuilder(1).append(pathString$3).append("\n").append(error$1.getMessage()).toString());
    }

    public final ZIO org$opentorah$site$SiteService$$_$get$1(String siteUrl$5, ObjectRef cachedSite$6, Request request) {
        String pathString = request.url().path().asString();
        Seq path = Files$.MODULE$.splitAndDecodeUrl(pathString);
        return this.getSite$1(siteUrl$5, cachedSite$6).flatMap((Function1 & Serializable)site -> site.isStatic((Seq<String>)path) ? Zhttp$.MODULE$.staticFile(Files$.MODULE$.pathUnder(Files$.MODULE$.string2url(siteUrl$5), pathString), (Option)Some$.MODULE$.apply((Object)request)) : site.getResponse(pathString).map((Function1 & Serializable)siteResponse -> {
            byte[] bytes = Zhttp$.MODULE$.textBytes(siteResponse.content());
            List list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.custom(HttpHeaderNames.CONTENT_TYPE.toString(), (CharSequence)siteResponse.mimeType()), Header$.MODULE$.contentLength((long)bytes.length)}));
            HttpData httpData = HttpData$.MODULE$.fromStream(ZStream$.MODULE$.fromChunk(() -> SiteService.$anonfun$3(bytes)));
            Status status = Response$.MODULE$.http$default$1();
            return Response$.MODULE$.http(status, list, httpData);
        })).catchAll((Function1 & Serializable)error -> ZIO$.MODULE$.succeed(() -> SiteService.get$1$$anonfun$2$$anonfun$1(pathString, error)), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()));
    }

    private static final Duration duration$1(Tuple2 x$1$1) {
        return (Duration)x$1$1._1();
    }

    private static final Response response$1(Tuple2 x$1$2) {
        return (Response)x$1$2._2();
    }
}

