/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.store;

import java.io.Serializable;
import java.net.URL;
import org.opentorah.metadata.Named;
import org.opentorah.metadata.Names;
import org.opentorah.metadata.Names$;
import org.opentorah.store.Directory$;
import org.opentorah.store.ListFile;
import org.opentorah.store.Store;
import org.opentorah.store.Stores;
import org.opentorah.store.Terminal;
import org.opentorah.util.Effects;
import org.opentorah.util.Files$;
import org.opentorah.xml.Attribute;
import org.opentorah.xml.Caching;
import org.opentorah.xml.Caching$;
import org.opentorah.xml.Element;
import org.opentorah.xml.Elements;
import org.opentorah.xml.Parsing;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;

public abstract class Directory<T, M extends Entry, W extends Wrapper<M>>
implements Stores<M>,
Element.FromUrl$.With {
    private final String directory;
    private final String fileExtension;
    private final EntryMaker<T, M> entryMaker;
    private final Function1<Map<String, M>, W> wrapper;
    private final ListFile<M, W> listFile;

    public static Attribute.Required<String> directoryAttribute() {
        return Directory$.MODULE$.directoryAttribute();
    }

    public static Attribute.Required<String> fileNameAttribute() {
        return Directory$.MODULE$.fileNameAttribute();
    }

    public Directory(String directory, String fileExtension, EntryMaker<T, M> entryMaker, Function1<Map<String, M>, W> wrapper) {
        this.directory = directory;
        this.fileExtension = fileExtension;
        this.entryMaker = entryMaker;
        this.wrapper = wrapper;
        this.listFile = new ListFile(Files$.MODULE$.fileInDirectory(this.fromUrl().url(), new StringBuilder(19).append(directory).append("-list-generated.xml").toString()), "directory", entryMaker, (Function1 & Serializable)entries -> (Wrapper)wrapper.apply((Object)((IterableOnceOps)entries.map((Function1 & Serializable)entry -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)entry.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, entry);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public String directory() {
        return this.directory;
    }

    public final URL directoryUrl() {
        return Files$.MODULE$.subdirectory(this.fromUrl().url(), this.directory());
    }

    public final ZIO<Has<Caching>, Effects.Error, BoxedUnit> writeDirectory() {
        return ZIO$.MODULE$.foreach((Iterable)Files$.MODULE$.filesWithExtensions(Files$.MODULE$.url2file(this.directoryUrl()), this.fileExtension).sorted((Ordering)Ordering.String$.MODULE$), (Function1 & Serializable)name -> this.getFile((String)name).flatMap((Function1 & Serializable)file -> this.entryMaker.apply((String)name, file)), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1)(JProcedure1 & Serializable)entries -> this.listFile.write((Seq<M>)entries));
    }

    @Override
    public ZIO<Has<Caching>, Effects.Error, Option<M>> findByName(String name) {
        return this.getDirectory().map((Function1 & Serializable)_$1 -> _$1.findByName(name));
    }

    @Override
    public ZIO<Has<Caching>, Effects.Error, Seq<M>> stores() {
        return this.getDirectory().map((Function1 & Serializable)_$2 -> _$2.stores());
    }

    public final ZIO<Has<Caching>, Effects.Error, W> getDirectory() {
        return this.listFile.get();
    }

    public final ZIO<Has<Caching>, Effects.Error, T> getFile(M entry) {
        return this.getFile(((Entry)entry).name());
    }

    private ZIO<Has<Caching>, Effects.Error, T> getFile(String name) {
        return Caching$.MODULE$.getCachedByUrl(this.fileUrl(name), (Function1 & Serializable)url -> this.loadFile((URL)url));
    }

    public final URL fileUrl(M entry) {
        return this.fileUrl(((Entry)entry).name());
    }

    public final URL fileUrl(String name) {
        return Files$.MODULE$.fileInDirectory(this.directoryUrl(), new StringBuilder(1).append(name).append(".").append(this.fileExtension).toString());
    }

    public final void writeFile(M entry, String content) {
        Files$.MODULE$.write(Files$.MODULE$.url2file(this.fileUrl(entry)), content);
    }

    public abstract ZIO<Has<Parsing>, Effects.Error, T> loadFile(URL var1);

    public static abstract class Entry
    implements Named,
    Store,
    Terminal {
        private final String name;
        private final Names names;

        public Entry(String name) {
            this.name = name;
            this.names = Names$.MODULE$.apply(name);
        }

        public String name() {
            return this.name;
        }

        public final Names names() {
            return this.names;
        }
    }

    public static interface EntryMaker<T, M extends Entry>
    extends Elements<M> {
        public ZIO<Has<Parsing>, Effects.Error, M> apply(String var1, T var2);
    }

    public static abstract class Wrapper<M extends Store> {
        private final Map<String, M> name2entry;

        public Wrapper(Map<String, M> name2entry) {
            this.name2entry = name2entry;
        }

        public final Seq<M> stores() {
            return this.name2entry.values().toSeq();
        }

        public final Option<M> findByName(String name) {
            return this.name2entry.get((Object)name);
        }
    }
}

