/*
 * Decompiled with CFR 0.152.
 */
package org.opentorah.sync;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.opentorah.util.Files$;
import org.opentorah.util.Strings$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class GoogleCloudStorageSynchronizer {
    private final String bucketName;
    private final String bucketPrefix;
    private final String directoryPath;
    private final boolean dryRun;
    private final Logger logger;
    private final Storage storage;

    public GoogleCloudStorageSynchronizer(String serviceAccountKey, String bucketName, String bucketPrefix, String directoryPath, boolean dryRun) {
        this.bucketName = bucketName;
        this.bucketPrefix = bucketPrefix;
        this.directoryPath = directoryPath;
        this.dryRun = dryRun;
        Predef$.MODULE$.require(directoryPath.endsWith("/"));
        this.logger = LoggerFactory.getLogger(GoogleCloudStorageSynchronizer.class);
        ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)Strings$.MODULE$.string2stream(serviceAccountKey));
        this.storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).build().getService();
    }

    private void log(String message) {
        this.logger.info(message);
    }

    public void sync() {
        this.log(new StringBuilder(19).append("Synchronizing ").append(this.directoryPath).append(" to ").append(this.bucketName).append("/").append(this.bucketPrefix).append(this.dryRun ? " (dry run)" : "").toString());
        this.log(new StringBuilder(17).append("Listing files in ").append(this.directoryPath).toString());
        Map<String, File> files = this.listDirectory(this.directoryPath);
        this.log(new StringBuilder(12).append("Found ").append(files.size()).append(" files").toString());
        this.log(new StringBuilder(18).append("Listing blobs in ").append(this.bucketName).append("/").append(this.bucketPrefix).toString());
        Map<String, Blob> blobs = this.listBucketDirectory(this.bucketPrefix);
        this.log(new StringBuilder(12).append("Found ").append(blobs.size()).append(" blobs").toString());
        List toDelete = (List)blobs.values().toList().filter((Function1 & Serializable)blob -> !files.contains((Object)blob.getName())).sortBy((Function1 & Serializable)_$1 -> _$1.getName(), (Ordering)Ordering.String$.MODULE$);
        this.log(new StringBuilder(22).append("Found ").append(toDelete.length()).append(" blobs to delete").toString());
        List newFiles = (List)files.toList().filter((Function1 & Serializable)x$1 -> !blobs.contains((Object)GoogleCloudStorageSynchronizer.name$2(x$1))).sortBy((Function1 & Serializable)x$1 -> GoogleCloudStorageSynchronizer.name$3(x$1), (Ordering)Ordering.String$.MODULE$);
        List toCreateDirectories = newFiles.filter((Function1 & Serializable)x$1 -> GoogleCloudStorageSynchronizer.file$3(x$1).isDirectory()).map((Function1 & Serializable)x$1 -> GoogleCloudStorageSynchronizer.name$4(x$1));
        this.log(new StringBuilder(28).append("Found ").append(toCreateDirectories.length()).append(" directories to create").toString());
        List toUpload = newFiles.filter((Function1 & Serializable)x$1 -> !GoogleCloudStorageSynchronizer.file$4(x$1).isDirectory());
        this.log(new StringBuilder(22).append("Found ").append(toUpload.length()).append(" files to upload").toString());
        List existing = (List)blobs.toList().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Blob blob = (Blob)tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Blob blob = (Blob)tuple2._2();
            return files.get((Object)name).map((Function1 & Serializable)file -> Tuple2$.MODULE$.apply((Object)blob, file));
        });
        List flavourChanged = existing.filter((Function1 & Serializable)x$1 -> this.isDirectory(GoogleCloudStorageSynchronizer.blob$4(x$1)) != GoogleCloudStorageSynchronizer.file$5(x$1).isDirectory()).map((Function1 & Serializable)x$1 -> new StringBuilder(17).append("Blob ").append(GoogleCloudStorageSynchronizer.blob$5(x$1)).append(" ").append(GoogleCloudStorageSynchronizer.status$1(this.isDirectory(GoogleCloudStorageSynchronizer.blob$5(x$1)))).append(" but file ").append(GoogleCloudStorageSynchronizer.file$6(x$1)).append(" ").append(GoogleCloudStorageSynchronizer.status$1(GoogleCloudStorageSynchronizer.file$6(x$1).isDirectory())).toString());
        if (flavourChanged.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(21).append("isDirectory changes: ").append(flavourChanged.mkString("\n")).toString());
        }
        List toUpdate = (List)existing.filter((Function1 & Serializable)x$1 -> !GoogleCloudStorageSynchronizer.file$7(x$1).isDirectory()).filter((Function1 & Serializable)x$1 -> GoogleCloudStorageSynchronizer.file$8(x$1).lastModified() > Predef$.MODULE$.Long2long(GoogleCloudStorageSynchronizer.blob$6(x$1).getUpdateTime())).filter((Function1 & Serializable)x$1 -> {
            String string = GoogleCloudStorageSynchronizer.blob$7(x$1).getCrc32cToHexString();
            Object object = Predef$.MODULE$.byteArrayOps(Hashing.crc32c().hashBytes(Files$.MODULE$.readFile(GoogleCloudStorageSynchronizer.file$9(x$1))).asBytes());
            String string2 = Strings$.MODULE$.bytes2hex((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object).reverse());
            return string == null ? string2 != null : !string.equals(string2);
        }).sortBy((Function1 & Serializable)x$1 -> GoogleCloudStorageSynchronizer.blob$8(x$1).getName(), (Ordering)Ordering.String$.MODULE$);
        this.log(new StringBuilder(22).append("Found ").append(toUpdate.length()).append(" blobs to update").toString());
        if (toDelete.nonEmpty()) {
            this.log(new StringBuilder(15).append("Deleting ").append(toDelete.length()).append(" blobs").toString());
            toDelete.foreach((Function1)(JProcedure1 & Serializable)blob -> this.run(new StringBuilder(14).append("Deleting blob ").append(blob.getName()).toString(), (Function0)((JFunction0.mcV.sp & Serializable)() -> GoogleCloudStorageSynchronizer.sync$$anonfun$1$$anonfun$1(blob))));
            this.log("Done deleting");
        }
        if (toCreateDirectories.nonEmpty()) {
            this.log(new StringBuilder(29).append("Creating ").append(toCreateDirectories.length()).append(" new directory blobs").toString());
            toCreateDirectories.foreach((Function1)(JProcedure1 & Serializable)newDirectory -> this.run(new StringBuilder(28).append("Creating new directory blob ").append((String)newDirectory).toString(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.sync$$anonfun$2$$anonfun$1(newDirectory))));
            this.log("Done creating directory blobs");
        }
        if (toUpload.nonEmpty()) {
            this.log(new StringBuilder(16).append("Uploading ").append(toUpload.length()).append(" files").toString());
            toUpload.withFilter((Function1 & Serializable)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    File file = (File)tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                File file = (File)tuple2._2();
                this.run(new StringBuilder(14).append("Uploading ").append(file).append(" to ").append(name).toString(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.sync$$anonfun$4$$anonfun$1(name, file)));
            });
            this.log("Done uploading");
        }
        if (toUpdate.nonEmpty()) {
            this.log(new StringBuilder(15).append("Updating ").append(toUpdate.length()).append(" blobs").toString());
            toUpdate.withFilter((Function1 & Serializable)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Blob blob = (Blob)tuple2._1();
                    File file = (File)tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Blob blob = (Blob)tuple2._1();
                File file = (File)tuple2._2();
                this.run(new StringBuilder(15).append("Updating ").append(blob.getName()).append(" from ").append(file).toString(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.sync$$anonfun$6$$anonfun$1(blob, file)));
            });
            this.log("Done updating");
        }
    }

    private void run(String message, Function0 action) {
        if (this.dryRun) {
            this.log(new StringBuilder(4).append("NOT ").append(message).toString());
        } else {
            this.log(message);
            action.apply$mcV$sp();
        }
    }

    private void createDirectoryBlob(String blobName) {
        this.storage.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)blobName)).build(), new Storage.BlobTargetOption[0]);
    }

    private void write(String blobName, File file) {
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(file.getName());
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)blobName)).setContentType(contentType).build();
        byte[] content = Files$.MODULE$.readFile(file);
        WriteChannel writer = this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]);
        writer.write(ByteBuffer.wrap(content, 0, content.length));
        writer.close();
    }

    private Map<String, File> listDirectory(String directoryPath) {
        return GoogleCloudStorageSynchronizer.listDirectories$1(package$.MODULE$.List().empty(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{new File(directoryPath)}))).map((Function1 & Serializable)file -> {
            String name = Strings$.MODULE$.drop(file.getAbsolutePath(), directoryPath);
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)(file.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : name));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, file);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Blob> listBucketDirectory(String bucketPrefix) {
        return this.listDirectories$2(package$.MODULE$.List().empty(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{bucketPrefix}))).map((Function1 & Serializable)blob -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)blob.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, blob);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private List<Blob> listBucketFiles(String bucketPrefix) {
        return GoogleCloudStorageSynchronizer.listPages$1(package$.MODULE$.List().empty(), this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)bucketPrefix)}));
    }

    private boolean isDirectory(Blob blob) {
        return blob.getName().endsWith("/");
    }

    private static final String name$2(Tuple2 x$1$1) {
        return (String)x$1$1._1();
    }

    private static final File _$2$1(Tuple2 x$1$2) {
        return (File)x$1$2._2();
    }

    private static final String name$3(Tuple2 x$1$3) {
        return (String)x$1$3._1();
    }

    private static final File _$3$1(Tuple2 x$1$4) {
        return (File)x$1$4._2();
    }

    private static final String _$4$1(Tuple2 x$1$5) {
        return (String)x$1$5._1();
    }

    private static final File file$3(Tuple2 x$1$6) {
        return (File)x$1$6._2();
    }

    private static final String name$4(Tuple2 x$1$7) {
        return (String)x$1$7._1();
    }

    private static final File _$5$1(Tuple2 x$1$8) {
        return (File)x$1$8._2();
    }

    private static final String _$6$1(Tuple2 x$1$9) {
        return (String)x$1$9._1();
    }

    private static final File file$4(Tuple2 x$1$10) {
        return (File)x$1$10._2();
    }

    private static final Blob blob$4(Tuple2 x$1$11) {
        return (Blob)x$1$11._1();
    }

    private static final File file$5(Tuple2 x$1$12) {
        return (File)x$1$12._2();
    }

    private static final Blob blob$5(Tuple2 x$1$13) {
        return (Blob)x$1$13._1();
    }

    private static final File file$6(Tuple2 x$1$14) {
        return (File)x$1$14._2();
    }

    private static final String status$1(boolean isDirectory) {
        return isDirectory ? "is" : "is not ";
    }

    private static final Blob _$7$1(Tuple2 x$1$15) {
        return (Blob)x$1$15._1();
    }

    private static final File file$7(Tuple2 x$1$16) {
        return (File)x$1$16._2();
    }

    private static final Blob blob$6(Tuple2 x$1$17) {
        return (Blob)x$1$17._1();
    }

    private static final File file$8(Tuple2 x$1$18) {
        return (File)x$1$18._2();
    }

    private static final Blob blob$7(Tuple2 x$1$19) {
        return (Blob)x$1$19._1();
    }

    private static final File file$9(Tuple2 x$1$20) {
        return (File)x$1$20._2();
    }

    private static final Blob blob$8(Tuple2 x$1$21) {
        return (Blob)x$1$21._1();
    }

    private static final File _$8$1(Tuple2 x$1$22) {
        return (File)x$1$22._2();
    }

    private static final void sync$$anonfun$1$$anonfun$1(Blob blob$2) {
        blob$2.delete(new Blob.BlobSourceOption[0]);
    }

    private final void sync$$anonfun$2$$anonfun$1(String newDirectory$1) {
        this.createDirectoryBlob(newDirectory$1);
    }

    private final void sync$$anonfun$4$$anonfun$1(String name$1, File file$1) {
        this.write(name$1, file$1);
    }

    private final void sync$$anonfun$6$$anonfun$1(Blob blob$3, File file$2) {
        this.write(blob$3.getName(), file$2);
    }

    private static final List listDirectories$1(List result, List directoriesToList) {
        List list = directoriesToList;
        List list2 = result;
        while (!list.isEmpty()) {
            List directories;
            List list3;
            block4: {
                Tuple2 tuple2;
                block3: {
                    File current = (File)list.head();
                    File gsignore = new File(current, ".gsignore");
                    Set ignore = !gsignore.exists() ? Predef$.MODULE$.Set().empty() : (Set)Files$.MODULE$.read(gsignore).toSet().$plus((Object)".gsignore");
                    tuple2 = Predef$.MODULE$.wrapRefArray((Object[])current.listFiles()).toList().filterNot((Function1 & Serializable)file -> ignore.contains((Object)file.getName())).partition((Function1 & Serializable)_$9 -> _$9.isDirectory());
                    if (tuple2 == null) break block3;
                    List list4 = (List)tuple2._1();
                    list3 = (List)tuple2._2();
                    if (!(list4 instanceof List)) break block3;
                    directories = list4;
                    if (list3 instanceof List) break block4;
                }
                throw new MatchError((Object)tuple2);
            }
            List files = list3;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)directories, (Object)files);
            List directories2 = (List)tuple2._1();
            List files2 = (List)tuple2._2();
            List list5 = (List)((IterableOps)list2.$plus$plus((IterableOnce)directories2)).$plus$plus((IterableOnce)files2);
            List list6 = (List)((IterableOps)list.tail()).$plus$plus((IterableOnce)directories2);
            list2 = list5;
            list = list6;
        }
        return list2;
    }

    private final List listDirectories$2(List result, List directoriesToList) {
        List list = directoriesToList;
        List list2 = result;
        while (!list.isEmpty()) {
            List directories;
            List list3;
            block4: {
                Tuple2 tuple2;
                block3: {
                    tuple2 = this.listBucketFiles((String)list.head()).partition((Function1 & Serializable)blob -> this.isDirectory((Blob)blob));
                    if (tuple2 == null) break block3;
                    List list4 = (List)tuple2._1();
                    list3 = (List)tuple2._2();
                    if (!(list4 instanceof List)) break block3;
                    directories = list4;
                    if (list3 instanceof List) break block4;
                }
                throw new MatchError((Object)tuple2);
            }
            List files = list3;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)directories, (Object)files);
            List directories2 = (List)tuple2._1();
            List files2 = (List)tuple2._2();
            List newDirectories = directories2.filterNot((Function1 & Serializable)directory -> list2.exists((Function1 & Serializable)_$10 -> {
                String string = _$10.getName();
                String string2 = directory.getName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }));
            List list5 = (List)((IterableOps)list2.$plus$plus((IterableOnce)newDirectories)).$plus$plus((IterableOnce)files2);
            List list6 = (List)((IterableOps)list.tail()).$plus$plus((IterableOnce)newDirectories.map((Function1 & Serializable)_$11 -> _$11.getName()));
            list2 = list5;
            list = list6;
        }
        return list2;
    }

    private static final List listPages$1(List result, Page page) {
        Page page2 = page;
        List list = result;
        while (page2 != null) {
            List list2 = (List)list.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala(page2.iterateAll()).asScala().toList());
            Page page3 = page2.getNextPage();
            list = list2;
            page2 = page3;
        }
        return list;
    }
}

