/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.app

import org.beangle.commons.io.IOs
import org.beangle.commons.lang.SystemInfo
import org.beangle.commons.lang.Strings
import java.io.File
import org.beangle.commons.logging.Logging

object Urp extends Logging {

  val home = UrpEnv.findHome()

  val env = new UrpEnv(home, UrpEnv.readConfig(home + "/conf.properties"))

  logger.info("Openurp Home:" + home)

  def base: String = {
    env.base
  }

  def cas: String = {
    env.cas
  }

  def portal: String = {
    env.portal
  }

  def api: String = {
    env.api
  }

  def webapp: String = {
    env.webapp
  }

  def static: String = {
    env.static
  }

  def properties: Map[String, String] = {
    env.properties
  }

  class Org {
    var id: Int = _
    var code: String = _
    var name: String = _
    var shortName: String = _
    var logoUrl: String = _
    var wwwUrl: String = _
  }
}
