/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.app.security

import org.beangle.commons.collection.Collections
import org.beangle.commons.net.http.HttpUtils.getText
import org.beangle.security.Securities
import org.beangle.security.authz.Authority
import org.openurp.app.util.JSON
import org.openurp.app.{Urp, UrpApp}

/**
 * @author chaostone
 */
object RemoteService {

  def roots: Option[Set[String]] = {
    val url = Urp.api + "/platform/user/roots.json?app=" + UrpApp.name
    getText(url) map { s =>
      val resources = Collections.newSet[String]
      resources ++= JSON.parse(s).asInstanceOf[Iterable[String]]
      resources.toSet
    }
  }

  def getAuthorities: collection.Seq[Authority] = {
    val url = Urp.api + "/platform/security/func/" + UrpApp.name + "/resources.json"
    val resources = Collections.newBuffer[Authority]
    val resourceJsons = JSON.parse(getText(url).orNull).asInstanceOf[Iterable[collection.Map[String, _]]]
    resourceJsons.map { r =>
      resources +=
        Authority(r("name").toString, r("scope").toString, r("roles").asInstanceOf[Iterable[Number]].map(_.intValue.toString).toSet)
    }
    resources
  }

  def getMenusJson: String = {
    getText(Urp.api + "/platform/security/func/" + UrpApp.name + "/menus/user/" + Securities.user + ".json").orNull
  }

  def getDomainMenusJson: String = {
    getText(Urp.api + "/platform/security/func/" + UrpApp.name + "/menus/user/" + Securities.user + ".json?forDomain=1").orNull
  }

  def getAppsJson: String = {
    getText(Urp.api + "/platform/user/apps/" + Securities.user + ".json").orNull
  }

  def getProfiles(userCode: String, domain: String, function: String): String = {
    val url = Urp.api + "/platform/user/profiles/" + userCode + ".json?domain=" + domain
    getText(url).orNull
  }

  def getOrg: Urp.Org = {
    val json = getText(Urp.api + "/platform/config/orgs.json").orNull
    val data = JSON.parse(json).asInstanceOf[collection.Map[String, Any]]
    val org = new Urp.Org
    data.get("id") foreach (e => org.id = e.asInstanceOf[Number].intValue)
    data.get("code") foreach (e => org.code = e.toString)
    data.get("name") foreach (e => org.name = e.toString)
    data.get("shortName") foreach (e => org.shortName = e.toString)
    data.get("logoUrl") foreach (e => org.logoUrl = e.toString)
    data.get("wwwUrl") foreach (e => org.wwwUrl = e.toString)
    org
  }
}
