/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.app.security

import org.beangle.cache.CacheManager
import org.openurp.app.util.JSON
import org.beangle.commons.collection.Collections

object DefaultProfileService {
  def toProfiles(str: String): List[Profile] = {
    val profiles = JSON.parse(str).asInstanceOf[Iterable[Map[String, _]]]
    val ps = profiles.map { p =>
      val propertyBuffer = p.asInstanceOf[Map[String, _]]("properties").asInstanceOf[Iterable[Map[String, Any]]]
      val properties = Collections.newMap[String, String]
      propertyBuffer foreach { kv =>
        val domain = kv("dimension").asInstanceOf[Map[String, Any]]
        properties.put(domain("name").toString, kv("value").toString)
      }
      Profile(properties.toMap)
    }
    ps.toList
  }
}

class DefaultProfileService(cacheManager: CacheManager) extends ProfileService {

  val cache = cacheManager.getCache("user-profile", classOf[String], classOf[List[Profile]])

  def get(user: String, domain: String): List[Profile] = {
    val elem = cache.get(s"${user}_$domain")
    elem match {
      case None =>
        val profiles = RemoteService.getProfiles(user, domain, null)
        val rs = DefaultProfileService.toProfiles(profiles)
        cache.put(s"${user}_$domain", rs)
        rs
      case Some(p) => p
    }
  }

}
