/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.Instant;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.file.digest.Sha1$;
import org.beangle.commons.io.IOs$;
import org.openurp.app.blob.BlobMeta;
import org.openurp.app.blob.Repository;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00014AAC\u0006\u0001)!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003\"\u0011!i\u0003A!b\u0001\n\u0003\u0001\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bQ\u0002A\u0011I\u001b\t\u000bm\u0002A\u0011\t\u001f\t\u000b\u0005\u0003A\u0011\t\"\t\u000b5\u0003A\u0011\t(\u0003\u001f1{7-\u00197SKB|7/\u001b;pefT!\u0001D\u0007\u0002\t\tdwN\u0019\u0006\u0003\u001d=\t1!\u00199q\u0015\t\u0001\u0012#A\u0004pa\u0016tWO\u001d9\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$H\u0007\u0002\u0017%\u0011ad\u0003\u0002\u000b%\u0016\u0004xn]5u_JL\u0018\u0001\u00022bg\u0016,\u0012!\t\t\u0003E%r!aI\u0014\u0011\u0005\u0011:R\"A\u0013\u000b\u0005\u0019\u001a\u0012A\u0002\u001fs_>$h(\u0003\u0002)/\u00051\u0001K]3eK\u001aL!AK\u0016\u0003\rM#(/\u001b8h\u0015\tAs#A\u0003cCN,\u0007%A\u0002eSJ\fA\u0001Z5sA\u00051A(\u001b8jiz\"2!\r\u001a4!\ta\u0002\u0001C\u0003 \u000b\u0001\u0007\u0011\u0005C\u0003.\u000b\u0001\u0007\u0011%\u0001\u0004sK6|g/\u001a\u000b\u0003me\u0002\"AF\u001c\n\u0005a:\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006u\u0019\u0001\r!I\u0001\u0002a\u0006!\u0001/\u0019;i)\ti\u0004\tE\u0002\u0017}\u0005J!aP\f\u0003\r=\u0003H/[8o\u0011\u0015Qt\u00011\u0001\"\u0003\r)(\u000f\u001c\u000b\u0003\u00072\u00032A\u0006 E!\t)%*D\u0001G\u0015\t9\u0005*A\u0002oKRT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n\u0019QK\u0015'\t\u000bmB\u0001\u0019A\u0011\u0002\rU\u0004Hn\\1e)\u0015y%\u000b\u0016/_!\ta\u0002+\u0003\u0002R\u0017\tA!\t\\8c\u001b\u0016$\u0018\rC\u0003T\u0013\u0001\u0007\u0011%\u0001\u0004g_2$WM\u001d\u0005\u0006+&\u0001\rAV\u0001\u0003SN\u0004\"a\u0016.\u000e\u0003aS!!\u0017%\u0002\u0005%|\u0017BA.Y\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000buK\u0001\u0019A\u0011\u0002\u0011\u0019LG.\u001a(b[\u0016DQaX\u0005A\u0002\u0005\nQa\\<oKJ\u0004")
public class LocalRepository
implements Repository {
    private final String base;
    private final String dir;

    @Override
    public final boolean remove(String folder, String sha) {
        return Repository.remove$(this, folder, sha);
    }

    @Override
    public String getPath(String folder, String name) {
        return Repository.getPath$(this, folder, name);
    }

    @Override
    public String getExt(String fileName) {
        return Repository.getExt$(this, fileName);
    }

    public String base() {
        return this.base;
    }

    public String dir() {
        return this.dir;
    }

    @Override
    public boolean remove(String p) {
        Predef$.MODULE$.require(p.startsWith("/"));
        String path = new StringBuilder(0).append(this.base()).append(this.dir()).append(p).toString();
        File file = new File(path);
        return file.exists() ? file.delete() : false;
    }

    @Override
    public Option<String> path(String p) {
        Predef$.MODULE$.require(p.startsWith("/"));
        File file = new File(new StringBuilder(0).append(this.base()).append(this.dir()).append(p).toString());
        return file.exists() ? new Some((Object)file.getAbsolutePath()) : None$.MODULE$;
    }

    @Override
    public Option<URL> url(String path) {
        Predef$.MODULE$.require(path.startsWith("/"));
        File file = new File(new StringBuilder(0).append(this.base()).append(this.dir()).append(path).toString());
        return file.exists() ? new Some((Object)file.toURI().toURL()) : None$.MODULE$;
    }

    @Override
    public BlobMeta upload(String folder, InputStream is, String fileName, String owner) {
        Predef$.MODULE$.require(folder.startsWith("/"));
        long time = System.currentTimeMillis();
        File file = new File(new StringBuilder(1).append(this.base()).append(this.dir()).append(folder).append("/").append(time).toString());
        FileOutputStream os = new FileOutputStream(file);
        IOs$.MODULE$.copy(is, (OutputStream)os);
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{os}));
        String sha = Sha1$.MODULE$.digest(file);
        File target = new File(new StringBuilder(1).append(this.base()).append(this.dir()).append(folder).append("/").append(sha).toString());
        file.renameTo(target);
        String ext = this.getExt(fileName);
        BlobMeta meta = new BlobMeta();
        meta.sha_$eq(sha);
        meta.updatedAt_$eq(Instant.now());
        meta.size_$eq((int)target.length());
        meta.mediaType_$eq(MediaTypes$.MODULE$.get(ext, MediaTypes$.MODULE$.ApplicationOctetStream()).toString());
        meta.path_$eq(new StringBuilder(1).append(folder).append("/").append(sha).toString());
        return meta;
    }

    public LocalRepository(String base, String dir) {
        this.base = base;
        this.dir = dir;
        Repository.$init$(this);
    }
}

