/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.blob;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.http.HttpMethods$;
import org.beangle.commons.net.http.Https$;
import org.openurp.app.blob.BlobMeta;
import org.openurp.app.blob.RemoteRepository$InstantConverter$;
import org.openurp.app.blob.Repository;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\r\u001a\u0001\tB\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tu\u0001\u0011\t\u0011)A\u0005_!A1\b\u0001BC\u0002\u0013\u0005a\u0006\u0003\u0005=\u0001\t\u0005\t\u0015!\u00030\u0011!i\u0004A!A!\u0002\u0013y\u0003\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000b}\u0002A\u0011\u0001!\t\u000f\u0019\u0003\u0001\u0019!C\u0005\u000f\"9!\u000b\u0001a\u0001\n\u0013\u0019\u0006BB-\u0001A\u0003&\u0001\nC\u0003[\u0001\u0011\u00053\fC\u0003a\u0001\u0011\u0005\u0013\rC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003r\u0001\u0011\u0005#\u000fC\u0004\u0002\n\u0001!I!a\u0003\u0007\r\u0005\u0005\u0002\u0001AA\u0012\u0011\u0019y\u0004\u0003\"\u0001\u0002N!9\u00111\u000b\t\u0005\u0002\u0005UsaBA>\u0001!\u0005\u0011Q\u0010\u0004\b\u0003\u007f\u0002\u0001\u0012AAA\u0011\u0019yD\u0003\"\u0001\u0002\u0018\"9\u0011\u0011\u0014\u000b\u0005B\u0005m\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0002\u0011%\u0016lw\u000e^3SKB|7/\u001b;pefT!AG\u000e\u0002\t\tdwN\u0019\u0006\u00039u\t1!\u00199q\u0015\tqr$A\u0004pa\u0016tWO\u001d9\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!fK\u0007\u00023%\u0011A&\u0007\u0002\u000b%\u0016\u0004xn]5u_JL\u0018\u0001\u00022bg\u0016,\u0012a\f\t\u0003a]r!!M\u001b\u0011\u0005I*S\"A\u001a\u000b\u0005Q\n\u0013A\u0002\u001fs_>$h(\u0003\u00027K\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1T%A\u0003cCN,\u0007%A\u0002eSJ\fA\u0001Z5sA\u0005!Qo]3s\u0003\rYW-_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u00135\tR#\u0011\u0005)\u0002\u0001\"B\u0017\b\u0001\u0004y\u0003\"B\u001e\b\u0001\u0004y\u0003\"B\u001f\b\u0001\u0004y\u0003\"\u0002 \b\u0001\u0004y\u0013\u0001\u00034pe6\fG/\u001a:\u0016\u0003!\u0003\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\r\u0019|'/\\1u\u0015\tie*\u0001\u0003uS6,'\"A(\u0002\t)\fg/Y\u0005\u0003#*\u0013\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u000311wN]7bi\u0016\u0014x\fJ3r)\t!v\u000b\u0005\u0002%+&\u0011a+\n\u0002\u0005+:LG\u000fC\u0004Y\u0013\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'A\u0005g_Jl\u0017\r^3sA\u00051!/Z7pm\u0016$\"\u0001X0\u0011\u0005\u0011j\u0016B\u00010&\u0005\u001d\u0011un\u001c7fC:DQ\u0001Y\u0006A\u0002=\nA\u0001]1uQR\u0011!-\u001a\t\u0004I\r|\u0013B\u00013&\u0005\u0019y\u0005\u000f^5p]\")a\r\u0004a\u0001_\u0005\t\u0001/A\u0002ve2$\"!\u001b9\u0011\u0007\u0011\u001a'\u000e\u0005\u0002l]6\tAN\u0003\u0002n\u001d\u0006\u0019a.\u001a;\n\u0005=d'aA+S\u0019\")\u0001-\u0004a\u0001_\u00051Q\u000f\u001d7pC\u0012$ra\u001d<y\u0003\u0003\t)\u0001\u0005\u0002+i&\u0011Q/\u0007\u0002\t\u00052|'-T3uC\")qO\u0004a\u0001_\u00051am\u001c7eKJDQ!\u001f\bA\u0002i\f!![:\u0011\u0005mtX\"\u0001?\u000b\u0005ut\u0015AA5p\u0013\tyHPA\u0006J]B,Ho\u0015;sK\u0006l\u0007BBA\u0002\u001d\u0001\u0007q&\u0001\u0005gS2,g*Y7f\u0011\u0019\t9A\u0004a\u0001_\u0005)qn\u001e8fe\u0006AAm\\+qY>\fG\rF\u0006t\u0003\u001b\ty!!\u0005\u0002\u0014\u0005u\u0001\"B4\u0010\u0001\u0004Q\u0007\"B=\u0010\u0001\u0004Q\bBBA\u0002\u001f\u0001\u0007q\u0006C\u0004\u0002\u0016=\u0001\r!a\u0006\u0002\rA\f'/Y7t!\u0015\u0001\u0014\u0011D\u00180\u0013\r\tY\"\u000f\u0002\u0004\u001b\u0006\u0004\bBBA\u0010\u001f\u0001\u0007!-A\u0005cCNL7-Q;uQ\nq\u0011J\\:uC:$\u0018\tZ1qi\u0016\u00148#\u0002\t\u0002&\u0005E\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-b*\u0001\u0003mC:<\u0017\u0002BA\u0018\u0003S\u0011aa\u00142kK\u000e$\bCBA\u001a\u0003\u0003\n)%\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u001197o\u001c8\u000b\t\u0005m\u0012QH\u0001\u0007O>|w\r\\3\u000b\u0005\u0005}\u0012aA2p[&!\u00111IA\u001b\u0005AQ5o\u001c8EKN,'/[1mSj,'\u000f\u0005\u0003\u0002H\u0005%S\"\u0001'\n\u0007\u0005-CJA\u0004J]N$\u0018M\u001c;\u0015\u0005\u0005=\u0003cAA)!5\t\u0001!A\u0006eKN,'/[1mSj,G\u0003CA#\u0003/\n\t'!\u001d\t\u000f\u0005e#\u00031\u0001\u0002\\\u0005!Q\r\\3n!\u0011\t\u0019$!\u0018\n\t\u0005}\u0013Q\u0007\u0002\f\u0015N|g.\u00127f[\u0016tG\u000fC\u0004\u0002dI\u0001\r!!\u001a\u0002\tQL\b/\u001a\t\u0005\u0003O\ni'\u0004\u0002\u0002j)!\u00111NA\u0015\u0003\u001d\u0011XM\u001a7fGRLA!a\u001c\u0002j\t!A+\u001f9f\u0011\u001d\t\u0019H\u0005a\u0001\u0003k\nqaY8oi\u0016DH\u000f\u0005\u0003\u00024\u0005]\u0014\u0002BA=\u0003k\u0011!DS:p]\u0012+7/\u001a:jC2L'0\u0019;j_:\u001cuN\u001c;fqR\f\u0001#\u00138ti\u0006tGoQ8om\u0016\u0014H/\u001a:\u0011\u0007\u0005ECC\u0001\tJ]N$\u0018M\u001c;D_:4XM\u001d;feN!AcIAB!\u001d\t))a%0\u0003\u000bj!!a\"\u000b\t\u0005%\u00151R\u0001\u000bG>tg/\u001a:tS>t'\u0002BAG\u0003\u001f\u000bqaY8n[>t7OC\u0002\u0002\u0012~\tqAY3b]\u001edW-\u0003\u0003\u0002\u0016\u0006\u001d%!C\"p]Z,'\u000f^3s)\t\ti(A\u0003baBd\u0017\u0010\u0006\u0003\u0002F\u0005u\u0005BBAP-\u0001\u0007q&A\u0003wC2,X-A\u0005o_Jl\u0017\r\\5{KR\u0019q&!*\t\r\u0005}u\u00031\u00010\u0001")
public class RemoteRepository
implements Repository {
    private volatile RemoteRepository$InstantConverter$ InstantConverter$module;
    private final String base;
    private final String dir;
    private final String user;
    private final String key;
    private DateTimeFormatter formater;

    @Override
    public final boolean remove(String folder, String sha) {
        return Repository.remove$(this, folder, sha);
    }

    @Override
    public String getPath(String folder, String name) {
        return Repository.getPath$(this, folder, name);
    }

    @Override
    public String getExt(String fileName) {
        return Repository.getExt$(this, fileName);
    }

    public RemoteRepository$InstantConverter$ InstantConverter() {
        if (this.InstantConverter$module == null) {
            this.InstantConverter$lzycompute$1();
        }
        return this.InstantConverter$module;
    }

    public String base() {
        return this.base;
    }

    public String dir() {
        return this.dir;
    }

    private DateTimeFormatter formater() {
        return this.formater;
    }

    private void formater_$eq(DateTimeFormatter x$1) {
        this.formater = x$1;
    }

    @Override
    public boolean remove(String path) {
        Predef$.MODULE$.require(path.startsWith("/"));
        URL url = new URL(new StringBuilder(0).append(this.base()).append(this.dir()).append(path).toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Https$.MODULE$.noverify(conn);
        conn.setDoOutput(true);
        conn.setRequestMethod(HttpMethods$.MODULE$.DELETE());
        String encoded = Base64.getEncoder().encodeToString(new StringBuilder(1).append(this.user).append(":").append(this.key).toString().getBytes(StandardCharsets.UTF_8));
        conn.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(encoded).toString());
        if (conn.getResponseCode() >= 300) {
            throw new Exception(new StringBuilder(31).append("Remove Failed,Response code is ").append(conn.getResponseCode()).toString());
        }
        return conn.getResponseCode() == 200;
    }

    @Override
    public Option<String> path(String p) {
        Predef$.MODULE$.require(p.startsWith("/"));
        return new Some((Object)new StringBuilder(0).append(this.base()).append(this.dir()).append(p).toString());
    }

    @Override
    public Option<URL> url(String path) {
        Predef$.MODULE$.require(path.startsWith("/"));
        String now = LocalDateTime.now().format(this.formater());
        String token = Digests$.MODULE$.sha1Hex(new StringBuilder(0).append(this.dir()).append(path).append(this.user).append(this.key).append(now).toString());
        return new Some((Object)new URL(new StringBuilder(13).append(this.base()).append(this.dir()).append(path).append("?token=").append(token).append("&u=").append(this.user).append("&t=").append(now).toString()));
    }

    @Override
    public BlobMeta upload(String folder, InputStream is, String fileName, String owner) {
        Predef$.MODULE$.require(folder.startsWith("/"));
        String folderUrl = folder.endsWith("/") ? folder : new StringBuilder(1).append(folder).append("/").toString();
        URL target = new URL(new StringBuilder(0).append(this.base()).append(this.dir()).append(folderUrl).toString());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)owner)}));
        return this.doUpload(target, is, fileName, (Map<String, String>)params, (Option<String>)new Some((Object)new StringBuilder(1).append(this.user).append(":").append(this.key).toString()));
    }

    private BlobMeta doUpload(URL url, InputStream is, String fileName, Map<String, String> params, Option<String> basicAuth) {
        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Https$.MODULE$.noverify(conn);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod(HttpMethods$.MODULE$.POST());
        conn.setRequestProperty("Content-Type", new StringBuilder(29).append("multipart/form-data;boundary=").append(boundary).toString());
        conn.setRequestProperty("Connection", "Keep-Alive");
        basicAuth.foreach((Function1 & Serializable)auth -> {
            RemoteRepository.$anonfun$doUpload$1(conn, auth);
            return BoxedUnit.UNIT;
        });
        OutputStream os = conn.getOutputStream();
        DataOutputStream ds = new DataOutputStream(os);
        scala.collection.mutable.StringBuilder text = new scala.collection.mutable.StringBuilder();
        params.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            text.append(twoHyphens).append(boundary).append(end);
            text.append(new StringBuilder(39).append("Content-Disposition: form-data; name=\"").append(k).append("\"").toString());
            text.append(end).append(end);
            scala.collection.mutable.StringBuilder stringBuilder = text.append(v).append(end);
            return stringBuilder;
        });
        ds.write(text.toString().getBytes());
        scala.collection.mutable.StringBuilder strBuf = new scala.collection.mutable.StringBuilder();
        strBuf.append(twoHyphens).append(boundary).append(end);
        strBuf.append(new StringBuilder(56).append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(fileName).append("\"").toString());
        strBuf.append(end).append(end);
        ds.write(strBuf.toString().getBytes());
        IOs$.MODULE$.copy(is, (OutputStream)ds);
        ds.writeBytes(end);
        ds.writeBytes(new StringBuilder(0).append(twoHyphens).append(boundary).append(twoHyphens).append(end).toString());
        ds.flush();
        ds.close();
        os.close();
        if (conn.getResponseCode() != 200) {
            Predef$.MODULE$.println((Object)IOs$.MODULE$.readString(conn.getInputStream(), IOs$.MODULE$.readString$default$2()));
            throw new Exception(new StringBuilder(31).append("Upload Failed,Response code is ").append(conn.getResponseCode()).toString());
        }
        String response = IOs$.MODULE$.readString(conn.getInputStream(), IOs$.MODULE$.readString$default$2());
        Gson gson = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).create();
        return (BlobMeta)gson.fromJson(response, BlobMeta.class);
    }

    public String normalize(String value) {
        String v = value.length() == 16 ? new StringBuilder(3).append(value).append(":00").toString() : value;
        return Strings$.MODULE$.replace(v, " ", "T");
    }

    private final void InstantConverter$lzycompute$1() {
        RemoteRepository remoteRepository = this;
        synchronized (remoteRepository) {
            if (this.InstantConverter$module == null) {
                this.InstantConverter$module = new RemoteRepository$InstantConverter$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doUpload$1(HttpURLConnection conn$1, String auth) {
        String encoded = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        conn$1.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(encoded).toString());
    }

    public RemoteRepository(String base, String dir, String user, String key) {
        this.base = base;
        this.dir = dir;
        this.user = user;
        this.key = key;
        Repository.$init$(this);
        this.formater = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        Predef$.MODULE$.require(!dir.endsWith("/"));
    }

    public class InstantAdapter
    implements JsonDeserializer<Instant> {
        public Instant deserialize(JsonElement elem, Type type, JsonDeserializationContext context) {
            return this.org$openurp$app$blob$RemoteRepository$InstantAdapter$$$outer().InstantConverter().apply(elem.getAsString());
        }

        public /* synthetic */ RemoteRepository org$openurp$app$blob$RemoteRepository$InstantAdapter$$$outer() {
            return RemoteRepository.this;
        }

        public InstantAdapter() {
            if (RemoteRepository.this == null) {
                throw null;
            }
        }
    }
}

