/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.security;

import java.util.Arrays;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.Conditions;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.security.data.Permission;
import org.beangle.security.data.Profile;

public final class SecurityUtils {
    public static void apply(OqlBuilder<?> builder, Permission permission, Profile ... profiles) {
        SecurityUtils.apply(builder, permission, Arrays.asList(profiles));
    }

    public static void apply(OqlBuilder<?> query, Permission permission, List<Profile> profiles) {
        List paramValues = CollectUtils.newArrayList();
        if (Strings.isEmpty((CharSequence)permission.getFilters())) {
            return;
        }
        String patternContent = permission.getFilters();
        patternContent = Strings.replace((String)patternContent, (String)"{alias}", (String)query.getAlias());
        String[] contents = Strings.split((String)Strings.replace((String)patternContent, (String)" and ", (String)"$"), (String)"$");
        List conditions = CollectUtils.newArrayList();
        for (Profile profile : profiles) {
            StringBuilder conBuilder = new StringBuilder("(");
            int i = 0;
            while (i < contents.length) {
                String content = contents[i];
                Condition c = new Condition(content);
                List params = c.getParamNames();
                for (String paramName : params) {
                    Object value = profile.getProperty(paramName);
                    if (value != null) {
                        if (value.equals("*")) {
                            content = "";
                            continue;
                        }
                        paramValues.add(value);
                        continue;
                    }
                    throw new RuntimeException(String.valueOf(paramName) + " had not been initialized");
                }
                if (conBuilder.length() > 1 && content.length() > 0) {
                    conBuilder.append(" and ");
                }
                conBuilder.append(content);
                ++i;
            }
            if (conBuilder.length() <= 1) continue;
            conBuilder.append(')');
            Condition con = new Condition(conBuilder.toString());
            con.params(paramValues);
            conditions.add(con);
        }
        if (!conditions.isEmpty()) {
            query.where(new Condition[]{Conditions.or((List)conditions)});
        }
    }
}

