/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.security.service;

import java.util.Map;
import java.util.Set;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.security.Request;
import org.beangle.security.access.AuthorityManager;
import org.beangle.security.core.context.SecurityContext;
import org.beangle.security.core.userdetail.DefaultAccount;
import org.openurp.app.security.FuncResource;
import org.openurp.app.security.service.RemoteAuthorityService;

public class CacheableAuthorityManager
extends BaseServiceImpl
implements AuthorityManager,
Initializing {
    protected Map<String, Set<?>> authorities = CollectUtils.newHashMap();
    protected Set<String> publicResources;
    protected Set<?> protectedResources;
    protected Set<String> roots;
    protected RemoteAuthorityService authorityService;
    protected Set<String> ignores = CollectUtils.newHashSet();

    public boolean isAuthorized(SecurityContext context) {
        return this.isAuthorized(context, context.getRequest());
    }

    public boolean isAuthorized(SecurityContext context, Request request) {
        String resourceName = request.getResource().toString();
        if (this.ignores.contains(resourceName)) {
            return true;
        }
        if (this.publicResources.contains(resourceName)) {
            return true;
        }
        if (context.getSession() == null) {
            return false;
        }
        if (this.protectedResources.contains(resourceName)) {
            return true;
        }
        DefaultAccount account = (DefaultAccount)context.getSession().getPrincipal();
        boolean isRoot = context.isRoot();
        if (isRoot) {
            return true;
        }
        String authorities = account.getAuthorities();
        String[] stringArray = Strings.split((String)authorities);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String authority = stringArray[n2];
            if (this.isAuthorizedByRole(authority, resourceName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isAuthorizedByRole(String authority, Object resource) {
        Set<?> actions = this.authorities.get(authority);
        if (actions == null) {
            actions = this.refreshRolePermissions(authority);
        }
        return actions.contains(resource);
    }

    public Set<?> refreshRolePermissions(String authority) {
        Set<String> actions = this.authorityService.getResourceNamesByRole(authority);
        this.authorities.put(authority, actions);
        this.logger.debug("Refresh role:{}'s permissions:{}", (Object)authority, actions);
        return actions;
    }

    public void refreshCache() {
        this.publicResources = this.authorityService.getResourceNamesByScope(FuncResource.Scope.Public);
        this.protectedResources = this.authorityService.getResourceNamesByScope(FuncResource.Scope.Protected);
        this.roots = this.authorityService.getRoots();
    }

    public void init() throws Exception {
        this.refreshCache();
    }

    public void setAuthorityService(RemoteAuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public boolean isRoot(String user) {
        return this.roots.contains(user);
    }

    public void setIgnores(Set<String> ignores) {
        this.ignores = ignores;
    }
}

