/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.security.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.conversion.impl.DefaultConversion;
import org.beangle.commons.lang.Strings;
import org.openurp.app.security.Dimension;
import org.openurp.app.security.service.UserDataProvider;
import org.openurp.app.security.service.UserDataResolver;

public class CsvDataResolver
implements UserDataResolver,
UserDataProvider {
    private static char lineSeperator = (char)10;

    @Override
    public String marshal(Dimension property, Collection<?> items) {
        if (items == null) {
            return null;
        }
        List properties = CollectUtils.newArrayList();
        if (property.getKeyName() != null) {
            properties.add(property.getKeyName());
        }
        if (property.getProperties() != null) {
            String[] names = Strings.split((String)property.getProperties(), (String)",");
            properties.addAll(Arrays.asList(names));
        }
        StringBuilder sb = new StringBuilder();
        if (properties.isEmpty()) {
            for (Object obj : items) {
                if (obj == null) continue;
                sb.append(String.valueOf(obj)).append(',');
            }
        } else {
            for (String prop : properties) {
                sb.append(prop).append(',');
            }
            sb.deleteCharAt(sb.length() - 1).append(lineSeperator);
            for (Object obj : items) {
                for (String prop : properties) {
                    Object value = null;
                    try {
                        value = PropertyUtils.getProperty((Object)obj, (String)prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    sb.append(String.valueOf(value)).append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(lineSeperator);
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public <T> List<T> unmarshal(Dimension property, String src) {
        String source = src.trim();
        if (Strings.isEmpty((CharSequence)source)) {
            return Collections.emptyList();
        }
        List properties = CollectUtils.newArrayList();
        if (property.getKeyName() != null) {
            properties.add(property.getKeyName());
        }
        if (property.getProperties() != null) {
            String[] names = Strings.split((String)property.getProperties(), (String)",");
            properties.addAll(Arrays.asList(names));
        }
        String[] datas = Strings.split((String)source, (char)lineSeperator);
        try {
            Class<?> type = null;
            type = Class.forName(property.getTypeName());
            List rs = CollectUtils.newArrayList();
            if (properties.isEmpty()) {
                DefaultConversion conversion = DefaultConversion.Instance;
                String[] stringArray = datas;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    String data = stringArray[n2];
                    rs.add(conversion.convert((Object)data, type));
                    ++n2;
                }
                return rs;
            }
            properties.clear();
            int startIndex = 0;
            String[] names = new String[]{property.getKeyName()};
            if (-1 != datas[0].indexOf(44)) {
                names = Strings.split((String)datas[0], (String)",");
                startIndex = 1;
            }
            properties.addAll(Arrays.asList(names));
            int i = startIndex;
            while (i < datas.length) {
                Object obj = type.newInstance();
                String[] dataItems = Strings.split((String)datas[i], (String)",");
                int j = 0;
                while (j < properties.size()) {
                    PropertyUtils.copyProperty(obj, (String)((String)properties.get(j)), (Object)dataItems[j]);
                    ++j;
                }
                rs.add(obj);
                ++i;
            }
            return rs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> getData(Dimension property, String source, Object ... keys) {
        List<T> values = this.unmarshal(property, source);
        if (keys.length > 0) {
            ArrayList<T> rs = new ArrayList<T>();
            HashSet<Object> keySet = new HashSet<Object>(Arrays.asList(keys));
            for (T t : values) {
                String k = PropertyUtils.getProperty(t, (String)property.getKeyName()).toString();
                if (!keySet.contains(k)) continue;
                rs.add(t);
            }
            return rs;
        }
        return values;
    }

    @Override
    public String getName() {
        return "csv";
    }
}

