/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.security.service;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.web.util.HttpUtils;
import org.beangle.security.data.Permission;
import org.beangle.security.data.Profile;
import org.beangle.security.data.ProfileService;
import org.openurp.app.Urp;
import org.openurp.app.UrpApp;
import org.openurp.app.security.DataPermission;
import org.openurp.app.security.Dimension;
import org.openurp.app.security.FuncResource;
import org.openurp.app.security.UserProfile;
import org.openurp.app.security.service.UserDataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAuthorityService
implements ProfileService,
Initializing {
    private static final Logger logger = LoggerFactory.getLogger(RemoteAuthorityService.class);
    private Cache userCache = null;
    private Cache sysCache = null;
    private Map<String, FuncResource> resourceCache = CollectUtils.newHashMap();
    private UserDataResolver dataResolver;

    public void init() throws Exception {
        this.userCache = CacheManager.getInstance().getCache("user_profile");
        if (null == this.userCache) {
            throw new RuntimeException("Cannot find user_profile cache in ehcache.xml");
        }
        this.sysCache = CacheManager.getInstance().getCache("user_data_permission");
        if (null == this.sysCache) {
            throw new RuntimeException("Cannot find user_data_permission cache in ehcache.xml");
        }
    }

    public Dimension getDimension(String fieldName) {
        Dimension dimension;
        Element dimensionElem = this.sysCache.get((Serializable)((Object)("dimension_" + fieldName)));
        Dimension dimension2 = dimension = dimensionElem == null ? null : (Dimension)((Object)dimensionElem.getObjectValue());
        if (null == dimension) {
            String url = Urp.Instance.getApi() + "/platform/user/dimensions/" + fieldName + ".json";
            String resources = HttpUtils.getResponseText((String)url);
            Map rs = (Map)new Gson().fromJson(resources, Map.class);
            if (rs.isEmpty()) {
                return null;
            }
            dimension = this.toDimension(rs);
            this.sysCache.put(new Element((Serializable)((Object)("dimension_" + fieldName)), (Serializable)((Object)dimension)));
        }
        return dimension;
    }

    private Dimension toDimension(Map data) {
        Dimension dimension = new Dimension();
        Iterator iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            PropertyUtils.copyProperty((Object)((Object)dimension), (String)((String)entry.getKey()), entry.getValue());
        }
        dimension.setMultiple(true);
        return dimension;
    }

    public List<Profile> getProfiles(String userCode, String function) {
        Element ele = this.userCache.get((Serializable)((Object)userCode));
        if (null == ele) {
            String url = Urp.Instance.getApi() + "/platform/user/profiles/" + userCode + ".json?domain=edu";
            String resources = HttpUtils.getResponseText((String)url);
            List rs = (List)new Gson().fromJson(resources, List.class);
            if (rs.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (Object o : rs) {
                Collection properties = (Collection)((Map)o).get("properties");
                UserProfile profile = new UserProfile();
                profiles.add(profile);
                for (Object p : properties) {
                    Map property = (Map)p;
                    Dimension dimension = this.toDimension((Map)property.get("dimension"));
                    Object v = property.get("value");
                    if (!v.equals("*")) {
                        v = this.unmarshal((String)v, dimension);
                    }
                    profile.getProperties().put(dimension.getName(), v);
                }
            }
            this.userCache.put(new Element((Object)userCode, profiles));
            return profiles;
        }
        return (List)((Object)ele.getValue());
    }

    public Permission getPermission(String user, String dataResource, String functionResource) {
        String key = user + "_" + dataResource;
        Element ele = this.sysCache.get((Serializable)((Object)key));
        if (null == ele) {
            String url = Urp.Instance.getApi() + "/platform/security/data/permissions/user/" + user + ".json?data=" + dataResource + "&app=" + UrpApp.getName();
            String resources = HttpUtils.getResponseText((String)url);
            Map rs = (Map)new Gson().fromJson(resources, Map.class);
            if (rs.isEmpty()) {
                return null;
            }
            DataPermission dp = new DataPermission();
            dp.setFilters((String)rs.get("filters"));
            dp.setActions((String)rs.get("actions"));
            this.sysCache.put(new Element((Serializable)((Object)key), (Serializable)dp));
            return dp;
        }
        return (DataPermission)ele.getValue();
    }

    private Object unmarshal(String value, Dimension property) {
        try {
            List returned = this.dataResolver.unmarshal(property, value);
            if (property.isMultiple()) {
                return returned;
            }
            return 1 != returned.size() ? null : returned.get(0);
        }
        catch (Exception e) {
            logger.error("exception with param type:" + property.getTypeName() + " value:" + value, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FuncResource getResource(String name) {
        if (this.resourceCache.isEmpty()) {
            RemoteAuthorityService remoteAuthorityService = this;
            synchronized (remoteAuthorityService) {
                if (this.resourceCache.isEmpty()) {
                    String url = Urp.Instance.getApi() + "/platform/security/func/" + UrpApp.getName() + "/resources.json";
                    String resources = HttpUtils.getResponseText((String)url);
                    List rs = (List)new Gson().fromJson(resources, List.class);
                    for (Object o : rs) {
                        Map m = (Map)o;
                        FuncResource resource = new FuncResource();
                        resource.setName(m.get("name").toString());
                        resource.setTitle(m.get("title").toString());
                        resource.setScope(FuncResource.Scope.valueOf(m.get("scope").toString()));
                        resource.setId(Double.valueOf(m.get("id").toString()).intValue());
                        this.resourceCache.put(resource.getName(), resource);
                    }
                }
            }
        }
        return this.resourceCache.get(name);
    }

    public Set<String> getRoots() {
        String url = Urp.Instance.getApi() + "/platform/user/roots.json?app=" + UrpApp.getName();
        try {
            String resources = HttpUtils.getResponseText((String)url);
            List rs = (List)new Gson().fromJson(resources, List.class);
            return new HashSet<String>(rs);
        }
        catch (Exception e) {
            logger.error("Cannot access {}", (Object)url);
            return Collections.emptySet();
        }
    }

    public Set<String> getResourceNamesByRole(String roleId) {
        String url = Urp.Instance.getApi() + "/platform/security/func/" + UrpApp.getName() + "/permissions/role/" + roleId + ".json";
        String resources = HttpUtils.getResponseText((String)url);
        List rs = (List)new Gson().fromJson(resources, List.class);
        Set s = CollectUtils.newHashSet();
        for (Object o : rs) {
            Map m = (Map)o;
            s.add(m.get("name").toString());
        }
        return s;
    }

    public Set<String> getResourceNamesByScope(FuncResource.Scope scope) {
        String url = Urp.Instance.getApi() + "/platform/security/func/" + UrpApp.getName() + "/resources.json?scope=" + scope.toString();
        try {
            String resources = HttpUtils.getResponseText((String)url);
            List rs = (List)new Gson().fromJson(resources, List.class);
            Set s = CollectUtils.newHashSet();
            for (Object o : rs) {
                Map m = (Map)o;
                s.add(m.get("name").toString());
            }
            return s;
        }
        catch (Exception e) {
            logger.error("Cannot access {}", (Object)url);
            return Collections.emptySet();
        }
    }

    public String extractResource(String uri) {
        int lastDot = -1;
        for (int i = 0; i < uri.length(); ++i) {
            char a = uri.charAt(i);
            if (a != '.' && a != '!') continue;
            lastDot = i;
            break;
        }
        if (lastDot < 0) {
            lastDot = uri.length();
        }
        return uri.substring(0, lastDot);
    }

    public void setDataResolver(UserDataResolver dataResolver) {
        this.dataResolver = dataResolver;
    }
}

