/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Urp {
    private static final Logger logger = LoggerFactory.getLogger(Urp.class);
    private final String home;
    private final String base;
    private final String cas;
    private final String api;
    private final String webapp;
    private final String portal;
    private final String cdn;
    private final Map<String, String> properties;
    public static Urp Instance = new Urp(Urp.findHome(), Urp.readConfig(Urp.findHome()));

    public Urp(String home, Map<String, String> properties) {
        this.home = home;
        this.properties = properties;
        logger.info("Openurp Home:{}", (Object)this.home);
        if (!properties.containsKey("openurp.base")) {
            throw new RuntimeException("Cannot find openurp.base");
        }
        this.base = this.processUrl(properties.get("openurp.base"));
        this.cas = this.readBase("openurp.cas");
        this.api = this.readBase("openurp.api");
        this.webapp = this.readBase("openurp.webapp");
        this.portal = this.readBase("openurp.portal");
        this.cdn = this.readBase("openurp.static");
    }

    private String processUrl(String b) {
        if (b.endsWith("/")) {
            b = b.substring(0, b.length() - 1);
        }
        if (!b.startsWith("http")) {
            b = "http://" + b;
        }
        return b;
    }

    private String readBase(String property) {
        String b = this.properties.get(property);
        if (null == b) {
            b = property.equals("openurp.webapp") ? this.properties.get("openurp.base") : this.properties.get("openurp.base") + "/" + Strings.replace((String)property, (String)"openurp.", (String)"");
        }
        return this.processUrl(b);
    }

    public String getHome() {
        return this.home;
    }

    public String getWebappPath(String appPath) {
        return this.webapp + appPath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getBase() {
        return this.base;
    }

    public String getApi() {
        return this.api;
    }

    public String getCas() {
        return this.cas;
    }

    public String getPortal() {
        return this.portal;
    }

    public String getCdn() {
        return this.cdn;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public String getStatic() {
        return this.cdn;
    }

    public static Urp getInstance() {
        return Instance;
    }

    public static String findHome() {
        String home = System.getProperty("openurp.home");
        if (home == null) {
            home = SystemInfo.getUser().getHome() + "/.openurp";
        }
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readConfig(String home) {
        Map properties;
        block5: {
            properties = CollectUtils.newHashMap();
            File f = new File(home + "/conf.properties");
            if (!f.exists()) break block5;
            Properties p = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                p.load(is);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOs.close(is);
                    throw throwable;
                }
                IOs.close((Closeable)is);
            }
            IOs.close((Closeable)is);
            for (Object k : p.keySet()) {
                properties.put(k.toString(), p.getProperty(k.toString()).toString());
            }
        }
        return properties;
    }
}

