/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.app.web

import org.beangle.commons.codec.digest.Digests
import org.beangle.commons.collection.Collections
import org.beangle.security.Securities
import org.beangle.webmvc.api.context.ActionContext
import org.openurp.app.{ Urp, UrpApp }
import org.openurp.app.security.RemoteService

import javax.servlet.http.HttpServletRequest
import org.beangle.commons.web.url.UrlBuilder
import org.beangle.commons.web.util.RequestUtils

object NavContext {
  def get(request: HttpServletRequest): NavContext = {
    val ctx = new NavContext
    ctx.menusJson = RemoteService.getDomainMenusJson()
    ctx.org = RemoteService.getOrg()
    val builder = new UrlBuilder(request.getContextPath())
    builder.setScheme(if (RequestUtils.isHttps(request)) "https" else "http")
      .setServerName(request.getServerName)
      .setPort(RequestUtils.getServerPort(request))
    ctx.app = App(UrpApp.name, builder.buildUrl())
    ctx.params += ("openurp.webapp" -> Urp.webapp)
    if (null == ActionContext.current) {
      val names = request.getParameterNames
      while (names.hasMoreElements()) {
        val n = names.nextElement()
        ctx.params.put(n, request.getParameter(n))
      }
    } else {
      ActionContext.current.params foreach {
        case (k, v) =>
          ctx.params += (k -> v.toString)
      }
    }
    ctx
  }
}

class NavContext {
  var menusJson: String = _
  var org: Urp.Org = _
  var app: App = _
  var user = Securities.session.get.principal
  val params = Collections.newMap[String, String]
  def urp = Urp

  def avatarUrl: String = {
    Urp.api + "/platform/user/avatars/" + Digests.md5Hex(user.getName)
  }
}

case class App(name: String, base: String) {
}
