/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2005, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.app.web

import org.beangle.commons.codec.digest.Digests
import org.beangle.commons.collection.Collections
import org.beangle.security.Securities
import org.openurp.app.{ Urp, UrpApp }
import org.openurp.app.security.RemoteService

import javax.servlet.http.HttpServletRequest

object NavContext {
  def get(request: HttpServletRequest): NavContext = {
    val ctx = new NavContext
    ctx.appsJson = RemoteService.getAppsJson()
    ctx.menusJson = RemoteService.getMenusJson()
    ctx.org = RemoteService.getOrg()
    ctx.app = App(UrpApp.name, request.getContextPath)
    ctx.params += ("openurp.webapp" -> Urp.webappBase)
    val names = request.getParameterNames
    while (names.hasMoreElements()) {
      val n = names.nextElement()
      ctx.params.put(n, request.getParameter(n))
    }
    ctx
  }
}

class NavContext {
  var appsJson: String = _
  var menusJson: String = _
  var org: Urp.Org = _
  var app: App = _
  var user = Securities.session.get.principal
  val params = Collections.newMap[String, String]
  def urp = Urp

  def avatarUrl: String = {
    Urp.platformBase + "/user/avatars/" + Digests.md5Hex(user.getName)
  }
}

case class App(name: String, contextPath: String) {
}
