/*
 * Copyright (C) 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.openurp.degree.thesis.model

import org.beangle.data.model.LongId
import org.beangle.data.model.pojo.Updated

/** 学位论文相关文档
 */
class ThesisDoc extends LongId, Updated {
  /** 所处阶段 */
  var stage: Stage = _

  /** 学生 */
  var writer: Writer = _

  /** 附件路径 */
  var filePath: String = _

  /** 附件类型 */
  var fileExt: String = _

  /** 文档类型 */
  var docType: ThesisDocType = _

}
