/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.service.doc;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.ResourceStatus;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.openurp.base.std.model.StudentState;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.doc.AbstractFileGenerator$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public abstract class AbstractFileGenerator {
    private final int LineMaxLength;

    public static Tuple2<String, String> splitTitle(String string, int n) {
        return AbstractFileGenerator$.MODULE$.splitTitle(string, n);
    }

    public AbstractFileGenerator() {
        this.LineMaxLength = 24;
    }

    public int LineMaxLength() {
        return this.LineMaxLength;
    }

    public Option<URL> getTemplate(String name) {
        Option option = ClassLoaders$.MODULE$.getResources("org/openurp/degree/thesis/template/" + name, ClassLoaders$.MODULE$.getResources$default$2()).headOption();
        if (None$.MODULE$.equals(option)) {
            URL url = new URL(Ems$.MODULE$.api() + "/platform/config/files/" + EmsApp$.MODULE$.name() + "/org/openurp/degree/thesis/template/" + name);
            ResourceStatus status = HttpUtils$.MODULE$.access(url);
            if (status.isOk()) {
                return Some$.MODULE$.apply((Object)url);
            }
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            URL url = (URL)some.value();
            Some a = some;
            return a;
        }
        throw new MatchError((Object)option);
    }

    public Map<String, String> extract(Writer writer) {
        Map data = Collections$.MODULE$.newMap();
        ObjectRef tm1 = ObjectRef.create((Object)"");
        ObjectRef tm2 = ObjectRef.create((Object)"");
        writer.thesisTitle().foreach((Function1 & Serializable)title -> {
            Tuple2<String, String> tms = AbstractFileGenerator$.MODULE$.splitTitle((String)title, this.LineMaxLength());
            tm1$1.elem = (String)tms._1();
            tm2$1.elem = (String)tms._2();
            return data.put((Object)"thesis_title", title);
        });
        data.put((Object)"thesis_title1", (Object)((String)tm1.elem));
        data.put((Object)"thesis_title2", (Object)((String)tm2.elem));
        data.put((Object)"department_name", (Object)((StudentState)writer.std().state().get()).department().name());
        data.put((Object)"major_name", (Object)((StudentState)writer.std().state().get()).major().name());
        data.put((Object)"squad_name", (Object)((String)writer.squad().map((Function1 & Serializable)_$1 -> _$1.name()).getOrElse(AbstractFileGenerator::extract$$anonfun$3) + "\u73ed"));
        data.put((Object)"std_code", (Object)writer.code());
        data.put((Object)"std_name", (Object)writer.name());
        data.put((Object)"advisor_name", writer.advisor().map((Function1 & Serializable)_$2 -> _$2.name()).getOrElse(AbstractFileGenerator::extract$$anonfun$5));
        return data;
    }

    public void addDate(String name, Option<Instant> oi, Map<String, String> data) {
        data.put((Object)name, (Object)"    \u5e74    \u6708   \u65e5");
        oi.foreach((Function1 & Serializable)i -> {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYY\u5e74 MM\u6708 dd\u65e5");
            return data.put((Object)name, (Object)formatter.format(i.atZone(ZoneId.systemDefault())));
        });
    }

    public void addScore(String name, Option<Object> value, Map<String, String> data) {
        value.foreach((Function1 & Serializable)v -> data.put((Object)name, (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)v)).toString()));
    }

    public File getDepartZipFile(long seasonId, int departId, String docType) {
        return new File(System.getProperty("java.io.tmpdir") + ("season" + seasonId) + Files$.MODULE$.$div() + (docType + departId + ".zip"));
    }

    public String getDepartFolder(long seasonId, int departId, String docType) {
        File file = new File(System.getProperty("java.io.tmpdir") + ("season" + seasonId) + Files$.MODULE$.$div() + (docType + departId) + Files$.MODULE$.$div());
        if (file.exists()) {
            Files$.MODULE$.travel(file, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        file.mkdirs();
        return file.getAbsolutePath();
    }

    private static final String extract$$anonfun$3() {
        return "--";
    }

    private static final String extract$$anonfun$5() {
        return "--";
    }
}

