/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.service.impl;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.DefenseGroup;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.service.DefenseGroupService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.runtime.ScalaRunTime$;

public class DefenseGroupServiceImpl
implements DefenseGroupService {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public Seq<DefenseGroup> getGroups(Teacher me, GraduateSeason season) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
        query.where("dg.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("exists(from dg.members as m where m.teacher=:me) or dg.secretary.code=:secretary", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{me, me.code()}));
        return this.entityDao().search((QueryBuilder)query);
    }

    @Override
    public boolean isGroupAdmin(DefenseGroup group, Advisor advisor) {
        Option option = advisor.teacher().office();
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            TeachingOffice o = (TeachingOffice)((Some)option).value();
            return group.office().contains((Object)o);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public boolean isGroupManager(DefenseGroup group, Teacher me) {
        if (group.members().exists((Function1 & Serializable)x -> {
            Teacher teacher = x.teacher();
            Teacher teacher2 = me;
            return !(teacher != null ? !teacher.equals(teacher2) : teacher2 != null) && x.leader();
        })) {
            return true;
        }
        return group.secretary().contains((Object)me);
    }

    @Override
    public boolean isOfficeHead(Advisor advisor) {
        Option option = advisor.teacher().office();
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            TeachingOffice o = (TeachingOffice)((Some)option).value();
            Option option2 = o.director();
            if (None$.MODULE$.equals(option2)) {
                return false;
            }
            if (option2 instanceof Some) {
                Teacher d = (Teacher)((Some)option2).value();
                String string = d.code();
                String string2 = advisor.teacher().code();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Iterable<Teacher> getManageTeacher(Advisor advisor, GraduateSeason season) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisReview.class.getName(), "review");
        query.where("review.writer.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("review.crossReviewManager=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        query.where("review.writer.advisor is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.select("distinct review.writer.advisor.teacher");
        Seq t1 = this.entityDao().search((QueryBuilder)query);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Advisor.class.getName(), "advisor");
        query2.where("advisor.teacher.office.director=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        query2.where("advisor.endOn is null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query2.select("advisor.teacher");
        Seq t2 = this.entityDao().search((QueryBuilder)query2);
        Set rs = Collections$.MODULE$.newSet();
        rs.$plus$plus$eq((IterableOnce)t1);
        rs.$plus$plus$eq((IterableOnce)t2);
        return rs.toSeq();
    }
}

