/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.advisor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.User;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.DefenseGroup;
import org.openurp.degree.thesis.model.DefenseMember;
import org.openurp.degree.thesis.model.DefenseNotice;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DefenseGroupService;
import org.openurp.degree.thesis.service.doc.DefenseReport$;
import org.openurp.degree.thesis.web.action.advisor.AdvisorSupport;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import org.openurp.degree.thesis.web.helper.ScoreTextHelper$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DefenseAction
extends AdvisorSupport {
    private DefenseGroupService groupService;

    public DefenseGroupService groupService() {
        return this.groupService;
    }

    public void groupService_$eq(DefenseGroupService x$1) {
        this.groupService = x$1;
    }

    public View index() {
        Advisor advisor = this.getAdvisor();
        Seq<DefenseGroup> myGroups = this.groupService().getGroups(advisor.teacher(), this.thesisPlanService().getSeason());
        this.put("myGroups", myGroups);
        Map groupReviews = ((IterableOnceOps)myGroups.map((Function1 & Serializable)group -> {
            Map reviews = group.writers().isEmpty() ? Predef$.MODULE$.Map().empty() : ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)group.orderedWriters()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return Tuple2$.MODULE$.apply(group, (Object)reviews);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("myGroupReviews", groupReviews);
        Seq manageGroups = (Seq)myGroups.filter((Function1 & Serializable)g -> this.groupService().isGroupManager((DefenseGroup)g, advisor.teacher()));
        this.put("manageGroups", manageGroups);
        this.put("isOfficeHead", BoxesRunTime.boxToBoolean((boolean)this.groupService().isOfficeHead(advisor)));
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("defenseGroup", defenseGroup);
        this.put("writers", defenseGroup.orderedWriters());
        return this.forward(this.forward$default$1());
    }

    public View advisors() {
        Advisor advisor = this.getAdvisor();
        advisor.teacher().office().foreach((Function1)(JProcedure1 & Serializable)office -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class, "advisor");
            query.where("advisor.teacher.office=:office", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            Seq advisors = (Seq)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)x -> x.teacher());
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(DefenseMember.class, "dm");
            query2.where("dm.group.office=:office", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            Seq members = this.entityDao().search((QueryBuilder)query2);
            ArrayBuffer teachers = new ArrayBuffer();
            teachers.$plus$plus$eq((IterableOnce)advisors);
            HashMap groups = new HashMap();
            members.foreach((Function1 & Serializable)m -> {
                if (!teachers.contains((Object)m.teacher())) {
                    teachers.$plus$eq((Object)m.teacher());
                }
                ArrayBuffer userGroups = (ArrayBuffer)groups.getOrElseUpdate((Object)m.teacher(), DefenseAction::$anonfun$5);
                return (ArrayBuffer)userGroups.$plus$eq((Object)m.group());
            });
            this.put("office", office);
            this.put("users", teachers);
            this.put("groups", groups);
        });
        return this.forward(this.forward$default$1());
    }

    public View writers() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = this.thesisPlanService().getSeason();
        advisor.teacher().office().foreach((Function1)(JProcedure1 & Serializable)office -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
            query.where("dg.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
            query.where("dg.office=:office", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            Seq groups = this.entityDao().search((QueryBuilder)query);
            HashMap writerGroups = new HashMap();
            groups.foreach((Function1)(JProcedure1 & Serializable)group -> group.writers().foreach((Function1 & Serializable)writer -> writerGroups.put((Object)writer.writer(), group)));
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(Writer.class, "writer");
            query2.where("writer.advisor.teacher.office=:office", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            Seq writers = this.entityDao().search((QueryBuilder)query2);
            Tuple2 writers2 = writers.partition((Function1 & Serializable)key -> writerGroups.contains(key));
            this.put("groups", writerGroups);
            Seq inGroupWriters = (Seq)((SeqOps)writers2._1()).sortBy((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)((DefenseGroup)writerGroups.apply(x)).idx()).toString() + ((Advisor)x.advisor().get()).code() + x.code(), (Ordering)Ordering.String$.MODULE$);
            this.put("inGroupWriters", inGroupWriters);
            this.put("noGroupWriters", writers2._2());
        });
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("defenseGroup", defenseGroup);
        this.put("writers", defenseGroup.orderedWriters());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class.getName(), "advisor");
        query.orderBy("advisor.teacher.department.name,advisor.teacher.name");
        query.select("advisor.teacher");
        Buffer teachers = this.entityDao().search((QueryBuilder)query).toBuffer();
        scala.collection.immutable.Set writerAdvisors = ((IterableOnceOps)((IterableOps)defenseGroup.writers().filter((Function1 & Serializable)_$2 -> _$2.writer().advisor().nonEmpty())).map((Function1 & Serializable)_$3 -> ((Advisor)_$3.writer().advisor().get()).teacher())).toSet();
        teachers.subtractAll((IterableOnce)writerAdvisors);
        Buffer myDeparts = (Buffer)teachers.filter((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = defenseGroup.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        teachers.subtractAll((IterableOnce)myDeparts);
        teachers.prependAll((IterableOnce)myDeparts);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)defenseGroup.season().project().school());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, myDeparts.map((Function1 & Serializable)_$4 -> _$4.code()));
        Seq secretaries = this.entityDao().findBy(User.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("secretaries", secretaries);
        this.put("advisors", teachers);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="new", view="new,form")
    public View editNew() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup defenseGroup = new DefenseGroup(season, advisor.teacher().department());
        this.put("defenseGroup", defenseGroup);
        OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class, "advisor");
        query.orderBy("advisor.teacher.department.name,advisor.teacher.name");
        Buffer advisors = this.entityDao().search((QueryBuilder)query).toBuffer();
        Set writerAdvisors = (Set)defenseGroup.writers().flatMap((Function1 & Serializable)_$5 -> _$5.writer().advisor());
        advisors.subtractAll((IterableOnce)writerAdvisors);
        Buffer myDeparts = (Buffer)advisors.filter((Function1 & Serializable)x -> {
            Department department = x.teacher().department();
            Department department2 = defenseGroup.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        advisors.subtractAll((IterableOnce)myDeparts);
        advisors.prependAll((IterableOnce)myDeparts);
        this.put("myDepartAdvisors", myDeparts);
        this.put("advisors", advisors);
        return this.forward(this.forward$default$1());
    }

    @mapping(method="delete")
    public View remove() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(defenseGroup, advisor)) {
            this.entityDao().remove((Object)defenseGroup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        }
        return this.redirect("index", "info.remove.success");
    }

    public View removeAdvisor() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(group, advisor)) {
            DefenseMember removed = (DefenseMember)this.entityDao().get(DefenseMember.class, this.getLong("defenseMember.id").get());
            group.members().subtractOne((Object)removed);
            this.entityDao().saveOrUpdate((Object)group, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        }
        return this.redirect("edit", "id=" + group.id(), "info.remove.success");
    }

    public View save() {
        DefenseGroup defenseGroup;
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        Option option = this.getLong("defenseGroup.id");
        if (None$.MODULE$.equals(option)) {
            defenseGroup = new DefenseGroup(season, advisor.teacher().department());
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else {
            throw new MatchError((Object)option);
        }
        DefenseGroup group = defenseGroup;
        group.office_$eq(advisor.teacher().office());
        group.place_$eq(this.get("defenseGroup.place"));
        group.beginAt_$eq(this.getInstant("defenseGroup.beginAt"));
        group.endAt_$eq(this.getInstant("defenseGroup.endAt"));
        group.secretary_$eq(this.getLong("defenseGroup.secretary.id").map((Function1 & Serializable)x -> this.save$$anonfun$1(BoxesRunTime.unboxToLong((Object)x))));
        group.idx_$eq(this.getInt("defenseGroup.idx", 1));
        this.entityDao().saveOrUpdate((Object)group, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        return this.redirect("index", "info.save.success");
    }

    public View removeWriter() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(defenseGroup, advisor) && !defenseGroup.published()) {
            Writer removed = (Writer)this.entityDao().get(Writer.class, this.getLong("writer.id").get());
            defenseGroup.removeWriter((Iterable)new .colon.colon((Object)removed, (List)Nil$.MODULE$));
            this.entityDao().saveOrUpdate((Object)defenseGroup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
            String msg = "\u4ece\u7b2c" + defenseGroup.idx() + "\u7ec4\u4e2d\u79fb\u9664" + removed.std().name();
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.std.code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)removed.std().code());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"group.id");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)defenseGroup.id().toString());
            this.businessLogger().info(msg, defenseGroup.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "info.remove.success");
    }

    public View addWriterList() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        this.put("defenseGroup", group);
        if (this.groupService().isGroupAdmin(group, advisor)) {
            Buffer advisors = (Buffer)group.members().map((Function1 & Serializable)_$6 -> _$6.teacher());
            OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
            query.where("writer.advisor.teacher.office=:office", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher().office().get()}));
            if (advisors.nonEmpty()) {
                query.where("writer.advisor.teacher not in(:advisors)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisors}));
            }
            query.where("not exists(from " + DefenseGroup.class.getName() + " dg join dg.writers as wr where wr.writer=writer)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            Seq writers = this.entityDao().search((QueryBuilder)query);
            this.put("writers", writers);
        } else {
            this.put("writers", package$.MODULE$.List().empty());
        }
        return this.forward(this.forward$default$1());
    }

    public View addWriter() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(defenseGroup, advisor)) {
            scala.collection.immutable.Set advisors = ((IterableOnceOps)defenseGroup.members().map((Function1 & Serializable)_$7 -> _$7.teacher())).toSet();
            Seq added = this.entityDao().find(Writer.class, this.getAll("writer.id", Long.TYPE, ClassTag$.MODULE$.apply(Long.TYPE)));
            added.foreach((Function1)(JProcedure1 & Serializable)add -> {
                if (!advisors.contains((Object)((Advisor)add.advisor().get()).teacher())) {
                    defenseGroup.addWriters((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[]{add})));
                    return;
                }
            });
            this.entityDao().saveOrUpdate((Object)defenseGroup, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "info.remove.success");
    }

    public View autoAddWriter() {
        Advisor advisor = this.getAdvisor();
        int newCount = this.getInt("newCount", 0);
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (defenseGroup.office().contains(advisor.teacher().office().get()) && newCount > 0) {
            int i;
            Buffer advisors = (Buffer)defenseGroup.members().map((Function1 & Serializable)_$8 -> _$8.teacher());
            OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
            query.where("writer.advisor.teacher.office=:office", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher().office().get()}));
            if (advisors.nonEmpty()) {
                query.where("writer.advisor.teacher not in(:advisors)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisors}));
            }
            query.where("not exists(from " + DefenseGroup.class.getName() + " dg join dg.writers as wr where wr.writer=writer)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            Seq writers = this.entityDao().search((QueryBuilder)query);
            Iterator writerIter = writers.iterator();
            for (i = 0; i < newCount && writerIter.hasNext(); ++i) {
                Writer writer = (Writer)writerIter.next();
                defenseGroup.addWriters((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[]{writer})));
            }
            return this.redirect("edit", "id=" + defenseGroup.id(), "\u6210\u529f\u6dfb\u52a0\u4e86" + i + "\u540d\u5b66\u751f");
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "\u6210\u529f\u6dfb\u52a0\u4e860\u540d\u5b66\u751f");
    }

    public View notices() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = this.thesisPlanService().getSeason();
        OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
        query.where("dg.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.join("dg.members", "member");
        query.where("member.teacher=:me and member.leader=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        Seq groups = this.entityDao().search((QueryBuilder)query);
        Seq notices = (Seq)groups.flatMap((Function1 & Serializable)g -> g.notices());
        this.put("notices", notices);
        return this.forward(this.forward$default$1());
    }

    public View removeNotice() {
        Advisor advisor = this.getAdvisor();
        this.getLong("notice.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)noticeId -> {
            DefenseNotice notice = (DefenseNotice)this.entityDao().get(DefenseNotice.class, (Object)BoxesRunTime.boxToLong((long)noticeId));
            if (this.groupService().isGroupManager(notice.group(), advisor.teacher())) {
                this.entityDao().remove((Object)notice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseNotice[0]));
                return;
            }
        });
        return this.redirect("index", "info.remove.success");
    }

    public View saveNotice() {
        Advisor advisor = this.getAdvisor();
        this.getLong("notice.group.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)groupId -> {
            DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)groupId));
            if (this.groupService().isGroupManager(group, advisor.teacher())) {
                DefenseNotice notice = (DefenseNotice)this.getLong("notice.id").map((Function1 & Serializable)id -> this.$anonfun$18(BoxesRunTime.unboxToLong((Object)id))).getOrElse(DefenseAction::$anonfun$19);
                notice.group_$eq(group);
                notice.title_$eq((String)this.get("notice.title", "--"));
                notice.contents_$eq((String)this.get("notice.contents", "--"));
                notice.updatedAt_$eq(Instant.now());
                this.entityDao().saveOrUpdate((Object)notice, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseNotice[0]));
                return;
            }
        });
        return this.redirect("index", "info.save.success");
    }

    public View report() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        Map reviews = group.writers().isEmpty() ? Predef$.MODULE$.Map().empty() : ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)group.orderedWriters()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HSSFWorkbook hsw = DefenseReport$.MODULE$.render(group, (Map<Writer, ThesisReview>)reviews);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hsw.write((OutputStream)bos);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(bos.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u7b54\u8fa9\u4fe1\u606f\u8868.xls", Stream$.MODULE$.apply$default$4());
    }

    public View paperZip() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        List papers = group.writers().isEmpty() ? package$.MODULE$.List().empty() : this.entityDao().findBy(ThesisPaper.class, "writer", (Object)group.orderedWriters());
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        File targetZip = PaperDownloadHelper$.MODULE$.zipGroupPapers(season, group, (Iterable<ThesisPaper>)papers);
        String fileName = season.name() + "_" + group.department().name() + "_\u7b2c" + group.idx() + "\u7ec4\u8bba\u6587.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public View inputScore() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = this.thesisPlanService().getSeason();
        OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
        query.where("dg.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("exists(from dg.members as m where m.teacher=:me and m.leader=true)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        this.getLong("id").foreach((Function1 & Serializable)id -> DefenseAction.inputScore$$anonfun$1(query, BoxesRunTime.unboxToLong((Object)id)));
        Seq myGroups = this.entityDao().search((QueryBuilder)query);
        Seq writers = (Seq)myGroups.flatMap((Function1 & Serializable)_$9 -> (IterableOnce)_$9.writers().map((Function1 & Serializable)_$10 -> _$10.writer()));
        this.put("myGroups", myGroups);
        Map reviews = ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("reviews", reviews);
        return this.forward(this.forward$default$1());
    }

    public View saveScore() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("group")));
        Seq reviews = this.entityDao().find(ThesisReview.class, (Iterable)this.getLongIds("review"));
        reviews.foreach((Function1)(JProcedure1 & Serializable)r -> {
            Option option = this.getInt("defense_score_" + r.id());
            if (None$.MODULE$.equals(option)) {
                r.defenseScore_$eq((Option)None$.MODULE$);
                r.finalScore_$eq((Option)None$.MODULE$);
                r.finalScoreText_$eq((Option)None$.MODULE$);
                return;
            }
            if (option instanceof Some) {
                int s = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                int score = Predef$.MODULE$.long2Long(Math.round((double)BoxesRunTime.unboxToInt((Object)r.crossReviewScore().getOrElse(DefenseAction::$anonfun$23)) * 0.6 + (double)s * 0.4)).intValue();
                String scoreText = ScoreTextHelper$.MODULE$.convert(score);
                r.defenseScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)s)));
                r.finalScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)score)));
                r.finalScoreText_$eq((Option)Some$.MODULE$.apply((Object)scoreText));
                r.remark_$eq((Option)None$.MODULE$);
                return;
            }
            throw new MatchError((Object)option);
        });
        this.entityDao().saveOrUpdate((Iterable)reviews);
        String msg = "\u5f55\u5165\u7b2c" + group.idx() + "\u7ec4\u7b54\u8fa9\u6210\u7ee9";
        this.businessLogger().info(msg, group.id(), (Object)((IterableOnceOps)reviews.map((Function1 & Serializable)x -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)x.writer().code());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x.defenseScore().map((Function1 & Serializable)_$11 -> DefenseAction.saveScore$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$11))).getOrElse(DefenseAction::saveScore$$anonfun$2$$anonfun$2));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return this.redirect("index", "\u5f55\u5165\u6210\u529f");
    }

    private static final ArrayBuffer $anonfun$5() {
        return new ArrayBuffer();
    }

    private final /* synthetic */ User save$$anonfun$1(long x) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)x));
    }

    private final /* synthetic */ DefenseNotice $anonfun$18(long id) {
        return (DefenseNotice)this.entityDao().get(DefenseNotice.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private static final DefenseNotice $anonfun$19() {
        return new DefenseNotice();
    }

    private static final /* synthetic */ OqlBuilder inputScore$$anonfun$1(OqlBuilder query$1, long id) {
        return (OqlBuilder)query$1.where("dg.id=:id", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id)}));
    }

    private static final int $anonfun$23() {
        return 0;
    }

    private static final /* synthetic */ String saveScore$$anonfun$2$$anonfun$1(int _$11) {
        return BoxesRunTime.boxToInteger((int)_$11).toString();
    }

    private static final String saveScore$$anonfun$2$$anonfun$2() {
        return "";
    }
}

