/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.helper;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.base.std.model.StudentState;
import org.openurp.degree.thesis.model.ThesisCheck;
import org.openurp.degree.thesis.model.ThesisDoc;
import org.openurp.degree.thesis.model.Writer;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ThesisCheckFileNaming$
implements Serializable {
    public static final ThesisCheckFileNaming$ MODULE$ = new ThesisCheckFileNaming$();

    private ThesisCheckFileNaming$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ThesisCheckFileNaming$.class);
    }

    public String paperFileName(ThesisCheck check) {
        return this.fileName(check) + "_LW.pdf";
    }

    public String paperFileName2(ThesisCheck check) {
        return this.fileName(check) + "_LW." + Strings$.MODULE$.substringAfterLast(((ThesisDoc)check.paperDoc().get()).filePath(), ".");
    }

    public String attachFileName(ThesisCheck check) {
        return this.fileName(check) + "_CL.zip";
    }

    private String majorCode(Writer writer) {
        String major = ((StudentState)writer.std().state().get()).major().getDisciplineCode(writer.std().graduateOn());
        if (major.isEmpty()) {
            major = "x";
        }
        return major;
    }

    private String fileName(ThesisCheck check) {
        String schoolYear = this.getShortSchoolYear(check.season());
        String city = "31";
        String school = check.writer().std().project().school().code();
        String major = check.degreeMajorCode();
        String code = check.writer().std().code();
        return schoolYear + "_" + city + "_" + school + "_" + major + "_" + code;
    }

    public String getShortSchoolYear(GraduateSeason season) {
        String year = BoxesRunTime.boxToInteger((int)season.graduateOn().getYear()).toString();
        String endYear = year.substring(year.length() - 2);
        String beforeYear = BoxesRunTime.boxToInteger((int)(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(endYear)) - 1)).toString();
        return beforeYear + endYear;
    }
}

