/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.service.impl;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.net.http.HttpMethods$;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.Response;
import org.openurp.degree.thesis.service.SmsService;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class EcuplSmsServiceImpl
implements SmsService,
Logging {
    private Logger logger;
    private final String base;
    private final String appId;
    private final String appPassword;
    private Tuple2 tokenInfo;
    private int tokenLiveTime;

    public EcuplSmsServiceImpl(String base, String appId, String appPassword) {
        this.base = base;
        this.appId = appId;
        this.appPassword = appPassword;
        Logging.$init$((Logging)this);
        this.tokenLiveTime = 600;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Tuple2<String, Instant> tokenInfo() {
        return this.tokenInfo;
    }

    public void tokenInfo_$eq(Tuple2<String, Instant> x$1) {
        this.tokenInfo = x$1;
    }

    public int tokenLiveTime() {
        return this.tokenLiveTime;
    }

    public void tokenLiveTime_$eq(int x$1) {
        this.tokenLiveTime = x$1;
    }

    public Option<String> fetchToken() {
        Instant now = Instant.now();
        if (this.tokenInfo() == null || Math.abs(Duration.between((Temporal)this.tokenInfo()._2(), now).get(ChronoUnit.SECONDS)) >= (long)this.tokenLiveTime()) {
            Response tokenRes = HttpUtils$.MODULE$.getText(this.base + "/msg/getThirdAPIToken?appId=" + this.appId + "&appPassword=" + this.appPassword);
            if (tokenRes.isOk() && tokenRes.getText().contains("000000")) {
                String token = Strings$.MODULE$.substringBetween(tokenRes.getText(), "\"token\":\"", "\"");
                if (Strings$.MODULE$.isNotEmpty((CharSequence)token)) {
                    this.tokenInfo_$eq(Tuple2$.MODULE$.apply((Object)token, (Object)Instant.now()));
                    return Some$.MODULE$.apply((Object)token);
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.tokenInfo()._1());
    }

    public Option<String> send(String content, Seq<Tuple2<String, String>> receivers) {
        Option option = this.fetchToken();
        if (option instanceof Some) {
            String token = (String)((Some)option).value();
            String postUrl = this.base + "/message/sendMessageBySMSApi";
            String receiverContacts = ((IterableOnceOps)receivers.map((Function1 & Serializable)x -> "{\"name\": \"" + URLEncoder.encode((String)x._2(), Charsets$.MODULE$.UTF_8()) + "\",\"mobile\":\"" + x._1() + "\"}")).mkString(",");
            Response res = HttpUtils$.MODULE$.getText(URI.create(postUrl).toURL(), HttpMethods$.MODULE$.POST(), Charsets$.MODULE$.UTF_8(), (Option)Some$.MODULE$.apply((JProcedure1 & Serializable)conn -> {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                String formData = "token=" + token + "&msgContent=" + URLEncoder.encode(content, Charsets$.MODULE$.UTF_8()) + "&receivers=[" + receiverContacts + "]";
                writer.write(formData);
                writer.close();
            }));
            if (res.isOk()) {
                String restext = res.getText();
                return Some$.MODULE$.apply((Object)Strings$.MODULE$.substringBetween(restext, "\"msgId\":\"", "\""));
            }
            Logger$.MODULE$.error$extension(this.logger(), () -> EcuplSmsServiceImpl.send$$anonfun$1(res, receivers, content));
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            Logger$.MODULE$.error$extension(this.logger(), EcuplSmsServiceImpl::send$$anonfun$2);
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private static final String send$$anonfun$1(Response res$1, Seq receivers$1, String content$2) {
        return "sms error:" + res$1.getText() + "(receivers:" + receivers$1.toString() + " msg:" + content$2 + ")";
    }

    private static final String send$$anonfun$2() {
        return "Cannot get invoke token";
    }
}

