/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.director;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.helper.QueryHelper$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Major;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.User;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.base.std.model.StudentState;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.DefenseGroup;
import org.openurp.degree.thesis.model.DefenseMember;
import org.openurp.degree.thesis.model.DefenseNotice;
import org.openurp.degree.thesis.model.DefenseWriter;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DefenseGroupService;
import org.openurp.degree.thesis.service.doc.DefenseReport$;
import org.openurp.degree.thesis.web.action.director.DirectorSupport;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import org.openurp.degree.thesis.web.helper.RandomGroupHelper$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefenseAction
extends DirectorSupport {
    private DefenseGroupService groupService;

    public DefenseGroupService groupService() {
        return this.groupService;
    }

    public void groupService_$eq(DefenseGroupService x$1) {
        this.groupService = x$1;
    }

    public View index() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = this.thesisPlanService().getSeason();
        scala.collection.immutable.Seq myGroups = this.groupService().getGroups(advisor.teacher(), season);
        this.put("myGroups", (Object)myGroups);
        scala.collection.immutable.Seq manageGroups = (scala.collection.immutable.Seq)myGroups.filter((Function1 & Serializable)g -> this.groupService().isGroupManager(g, advisor.teacher()));
        this.put("manageGroups", (Object)manageGroups);
        advisor.teacher().office().foreach((Function1)(JProcedure1 & Serializable)office -> {
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
            query2.where("dg.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
            query2.where("dg.office=:office", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            query2.orderBy("dg.idx");
            this.put("adminGroups", (Object)this.entityDao().search((QueryBuilder)query2));
            this.put("office", office);
        });
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("defenseGroup", (Object)defenseGroup);
        this.put("writers", (Object)defenseGroup.orderedWriters());
        return this.forward(this.forward$default$1());
    }

    public View advisors() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        advisor.teacher().office().foreach((Function1)(JProcedure1 & Serializable)office -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class, "advisor");
            query.where("advisor.teacher.office=:office", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            scala.collection.immutable.Seq advisors = (scala.collection.immutable.Seq)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)x -> x.teacher());
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(DefenseMember.class, "dm");
            query2.where("dm.group.office=:office", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            query2.where("dm.group.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
            scala.collection.immutable.Seq members = this.entityDao().search((QueryBuilder)query2);
            ArrayBuffer teachers = new ArrayBuffer();
            teachers.$plus$plus$eq((IterableOnce)advisors);
            HashMap groups = new HashMap();
            members.foreach((Function1 & Serializable)m -> {
                if (!teachers.contains((Object)m.teacher())) {
                    teachers.$plus$eq((Object)m.teacher());
                }
                ArrayBuffer userGroups = (ArrayBuffer)groups.getOrElseUpdate((Object)m.teacher(), DefenseAction::$anonfun$3);
                return (ArrayBuffer)userGroups.$plus$eq((Object)m.group());
            });
            this.put("office", office);
            this.put("users", (Object)teachers);
            this.put("groups", (Object)groups);
        });
        return this.forward(this.forward$default$1());
    }

    public View writers() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = this.thesisPlanService().getSeason();
        advisor.teacher().office().foreach((Function1)(JProcedure1 & Serializable)office -> {
            OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
            query.where("dg.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
            query.where("dg.office=:office", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            scala.collection.immutable.Seq groups = this.entityDao().search((QueryBuilder)query);
            HashMap writerGroups = new HashMap();
            groups.foreach((Function1)(JProcedure1 & Serializable)group -> group.writers().foreach((Function1 & Serializable)writer -> writerGroups.put((Object)writer.writer(), group)));
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(Writer.class, "writer");
            query2.where("writer.advisor.teacher.office=:office", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office}));
            query2.where("writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
            scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query2);
            Tuple2 writers2 = writers.partition((Function1 & Serializable)key -> writerGroups.contains(key));
            this.put("groups", (Object)writerGroups);
            scala.collection.immutable.Seq inGroupWriters = (scala.collection.immutable.Seq)((SeqOps)writers2._1()).sortBy((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)((DefenseGroup)writerGroups.apply(x)).idx()).toString() + ((Advisor)x.advisor().get()).code() + x.code(), (Ordering)Ordering.String$.MODULE$);
            this.put("inGroupWriters", (Object)inGroupWriters);
            this.put("noGroupWriters", writers2._2());
        });
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("defenseGroup", (Object)defenseGroup);
        this.put("writers", (Object)defenseGroup.orderedWriters());
        Buffer teachers = this.searchMemberCandidates(defenseGroup);
        Buffer myDeparts = (Buffer)teachers.filter((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = defenseGroup.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        teachers.subtractAll((IterableOnce)myDeparts);
        teachers.prependAll((IterableOnce)myDeparts);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)defenseGroup.season().project().school());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, myDeparts.map((Function1 & Serializable)_$2 -> _$2.code()));
        scala.collection.immutable.Seq secretaries = this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("secretaries", (Object)secretaries);
        this.put("advisors", (Object)teachers);
        return this.forward(this.forward$default$1());
    }

    private Buffer<Teacher> searchMemberCandidates(DefenseGroup group) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class.getName(), "advisor");
        query.orderBy("advisor.teacher.department.name,advisor.teacher.name");
        query.select("advisor.teacher");
        Buffer teachers = this.entityDao().search((QueryBuilder)query).toBuffer();
        Set writerAdvisors = ((IterableOnceOps)((IterableOps)group.writers().filter((Function1 & Serializable)_$3 -> _$3.writer().advisor().nonEmpty())).map((Function1 & Serializable)_$4 -> ((Advisor)_$4.writer().advisor().get()).teacher())).toSet();
        teachers.subtractAll((IterableOnce)writerAdvisors);
        return teachers;
    }

    @mapping(value="new", view="new,form")
    public View editNew() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup defenseGroup = new DefenseGroup(season, advisor.teacher().department());
        this.put("defenseGroup", (Object)defenseGroup);
        Buffer teachers = this.searchMemberCandidates(defenseGroup);
        Buffer myDeparts = (Buffer)teachers.filter((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = defenseGroup.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        teachers.subtractAll((IterableOnce)myDeparts);
        teachers.prependAll((IterableOnce)myDeparts);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)defenseGroup.season().project().school());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, myDeparts.map((Function1 & Serializable)_$5 -> _$5.code()));
        scala.collection.immutable.Seq secretaries = this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("secretaries", (Object)secretaries);
        this.put("advisors", (Object)teachers);
        return this.forward(this.forward$default$1());
    }

    @mapping(method="delete")
    public View remove() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(defenseGroup, advisor)) {
            if (defenseGroup.published()) {
                return this.redirect("index", "\u4e0d\u80fd\u5220\u9664\u5df2\u7ecf\u53d1\u5e03\u7684\u7b54\u8fa9\u7ec4");
            }
            this.entityDao().remove((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
            return this.redirect("index", "info.remove.success");
        }
        return this.redirect("index", "info.remove.success");
    }

    public View removeAdvisor() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(group, advisor)) {
            DefenseMember removed = (DefenseMember)this.entityDao().get(DefenseMember.class, this.getLong("defenseMember.id").get());
            group.members().subtractOne((Object)removed);
            this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        }
        return this.redirect("edit", "id=" + group.id(), "info.remove.success");
    }

    private int genGroupIdx(DefenseGroup group) {
        if (group.idx() == 0) {
            OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class.getName(), "g");
            query.where("g.department=:depart", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{group.department()}));
            query.where("g.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{group.season()}));
            query.select("g.idx");
            query.orderBy("g.idx desc");
            scala.collection.immutable.Seq indexList = this.entityDao().search((QueryBuilder)query);
            if (indexList.isEmpty()) {
                return 1;
            }
            return BoxesRunTime.unboxToInt((Object)indexList.head()) + 1;
        }
        return group.idx();
    }

    public View save() {
        DefenseGroup defenseGroup;
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        Option option = this.getLong("defenseGroup.id");
        if (None$.MODULE$.equals(option)) {
            defenseGroup = new DefenseGroup(season, advisor.teacher().department());
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else {
            throw new MatchError((Object)option);
        }
        DefenseGroup group = defenseGroup;
        group.office_$eq(advisor.teacher().office());
        group.place_$eq(this.get("defenseGroup.place"));
        group.beginAt_$eq(this.getInstant("defenseGroup.beginAt"));
        group.endAt_$eq(this.getInstant("defenseGroup.endAt"));
        group.secretary_$eq(this.getLong("defenseGroup.secretary.id").map((Function1 & Serializable)x -> this.save$$anonfun$1(BoxesRunTime.unboxToLong((Object)x))));
        group.idx_$eq(this.genGroupIdx(group));
        group.members().foreach((Function1)(JProcedure1 & Serializable)m -> this.getBoolean("member_" + m.teacher().id() + ".leader").foreach((Function1 & Serializable)v1 -> {
            DefenseAction.save$$anonfun$2$$anonfun$1((DefenseMember)m, (boolean)BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        }));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.getLong("newmember_" + i + ".teacher.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)teacherId -> {
            Teacher teacher = (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)teacherId));
            if (group.members().forall((Function1 & Serializable)x -> {
                Teacher teacher = x.teacher();
                Teacher teacher2 = teacher;
                return teacher == null ? teacher2 != null : !teacher.equals(teacher2);
            })) {
                DefenseMember nm = new DefenseMember();
                nm.teacher_$eq(teacher);
                nm.leader_$eq(this.getBoolean("newmember_" + i + ".leader", false));
                nm.group_$eq(group);
                group.members().$plus$eq((Object)nm);
                return;
            }
        }));
        this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        return this.redirect("index", "info.save.success");
    }

    public View removeWriter() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(defenseGroup, advisor)) {
            Writer removed = (Writer)this.entityDao().get(Writer.class, this.getLong("writer.id").get());
            defenseGroup.removeWriter((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[]{removed})));
            this.entityDao().saveOrUpdate((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
            String msg = "\u4ece\u7b2c" + defenseGroup.idx() + "\u7ec4\u4e2d\u79fb\u9664" + removed.std().name();
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.std.code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)removed.std().code());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"group.id");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)defenseGroup.id().toString());
            this.businessLogger().info(msg, defenseGroup.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "info.remove.success");
    }

    public View addWriterList() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        this.put("defenseGroup", (Object)group);
        if (this.groupService().isGroupAdmin(group, advisor)) {
            OqlBuilder query = this.getCandidatesQuery(advisor, group);
            QueryHelper$.MODULE$.populate(query, null);
            QueryHelper$.MODULE$.sort(query);
            scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
            this.put("writers", (Object)writers);
        } else {
            this.put("writers", (Object)package$.MODULE$.List().empty());
        }
        return this.forward(this.forward$default$1());
    }

    public View addWriter() {
        Advisor advisor = this.getAdvisor();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (this.groupService().isGroupAdmin(defenseGroup, advisor)) {
            Set advisors = ((IterableOnceOps)defenseGroup.members().map((Function1 & Serializable)_$6 -> _$6.teacher())).toSet();
            scala.collection.immutable.Seq added = this.entityDao().find(Writer.class, this.getAll("writer.id", Long.TYPE, ClassTag$.MODULE$.apply(Long.TYPE)));
            added.foreach((Function1)(JProcedure1 & Serializable)add -> {
                if (!advisors.contains((Object)((Advisor)add.advisor().get()).teacher())) {
                    defenseGroup.addWriters((Iterable)new .colon.colon(add, (List)Nil$.MODULE$));
                    return;
                }
            });
            this.entityDao().saveOrUpdate((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "info.save.success");
    }

    private OqlBuilder<Writer> getCandidatesQuery(Advisor advisor, DefenseGroup group) {
        GraduateSeason season = this.thesisPlanService().getSeason();
        Buffer advisors = (Buffer)group.members().map((Function1 & Serializable)_$7 -> _$7.teacher());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("writer.advisor is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("exists(from " + ThesisReview.class.getName() + " tr where tr.writer=writer and tr.crossReviewManager=:manager)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        if (advisors.nonEmpty()) {
            query.where("writer.advisor.teacher not in(:advisors)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisors}));
        }
        query.where("not exists(from " + DefenseWriter.class.getName() + " dw  where dw.writer=writer)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        return query;
    }

    public View autoAddWriter() {
        Advisor advisor = this.getAdvisor();
        int newCount = this.getInt("newCount", 0);
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (defenseGroup.office().contains(advisor.teacher().office().get()) && newCount > 0) {
            int i;
            OqlBuilder query = this.getCandidatesQuery(this.getAdvisor(), defenseGroup);
            scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
            Iterator writerIter = writers.iterator();
            for (i = 0; i < newCount && writerIter.hasNext(); ++i) {
                Writer writer = (Writer)writerIter.next();
                defenseGroup.addWriters((Iterable)new .colon.colon((Object)writer, (List)Nil$.MODULE$));
            }
            this.entityDao().saveOrUpdate((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
            return this.redirect("edit", "id=" + defenseGroup.id(), "\u6210\u529f\u6dfb\u52a0\u4e86" + i + "\u540d\u5b66\u751f");
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "\u6210\u529f\u6dfb\u52a0\u4e860\u540d\u5b66\u751f");
    }

    public View notices() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = this.thesisPlanService().getSeason();
        OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class, "dg");
        query.where("dg.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.join("dg.members", "member");
        query.where("member.teacher=:me and member.leader=true", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        scala.collection.immutable.Seq groups = this.entityDao().search((QueryBuilder)query);
        scala.collection.immutable.Seq notices = (scala.collection.immutable.Seq)groups.flatMap((Function1 & Serializable)g -> g.notices());
        this.put("notices", (Object)notices);
        return this.forward(this.forward$default$1());
    }

    public View removeNotice() {
        Advisor advisor = this.getAdvisor();
        this.getLong("notice.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)noticeId -> {
            DefenseNotice notice = (DefenseNotice)this.entityDao().get(DefenseNotice.class, (Object)BoxesRunTime.boxToLong((long)noticeId));
            if (this.groupService().isGroupManager(notice.group(), advisor.teacher())) {
                this.entityDao().remove((Object)notice, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseNotice[0]));
                return;
            }
        });
        return this.redirect("index", "info.remove.success");
    }

    public View saveNotice() {
        Advisor advisor = this.getAdvisor();
        this.getLong("notice.group.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)groupId -> {
            DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)groupId));
            if (this.groupService().isGroupManager(group, advisor.teacher())) {
                DefenseNotice notice = (DefenseNotice)this.getLong("notice.id").map((Function1 & Serializable)id -> this.$anonfun$15(BoxesRunTime.unboxToLong((Object)id))).getOrElse(DefenseAction::$anonfun$16);
                notice.group_$eq(group);
                notice.title_$eq((String)this.get("notice.title", (Object)"--"));
                notice.contents_$eq((String)this.get("notice.contents", (Object)"--"));
                notice.updatedAt_$eq(Instant.now());
                this.entityDao().saveOrUpdate((Object)notice, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseNotice[0]));
                return;
            }
        });
        return this.redirect("index", "info.save.success");
    }

    public View randomGroupSetting() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup group = new DefenseGroup(season, advisor.teacher().department());
        OqlBuilder query = this.getCandidatesQuery(advisor, group);
        scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
        Map majorWriters = writers.groupBy((Function1 & Serializable)_$8 -> ((StudentState)_$8.std().state().get()).major());
        this.put("majorWriters", (Object)majorWriters);
        this.put("writers", (Object)writers);
        Iterable teachers = this.groupService().getManageTeacher(advisor, ((ThesisPlan)this.thesisPlanService().getPlan().get()).season());
        this.put("teachers", (Object)teachers);
        return this.forward(this.forward$default$1());
    }

    public View randomGroupSchedule() {
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup group = new DefenseGroup(season, advisor.teacher().department());
        OqlBuilder query = this.getCandidatesQuery(advisor, group);
        scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
        Map majorWriters = writers.groupBy((Function1 & Serializable)_$9 -> ((StudentState)_$9.std().state().get()).major());
        this.put("majorWriters", (Object)majorWriters);
        this.put("writers", (Object)writers);
        Iterable teachers = this.groupService().getManageTeacher(advisor, ((ThesisPlan)this.thesisPlanService().getPlan().get()).season());
        this.put("teachers", (Object)teachers);
        scala.collection.immutable.Seq selectTeachers = this.entityDao().find(Teacher.class, (Iterable)this.getLongIds("teacher"));
        scala.collection.immutable.Seq selectMajors = this.entityDao().find(Major.class, (Iterable)this.getLongIds("major"));
        scala.collection.immutable.Seq selectWriters = (scala.collection.immutable.Seq)writers.filter((Function1 & Serializable)x -> selectMajors.contains((Object)((StudentState)x.std().state().get()).major()));
        this.put("selectTeachers", (Object)selectTeachers.toSet());
        this.put("selectMajors", (Object)selectMajors.toSet());
        int count = this.getInt("groupCount", 1);
        if (count <= 1) {
            count = 1;
        }
        if (count > teachers.size()) {
            count = teachers.size();
        }
        scala.collection.immutable.Seq groups = RandomGroupHelper$.MODULE$.generate((Seq)selectWriters, (Seq)selectTeachers, count);
        this.put("groupCount", (Object)BoxesRunTime.boxToInteger((int)count));
        this.put("groups", (Object)groups);
        return this.forward(this.forward$default$1());
    }

    public View saveRandomGroup() {
        int count = this.getInt("groupCount", 1);
        Advisor advisor = this.getAdvisor();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            DefenseGroup group = new DefenseGroup(season, advisor.teacher().department());
            group.office_$eq(advisor.teacher().office());
            scala.collection.immutable.Seq teachers = this.entityDao().find(Teacher.class, (Iterable)Strings$.MODULE$.splitToLong((String)this.get("group_" + i + "_teacherIds", (Object)"")));
            scala.collection.immutable.Seq writers = this.entityDao().find(Writer.class, (Iterable)Strings$.MODULE$.splitToLong((String)this.get("group_" + i + "_writerIds", (Object)"")));
            group.members().$plus$plus$eq((IterableOnce)teachers.map((Function1 & Serializable)x -> {
                DefenseMember m = new DefenseMember();
                m.group_$eq(group);
                m.teacher_$eq(x);
                return m;
            }));
            group.addWriters((Iterable)writers);
            group.idx_$eq(this.genGroupIdx(group));
            this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        });
        return this.redirect("index", "\u5206\u7ec4\u6210\u529f");
    }

    public View report() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        Map reviews = group.writers().isEmpty() ? Predef$.MODULE$.Map().empty() : ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)group.orderedWriters()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HSSFWorkbook hsw = DefenseReport$.MODULE$.render(group, reviews);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hsw.write((OutputStream)bos);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(bos.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u7b54\u8fa9\u4fe1\u606f\u8868.xls", Stream$.MODULE$.apply$default$4());
    }

    public View paperZip() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        List papers = group.writers().isEmpty() ? package$.MODULE$.List().empty() : this.entityDao().findBy(ThesisPaper.class, "writer", (Object)group.orderedWriters());
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        File targetZip = PaperDownloadHelper$.MODULE$.zipGroupPapers(season, group, (Iterable)papers);
        String fileName = season.name() + "_" + group.department().name() + "_\u7b2c" + group.idx() + "\u7ec4\u8bba\u6587.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    private static final ArrayBuffer $anonfun$3() {
        return new ArrayBuffer();
    }

    private final /* synthetic */ User save$$anonfun$1(long x) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)x));
    }

    private static final /* synthetic */ void save$$anonfun$2$$anonfun$1(DefenseMember m$1, boolean leader) {
        m$1.leader_$eq(leader);
    }

    private final /* synthetic */ DefenseNotice $anonfun$15(long id) {
        return (DefenseNotice)this.entityDao().get(DefenseNotice.class, (Object)BoxesRunTime.boxToLong((long)id));
    }

    private static final DefenseNotice $anonfun$16() {
        return new DefenseNotice();
    }
}

