/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.std;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.file.digest.Sha1$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus$;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.CopyCheck;
import org.openurp.degree.thesis.model.Deadline;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.PaperSubmission;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.SmsService;
import org.openurp.degree.thesis.web.action.std.WriterSupport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class PaperAction
extends WriterSupport {
    private Option smsService = None$.MODULE$;

    public Option<SmsService> smsService() {
        return this.smsService;
    }

    public void smsService_$eq(Option<SmsService> x$1) {
        this.smsService = x$1;
    }

    public View index() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        StageTime draftStageTime = plan.getStageTime(Stage$.ThesisDraftSubmit);
        StageTime finalStageTime = plan.getStageTime(Stage$.ThesisFinalSubmit);
        if (draftStageTime.timeSuitable(Instant.now()) == 0) {
            Object message = "";
            Deadline deadline = writer.getOrCreateDeadline(Stage$.ThesisDraftSubmit);
            Option option = deadline.endAt();
            if (None$.MODULE$.equals(option)) {
                message = "\u8bf7\u4e8e " + draftStageTime.endOn() + "\u524d\u5b8c\u6210\u64b0\u5199\u5e76\u63d0\u4ea4";
            } else if (option instanceof Some) {
                Instant endAt = (Instant)((Some)option).value();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                message = "\u8bf7\u4e8e " + endAt.atZone(ZoneId.systemDefault()).format(formatter) + "\u524d\u5b8c\u6210\u64b0\u5199\u5e76\u63d0\u4ea4";
            } else {
                throw new MatchError((Object)option);
            }
            this.put("message", message);
            if (deadline.delayCount() > 0) {
                this.put("delay", (Object)("\u4f60\u7684\u8bba\u6587\u5df2\u5ef6\u671f " + deadline.delayCount() + "\u6b21 ,\u591a\u6b21\u5ef6\u671f\u5c06\u5f71\u54cd\u5230\u8bba\u6587\u6700\u7ec8\u6210\u7ee9"));
            }
        }
        this.put("draftStageTime", (Object)draftStageTime);
        this.put("finalStageTime", (Object)finalStageTime);
        this.put("writer", (Object)writer);
        Option file = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer).headOption();
        this.put("file", (Object)file);
        Seq submissions = this.entityDao().findBy(PaperSubmission.class, "writer", (Object)writer);
        this.put("submissions", submissions.sortBy((Function1 & Serializable)_$1 -> _$1.updatedAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        return this.forward(this.forward$default$1());
    }

    public View uploadForm() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        this.put("displayFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.put("defaultFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.put("writer", (Object)writer);
        String msg = this.checkStageTime(plan, writer);
        if (msg == null) {
            return this.forward(this.forward$default$1());
        }
        return this.redirect("index", msg);
    }

    private String checkStageTime(DepartPlan plan, Writer writer) {
        StageTime draftStageTime = plan.getStageTime(Stage$.ThesisDraftSubmit);
        StageTime finalStageTime = plan.getStageTime(Stage$.ThesisFinalSubmit);
        Instant now = Instant.now();
        if (draftStageTime.timeSuitable(now) == 0) {
            this.put("stageTime", (Object)draftStageTime);
            this.put("displayFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return null;
        }
        if (finalStageTime.timeSuitable(now) == 0) {
            this.put("stageTime", (Object)finalStageTime);
            this.put("displayFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)true));
            Option paper = this.entityDao().first((QueryBuilder)OqlBuilder$.MODULE$.from(ThesisPaper.class, "f").where("f.writer=:writer", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer})));
            String msg = paper.isEmpty() ? "\u6ca1\u6709\u63d0\u4ea4\u8bba\u6587\u521d\u7a3f\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8bba\u6587\u7ec8\u7a3f\u3002" : (paper.isDefined() && BoxesRunTime.unboxToBoolean((Object)((ThesisPaper)paper.get()).advisorPassed().getOrElse(PaperAction::$anonfun$1)) ? "\u8bba\u6587\u7ec8\u7a3f\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u65e0\u9700\u63d0\u4ea4\u3002" : null);
            paper.foreach((Function1)(JProcedure1 & Serializable)p -> this.put("defaultFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)p.finalized())));
            return msg;
        }
        this.put("displayFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.put("defaultFinalized", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.put("stageTime", (Object)finalStageTime);
        Seq checks = this.entityDao().findBy(CopyCheck.class, "writer", (Object)writer);
        if (checks.isEmpty()) {
            return "\u4e0d\u5728\u63d0\u4ea4\u8bba\u6587\u65f6\u95f4\u6bb5\u5185\uff0c\u5c1a\u4e0d\u80fd\u63d0\u4ea4\u3002";
        }
        if (checks.exists((Function1 & Serializable)_$2 -> _$2.passed())) {
            return "\u4e0d\u5728\u63d0\u4ea4\u8bba\u6587\u65f6\u95f4\u6bb5\u5185\uff0c\u5c1a\u4e0d\u80fd\u63d0\u4ea4\u3002";
        }
        return null;
    }

    public View upload() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        String msg = this.checkStageTime(plan, writer);
        if (msg != null) {
            return this.redirect("index", msg);
        }
        ThesisPaper paper = (ThesisPaper)this.entityDao().first((QueryBuilder)OqlBuilder$.MODULE$.from(ThesisPaper.class, "f").where("f.writer=:writer", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}))).getOrElse(PaperAction::$anonfun$2);
        Iterable parts = this.getAll("file", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Option mobile;
            StageTime draftStageTime;
            Part part = (Part)parts.head();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            File localFile = File.createTempFile("paper", "pdf");
            IOs$.MODULE$.copy(part.getInputStream(), (OutputStream)new FileOutputStream(localFile));
            boolean finalized = this.getBoolean("finalized", false);
            String sha1sum = Sha1$.MODULE$.digest(localFile);
            PaperSubmission submission = new PaperSubmission();
            submission.writer_$eq(writer);
            submission.title_$eq((String)writer.thesisTitle().getOrElse(PaperAction::upload$$anonfun$1));
            submission.updatedAt_$eq(Instant.now());
            submission.sha1sum_$eq(sha1sum);
            submission.finalized_$eq(finalized);
            String submissionFileName = sha1sum + "." + Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
            BlobMeta meta1 = blob.upload("/" + writer.season().id().toString() + "/paper_submission/", (InputStream)new FileInputStream(localFile), submissionFileName, writer.std().code() + " " + writer.std().name());
            submission.filePath_$eq(meta1.filePath());
            this.entityDao().saveOrUpdate((Object)submission, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PaperSubmission[0]));
            if (paper.filePath() != null && paper.filePath().startsWith("/")) {
                blob.remove(paper.filePath());
            }
            String fileName = part.getSubmittedFileName();
            String storeName = writer.std().code() + "." + Strings$.MODULE$.substringAfterLast(fileName, ".");
            BlobMeta meta = blob.upload("/" + writer.season().id().toString() + "/paper/", (InputStream)new FileInputStream(localFile), storeName, writer.std().code() + " " + writer.std().name());
            paper.filePath_$eq(meta.filePath());
            paper.name_$eq(storeName);
            paper.submitAt_$eq(Instant.now());
            paper.status_$eq(AuditStatus$.Submited);
            paper.sha1sum_$eq(sha1sum);
            paper.writer_$eq(writer);
            paper.finalized_$eq(finalized);
            if (!finalized && (draftStageTime = plan.getStageTime(Stage$.ThesisDraftSubmit)).timeSuitable(Instant.now()) == 0) {
                paper.draftPath_$eq((Option)Some$.MODULE$.apply((Object)paper.filePath()));
            }
            paper.title_$eq((String)writer.thesisTitle().getOrElse(PaperAction::upload$$anonfun$2));
            this.entityDao().saveOrUpdate((Object)paper, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPaper[0]));
            Option reviews = this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption();
            if (reviews.isEmpty()) {
                ThesisReview review = new ThesisReview();
                review.writer_$eq(writer);
                this.entityDao().saveOrUpdate((Object)review, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisReview[0]));
            }
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)fileName);
            this.businessLogger().info("\u4e0a\u4f20\u4e86\u8bba\u6587" + fileName, writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            if (paper.finalized() && paper.writer().advisor().nonEmpty() && (mobile = ((Advisor)paper.writer().advisor().get()).mobile()).nonEmpty() && ((String)mobile.get()).length() == 11) {
                this.smsService().foreach((Function1 & Serializable)sms -> {
                    String template = ((Advisor)paper.writer().advisor().get()).name() + "\u8001\u5e08\u60a8\u597d,\u4f60\u6307\u5bfc\u7684\u5b66\u751f" + paper.writer().name() + "\uff0c\u63d0\u4ea4\u4e86\u5b9a\u7a3f\u8bba\u6587\uff0c\u5f85\u5ba1\u6838\u8bf7\u77e5\u6089\u3002" + ("\u8bbf\u95ee\u8bba\u6587\u7cfb\u7edf" + Ems$.MODULE$.base() + "/degree/thesis/advisor/paper/auditForm?paper.id=" + paper.id() + "\uff0c\u76f4\u63a5\u5ba1\u6838\u5373\u53ef\u3002");
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc(mobile.get());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((Advisor)paper.writer().advisor().get()).name());
                    return sms.send(template, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                });
            }
        }
        return this.redirect("index", "info.save.success");
    }

    public View attachment() {
        Writer writer = this.getWriter();
        Option file = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer).headOption();
        Option option = file;
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            ThesisPaper f = (ThesisPaper)((Some)option).value();
            return this.download(f.filePath());
        }
        throw new MatchError((Object)option);
    }

    public View draft() {
        Writer writer = this.getWriter();
        Option file = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer).headOption();
        Option option = file;
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            ThesisPaper f = (ThesisPaper)((Some)option).value();
            Option option2 = f.draftPath();
            if (None$.MODULE$.equals(option2)) {
                return Status$.MODULE$.NotFound();
            }
            if (option2 instanceof Some) {
                String draftPath = (String)((Some)option2).value();
                return this.download(draftPath);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public View submission() {
        Option sub = this.entityDao().find(PaperSubmission.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("submission")));
        Option option = sub;
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            Writer writer;
            PaperSubmission s = (PaperSubmission)((Some)option).value();
            Writer writer2 = writer = this.getWriter();
            Writer writer3 = s.writer();
            if (!(writer2 != null ? !writer2.equals(writer3) : writer3 != null)) {
                return this.download(s.filePath());
            }
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError((Object)option);
    }

    public View advisorRevision() {
        Writer writer = this.getWriter();
        long submissionId = this.getLongId("submission");
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)submissionId));
        Option file = this.entityDao().findBy(PaperSubmission.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption();
        Option option = file;
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            PaperSubmission f = (PaperSubmission)((Some)option).value();
            Option option2 = f.revisionPath();
            if (None$.MODULE$.equals(option2)) {
                return Status$.MODULE$.NotFound();
            }
            if (option2 instanceof Some) {
                String p = (String)((Some)option2).value();
                return this.download(p);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private View download(String filePath) {
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(filePath);
        HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
        response2.sendRedirect(((URL)path.get()).toString());
        return null;
    }

    private static final boolean $anonfun$1() {
        return false;
    }

    private static final ThesisPaper $anonfun$2() {
        return new ThesisPaper();
    }

    private static final String upload$$anonfun$1() {
        return "--";
    }

    private static final String upload$$anonfun$2() {
        return "--";
    }
}

