/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.concurrent.Workers$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.Repository;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.DefenseGroup;
import org.openurp.degree.thesis.model.ThesisCheck;
import org.openurp.degree.thesis.model.ThesisDoc;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.doc.ThesisDocGenerator$;
import org.openurp.degree.thesis.web.helper.PDFMerger$;
import org.openurp.degree.thesis.web.helper.StdNamePurifier$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Random$;

public final class PaperDownloadHelper$
implements Logging,
Serializable {
    private static Logger logger;
    public static final PaperDownloadHelper$ MODULE$;

    private PaperDownloadHelper$() {
    }

    static {
        MODULE$ = new PaperDownloadHelper$();
        Logging.$init$((Logging)MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PaperDownloadHelper$.class);
    }

    public File zipGroupReport(GraduateSeason season, DefenseGroup group, scala.collection.immutable.Seq<ThesisReview> reviews) {
        File dir = new File(System.getProperty("java.io.tmpdir") + ("season" + season.id()) + Files$.MODULE$.$div() + ("group" + group.id()) + Files$.MODULE$.$div() + "batch");
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        dir.mkdirs();
        scala.collection.immutable.Map reviewMap = ((IterableOnceOps)reviews.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        group.writers().foreach((Function1 & Serializable)w -> {
            Writer writer = w.writer();
            Option review = reviewMap.get((Object)writer);
            return IOs$.MODULE$.copy(ThesisDocGenerator$.MODULE$.genDefense(writer, review, (Option)Some$.MODULE$.apply((Object)group), (Option)None$.MODULE$), (OutputStream)new FileOutputStream(dir.getAbsolutePath() + Files$.MODULE$.$div() + (writer.std().code() + "\u7b54\u8fa9\u8bb0\u5f55\u53ca\u8bc4\u5206\u8868.docx")));
        });
        File targetZip = new File(System.getProperty("java.io.tmpdir") + ("season" + season.id()) + Files$.MODULE$.$div() + ("group" + group.id()) + Files$.MODULE$.$div() + "batch.zip");
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        return targetZip;
    }

    public File zipGroupPapers(GraduateSeason season, DefenseGroup group, Iterable<ThesisPaper> papers) {
        File dir = new File(System.getProperty("java.io.tmpdir") + ("season" + season.id()) + Files$.MODULE$.$div() + ("group" + group.id()) + Files$.MODULE$.$div() + "batch");
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        dir.mkdirs();
        IntRef paperCount = IntRef.create((int)0);
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        papers.foreach((Function1)(JProcedure1 & Serializable)paper -> blob.url(paper.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
            String stdName = StdNamePurifier$.MODULE$.purify(paper.writer().std().name());
            String fileName = dir.getAbsolutePath() + Files$.MODULE$.$div() + paper.writer().std().code() + "_" + stdName + "." + Strings$.MODULE$.substringAfterLast(paper.filePath(), ".");
            HttpUtils$.MODULE$.download(url.openConnection(), new File(fileName));
            ++paperCount$2.elem;
        }));
        File targetZip = new File(System.getProperty("java.io.tmpdir") + ("season" + season.id()) + Files$.MODULE$.$div() + ("group" + group.id()) + Files$.MODULE$.$div() + "batch.zip");
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        return targetZip;
    }

    public int download(File dir, Iterable<ThesisPaper> papers) {
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        IntRef paperCount = IntRef.create((int)0);
        papers.foreach((Function1)(JProcedure1 & Serializable)paper -> {
            if (paper.filePath().startsWith("/")) {
                blob.url(paper.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
                    String stdName = StdNamePurifier$.MODULE$.purify(paper.writer().std().name());
                    String fileName = paper.writer().std().code() + "_" + stdName + "." + Strings$.MODULE$.substringAfterLast(paper.filePath(), ".");
                    String filePath = dir.getAbsolutePath() + Files$.MODULE$.$div() + fileName;
                    HttpUtils$.MODULE$.download(url.openConnection(), new File(filePath));
                    ++paperCount$4.elem;
                });
                return;
            }
        });
        return paperCount.elem;
    }

    public int download(File dir, Iterable<ThesisCheck> checks, Function1<ThesisCheck, String> naming) {
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        IntRef paperCount = IntRef.create((int)0);
        checks.foreach((Function1)(JProcedure1 & Serializable)check -> check.paperDoc().foreach((Function1)(JProcedure1 & Serializable)paper -> {
            if (paper.filePath().startsWith("/")) {
                blob.url(paper.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
                    String stdName = StdNamePurifier$.MODULE$.purify(paper.writer().std().name());
                    String fileName = (String)naming.apply(check);
                    File paperFile = new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + fileName);
                    paperFile.delete();
                    HttpUtils$.MODULE$.download(url.openConnection(), paperFile);
                    ++paperCount$7.elem;
                    check.coverDoc().foreach((Function1)(JProcedure1 & Serializable)cover -> {
                        if (cover.filePath().startsWith("/")) {
                            blob.url(cover.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
                                File coverFile = new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + cover.writer().std().code() + ".pdf");
                                HttpUtils$.MODULE$.download(url.openConnection(), coverFile);
                                if (coverFile.exists() && paperFile.exists()) {
                                    try {
                                        try {
                                            PDFMerger$.MODULE$.mergeFiles((Seq)((SeqOps)new .colon.colon((Object)coverFile, (List)new .colon.colon((Object)paperFile, (List)Nil$.MODULE$))), paperFile);
                                        }
                                        catch (Exception e) {
                                            Logger$.MODULE$.error$extension(MODULE$.logger(), () -> PaperDownloadHelper$.download$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(coverFile, paperFile), () -> PaperDownloadHelper$.download$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(e));
                                        }
                                    }
                                    finally {
                                        coverFile.delete();
                                    }
                                    return;
                                }
                            });
                            return;
                        }
                    });
                });
                return;
            }
        }));
        return paperCount.elem;
    }

    public Seq<File> downloadDocs(File dir, Map<Writer, Iterable<ThesisDoc>> docs, Option<Function1<Writer, String>> naming) {
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        Buffer zipFiles = Collections$.MODULE$.newBuffer();
        docs.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object object;
                Writer w = (Writer)tuple2._1();
                Iterable wdocs = (Iterable)tuple2._2();
                String stdName = StdNamePurifier$.MODULE$.purify(w.std().name());
                String stdDocRoot = dir.getAbsolutePath() + Files$.MODULE$.$div() + w.std().code() + "_" + Random$.MODULE$.nextString(8);
                new File(stdDocRoot).mkdirs();
                Buffer innerFiles = Collections$.MODULE$.newBuffer();
                wdocs.foreach((Function1)(JProcedure1 & Serializable)doc -> {
                    String str = doc.writer().std().code() + " " + doc.filePath() + " " + doc.docType().name();
                });
                Workers$.MODULE$.work(wdocs, (Function1)(JProcedure1 & Serializable)doc -> blob.url(doc.filePath()).foreach((Function1)(JProcedure1 & Serializable)url -> {
                    String fileName = w.std().code() + "_" + stdName + (doc.docType().name() + ".") + Strings$.MODULE$.substringAfterLast(doc.filePath(), ".");
                    File localFile = new File(stdDocRoot + Files$.MODULE$.$div() + fileName);
                    HttpUtils$.MODULE$.download(url.openConnection(), localFile);
                    if (localFile.exists()) {
                        innerFiles.addOne((Object)localFile);
                        return;
                    }
                }), Runtime.getRuntime().availableProcessors());
                Option option = naming;
                if (None$.MODULE$.equals(option)) {
                    object = w.std().code() + "_" + stdName + ".zip";
                } else if (option instanceof Some) {
                    Function1 n = (Function1)((Some)option).value();
                    object = (String)n.apply((Object)w);
                } else {
                    throw new MatchError((Object)option);
                }
                String zipName = object;
                Predef$.MODULE$.println((Object)("generate " + zipName));
                File zipFile = new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + zipName);
                Zipper$.MODULE$.zip(new File(stdDocRoot), (Seq)innerFiles, zipFile, "utf-8");
                Files$.MODULE$.travel(new File(stdDocRoot), (Function1)(JProcedure1 & Serializable)f -> f.delete());
                new File(stdDocRoot).delete();
                return (Buffer)zipFiles.addOne((Object)zipFile);
            }
            throw new MatchError((Object)tuple2);
        });
        return zipFiles;
    }

    public Option<Function1<Writer, String>> downloadDocs$default$3() {
        return None$.MODULE$;
    }

    private static final String download$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(File coverFile$1, File paperFile$3) {
        return "merge file errors:" + coverFile$1.getAbsolutePath() + " and " + paperFile$3.getAbsolutePath();
    }

    private static final Throwable download$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(Exception e$1) {
        return e$1;
    }
}

