/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.Signature;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.helper.SignatureHelper$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class SignatureAction
extends RestfulAction<Signature>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private WebBusinessLogger businessLogger;

    public SignatureAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateOn desc");
        this.put("seasons", this.entityDao().search((QueryBuilder)gQuery));
    }

    public View init() {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("signature.writer.season")));
        OqlBuilder q = OqlBuilder$.MODULE$.from(ThesisPaper.class, "paper");
        q.where("paper.writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        q.where("not exists(from " + Signature.class.getName() + " a where a.writer=paper.writer)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.immutable.Seq papers = this.entityDao().search((QueryBuilder)q);
        scala.collection.immutable.Seq archives = (scala.collection.immutable.Seq)papers.map((Function1 & Serializable)x -> new Signature(x.writer()));
        this.entityDao().saveOrUpdate((Iterable)archives);
        return this.redirect("search", "\u521d\u59cb\u5316\u6210\u529f");
    }

    public OqlBuilder<Signature> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        query.where("signature.writer.std.state.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        this.getBoolean("writerSigned").foreach((Function1 & Serializable)signed -> SignatureAction.getQueryBuilder$$anonfun$1(query, BoxesRunTime.unboxToBoolean((Object)signed)));
        this.getBoolean("advisorSigned").foreach((Function1 & Serializable)signed -> SignatureAction.getQueryBuilder$$anonfun$2(query, BoxesRunTime.unboxToBoolean((Object)signed)));
        return query;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Signature signature = (Signature)this.entityDao().get(Signature.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        signature.writerUrl().foreach((Function1)(JProcedure1 & Serializable)url -> this.put("writer_signature", SignatureHelper$.MODULE$.readBase64((String)url)));
        signature.advisorUrl().foreach((Function1)(JProcedure1 & Serializable)url -> this.put("advisor_signature", SignatureHelper$.MODULE$.readBase64((String)url)));
        this.put("signature", signature);
        return this.forward(this.forward$default$1());
    }

    public View uploadAdvisorSignature() {
        Advisor advisor = (Advisor)this.entityDao().get(Advisor.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("advisor")));
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("signature.writer.season")));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.advisor=:advisor", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor}));
        query.where("writer.thesisTitle is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.orderBy("writer.std.code");
        scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
        Iterable parts = this.getAll("signature_file", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            Option first = this.entityDao().findBy(Signature.class, "writer", (Object)writers).find((Function1 & Serializable)_$2 -> _$2.advisorUrl().nonEmpty());
            first.foreach((Function1)(JProcedure1 & Serializable)s -> s.advisorUrl().foreach((Function1 & Serializable)url -> blob.remove(url)));
            Part part = (Part)parts.head();
            String code = SignatureHelper$.MODULE$.toBase64(part.getInputStream(), part.getSubmittedFileName());
            String ext = Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
            BlobMeta sign = blob.upload("/" + season.id().toString() + "/signature/", (InputStream)new ByteArrayInputStream(code.getBytes()), advisor.code() + ("." + ext + ".txt"), advisor.code() + " " + advisor.name());
            writers.foreach((Function1)(JProcedure1 & Serializable)writer -> {
                Signature signature = (Signature)this.entityDao().findBy(Signature.class, "writer", writer).headOption().getOrElse(() -> SignatureAction.$anonfun$3(writer));
                signature.advisorUrl_$eq((Option)Some$.MODULE$.apply((Object)sign.filePath()));
                this.entityDao().saveOrUpdate((Object)signature, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Signature[0]));
            });
            this.businessLogger().info("\u4e0a\u4f20\u4e86" + advisor.name() + "\u7684\u7b7e\u540d\u56fe\u7247", advisor.id(), (Object)Predef$.MODULE$.Map().empty());
        }
        return this.redirect("search", "\u4e0a\u4f20\u6210\u529f");
    }

    public View download() {
        scala.collection.immutable.Seq signatures = this.entityDao().find(Signature.class, (Iterable)this.getLongIds("signature"));
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        Map advisorSignatures = Collections$.MODULE$.newMap();
        signatures.foreach((Function1)(JProcedure1 & Serializable)s -> {
            if (s.advisorUrl().nonEmpty()) {
                advisorSignatures.put(s.writer().advisor().get(), s.advisorUrl().get());
                return;
            }
        });
        File docRoot = new File(SystemInfo$.MODULE$.tmpDir() + "/signatures" + System.currentTimeMillis());
        docRoot.mkdirs();
        Buffer innerFiles = Collections$.MODULE$.newBuffer();
        advisorSignatures.foreach((Function1)(JProcedure1 & Serializable)sig -> blob.url((String)sig._2()).foreach((Function1)(JProcedure1 & Serializable)url -> {
            Advisor advisor = (Advisor)sig._1();
            String fileName = advisor.code() + "_" + advisor.name() + ".png";
            File localFile = new File(docRoot.getAbsolutePath() + Files$.MODULE$.$div() + fileName);
            byte[] bytes = SignatureHelper$.MODULE$.readBase64toBytes((String)sig._2());
            IOs$.MODULE$.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)new FileOutputStream(localFile));
            if (localFile.exists()) {
                innerFiles.addOne((Object)localFile);
                return;
            }
        }));
        File zipFile = new File(SystemInfo$.MODULE$.tmpDir() + Files$.MODULE$.$div() + ("\u7b7e\u540d" + innerFiles.size() + "\u4eba.zip"));
        Zipper$.MODULE$.zip(docRoot, (Seq)innerFiles, zipFile, "utf-8");
        Files$.MODULE$.travel(docRoot, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        docRoot.delete();
        return Stream$.MODULE$.apply(zipFile).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> zipFile.delete());
    }

    public String simpleEntityName() {
        return "signature";
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder query$1, boolean signed) {
        if (signed) {
            return (OqlBuilder)query$1.where("signature.writerUrl is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return (OqlBuilder)query$1.where("signature.writerUrl is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder query$2, boolean signed) {
        if (signed) {
            return (OqlBuilder)query$2.where("signature.advisorUrl is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return (OqlBuilder)query$2.where("signature.advisorUrl is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private static final Signature $anonfun$3(Writer writer$1) {
        return new Signature(writer$1);
    }
}

