/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.helper.QueryHelper$;
import org.beangle.webmvc.view.View;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.helper.AdvisorSubjectStat;
import org.openurp.degree.thesis.web.helper.AdvisorSubjectStat$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class TitleStatAction
extends ActionSupport
implements EntityAction<AdvisorSubjectStat>,
ProjectSupport,
ExportSupport<AdvisorSubjectStat> {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;

    public TitleStatAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq seasons = this.entityDao().getAll(GraduateSeason.class);
        this.put("seasons", seasons.sortBy((Function1 & Serializable)_$2 -> _$2.graduateOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Teacher.class, "t");
        query.where("t.staff.school=:school", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.project$1(lazyRef).school()}));
        query.select("distinct t.staff.title");
        query.orderBy("t.staff.title.code");
        this.put("departs", this.getDeparts(this.project$1(lazyRef)));
        this.put("titles", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    public View stat() {
        boolean statByAdvisor = this.getBoolean("statByAdvisor", true);
        this.put("stats", this.getQueryData(statByAdvisor));
        if (statByAdvisor) {
            return this.forward("byAdvisor");
        }
        return this.forward("bySeason");
    }

    private Seq<AdvisorSubjectStat> getQueryData(boolean statByAdvisor) {
        GraduateSeason fromSeason = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("fromSeason")));
        GraduateSeason toSeason = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("toSeason")));
        this.put("fromSeason", fromSeason);
        this.put("toSeason", toSeason);
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class.getName(), "writer");
        query.where("writer.season.graduateOn between :startYear and :endYear", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fromSeason.graduateOn(), toSeason.graduateOn()}));
        query.where("writer.advisor is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        QueryHelper$.MODULE$.populate(query);
        if (statByAdvisor) {
            query.groupBy("writer.advisor.id");
            v0 = (OqlBuilder)query.select("writer.advisor.id,count(*)");
        } else {
            query.groupBy("writer.season.id,writer.advisor.id");
            v0 = (OqlBuilder)query.select("writer.season.id,writer.advisor.id,count(*)");
        }
        scala.collection.immutable.Seq results = this.entityDao().search((QueryBuilder)query);
        scala.collection.immutable.Seq stats = (scala.collection.immutable.Seq)results.map((Function1 & Serializable)line -> {
            if (statByAdvisor) {
                Advisor advisor = (Advisor)this.entityDao().get(Advisor.class, (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)line[0])));
                return AdvisorSubjectStat$.MODULE$.apply(advisor, ((Number)line[1]).intValue());
            }
            GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(((Number)line[0]).intValue())));
            Advisor advisor = (Advisor)this.entityDao().get(Advisor.class, (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)line[1])));
            return AdvisorSubjectStat$.MODULE$.apply(season, advisor, ((Number)line[2]).intValue());
        });
        if (statByAdvisor) {
            return (Seq)stats.toBuffer().sortBy((Function1 & Serializable)x -> x.advisor().teacher().department().code() + x.advisor().teacher().code(), (Ordering)Ordering.String$.MODULE$);
        }
        return (Seq)stats.toBuffer().sortBy((Function1 & Serializable)x -> x.advisor().teacher().department().code() + x.advisor().teacher().code() + x.season().graduateOn().toString(), (Ordering)Ordering.String$.MODULE$);
    }

    public void configExport(ExportContext context) {
        context.put("items", this.getQueryData(this.getBoolean("statByAdvisor", true)));
    }

    public View writers() {
        Advisor advisor = (Advisor)this.entityDao().get(Advisor.class, this.getLong("advisorId").get());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.thesisTitle is not null and writer.advisor = :advisor", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor}));
        scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
        Map seasonWriters = writers.groupBy((Function1 & Serializable)_$3 -> _$3.season());
        this.put("seasonWriters", seasonWriters);
        this.put("advisor", advisor);
        return this.forward(this.forward$default$1());
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }
}

