/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.advisor;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.lang.Numbers$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.BlindPeerReview;
import org.openurp.degree.thesis.model.CopyCheck;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.MidtermCheck;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.action.advisor.AdvisorSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ReviewAction
extends AdvisorSupport {
    public View index() {
        Advisor advisor = this.getAdvisor();
        Iterable<Writer> writers = this.getWriters();
        Map papers = ((IterableOnceOps)this.entityDao().findBy(ThesisPaper.class, "writer", writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("papers", papers);
        Map reviews = ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map checks = this.entityDao().findBy(CopyCheck.class, "writer", writers).groupBy((Function1 & Serializable)_$1 -> _$1.writer());
        Map midtermChecks = ((IterableOnceOps)this.entityDao().findBy(MidtermCheck.class, "writer", writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map blindReviews = ((IterableOnceOps)this.entityDao().findBy(BlindPeerReview.class, "writer", writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("checks", checks);
        this.put("reviews", reviews);
        this.put("writers", writers);
        this.put("midtermChecks", midtermChecks);
        this.put("blindReviews", blindReviews);
        return this.forward(this.forward$default$1());
    }

    public View review() {
        Writer writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        ThesisReview review = (ThesisReview)this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption().getOrElse(ReviewAction::$anonfun$6);
        this.put("writer", writer);
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
        Seq checks = this.entityDao().findBy(CopyCheck.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("checks", checks);
        this.put("review", review);
        this.put("blindReview", this.entityDao().findBy(BlindPeerReview.class, "writer", (Object)writer).headOption());
        if (review.advisorScore().isEmpty()) {
            return this.forward(this.forward$default$1());
        }
        ThesisPlan plan = (ThesisPlan)this.thesisPlanService().getPlan().get();
        Option dp = plan.departPlans().find((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = review.writer().department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        Option option = dp;
        if (None$.MODULE$.equals(option)) {
            v1 = this.redirect("index", "\u4e0d\u5728\u8bc4\u5206\u65f6\u95f4");
        } else if (option instanceof Some) {
            boolean intime;
            DepartPlan p = (DepartPlan)((Some)option).value();
            boolean bl = intime = p.getStageTime(Stage$.ThesisReview).timeSuitable(Instant.now()) == 0;
            v1 = intime ? this.forward(this.forward$default$1()) : this.redirect("index", "\u4e0d\u5728\u8bc4\u5206\u65f6\u95f4");
        } else {
            throw new MatchError((Object)option);
        }
        return this.forward(this.forward$default$1());
    }

    public View saveReview() {
        Writer writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        ThesisReview review = (ThesisReview)this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption().getOrElse(ReviewAction::$anonfun$8);
        review.writer_$eq(writer);
        review.subjectScore_$eq(this.getInt("review.subjectScore"));
        review.subjectScore_$eq(this.getInt("review.subjectScore"));
        review.writeScore_$eq(this.getInt("review.writeScore"));
        review.researchScore_$eq(this.getInt("review.researchScore"));
        review.innovationScore_$eq(this.getInt("review.innovationScore"));
        review.attitudeScore_$eq(this.getInt("review.attitudeScore"));
        review.advisorReviewAt_$eq((Option)Some$.MODULE$.apply((Object)Instant.now()));
        int finalScore = BoxesRunTime.unboxToInt((Object)review.subjectScore().getOrElse(ReviewAction::$anonfun$9)) + BoxesRunTime.unboxToInt((Object)review.writeScore().getOrElse(ReviewAction::$anonfun$10)) + BoxesRunTime.unboxToInt((Object)review.researchScore().getOrElse(ReviewAction::$anonfun$11)) + BoxesRunTime.unboxToInt((Object)review.innovationScore().getOrElse(ReviewAction::$anonfun$12)) + BoxesRunTime.unboxToInt((Object)review.attitudeScore().getOrElse(ReviewAction::$anonfun$13));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"recheck");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq checks = this.entityDao().findBy(CopyCheck.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Option blindReview = this.entityDao().findBy(BlindPeerReview.class, "writer", (Object)writer).headOption();
        if (checks.exists((Function1 & Serializable)_$2 -> !_$2.passed()) && finalScore > 70) {
            return this.redirect("review", "writer.id=" + writer.id(), "\u5206\u6570\u8d85\u8fc7\u4e8670\u5206");
        }
        Option option = blindReview;
        if (None$.MODULE$.equals(option)) {
            review.advisorSelfScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)finalScore)));
            review.advisorScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)finalScore)));
            review.blindReviewScore_$eq((Option)None$.MODULE$);
            String msg = "\u8bc4\u9605\u4e86" + writer.std().name() + "\u7684\u8bba\u6587\uff0c\u603b\u5206:" + finalScore;
            Object[] objectArray2 = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.id");
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, writer.id());
            this.businessLogger().info(msg, writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
            this.entityDao().saveOrUpdate((Object)review, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisReview[0]));
            return this.redirect("index", "\u4fdd\u5b58\u6210\u529f");
        }
        if (option instanceof Some) {
            BlindPeerReview r = (BlindPeerReview)((Some)option).value();
            Option option2 = r.score();
            if (None$.MODULE$.equals(option2)) {
                return this.redirect("review", "writer.id=" + writer.id(), "\u6821\u5916\u9001\u5ba1\u6210\u7ee9\u5c1a\u672a\u516c\u5e03\uff0c\u6682\u505c\u6253\u5206");
            }
            if (option2 instanceof Some) {
                int s = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                int avgScore = (int)Numbers$.MODULE$.round((double)finalScore * 0.4 + (double)((float)s * 0.6f), 0);
                if (checks.exists((Function1 & Serializable)_$3 -> !_$3.passed()) && avgScore > 70) {
                    return this.redirect("review", "writer.id=" + writer.id(), "\u548c\u6821\u5916\u9001\u5ba1\u6c47\u603b\u540e\uff0c\u5206\u6570\u4e3a" + avgScore + "\u8d85\u8fc7\u4e8670\u5206");
                }
                review.advisorSelfScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)finalScore)));
                review.blindReviewScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)s)));
                review.advisorScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)avgScore)));
                String msg = "\u8bc4\u9605\u4e86" + writer.std().name() + "\u7684\u8bba\u6587\uff0c\u603b\u5206:" + finalScore + ", \u7ed3\u5408\u6821\u5916\u9001\u5ba1\u6210\u7ee9:" + s + ",\u6700\u7ec8\u5206:" + avgScore;
                Object[] objectArray3 = new Tuple2[1];
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.id");
                objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, writer.id());
                this.businessLogger().info(msg, writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)));
                this.entityDao().saveOrUpdate((Object)review, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisReview[0]));
                return this.redirect("index", "\u4fdd\u5b58\u6210\u529f");
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private static final ThesisReview $anonfun$6() {
        return new ThesisReview();
    }

    private static final ThesisReview $anonfun$8() {
        return new ThesisReview();
    }

    private static final int $anonfun$9() {
        return 0;
    }

    private static final int $anonfun$10() {
        return 0;
    }

    private static final int $anonfun$11() {
        return 0;
    }

    private static final int $anonfun$12() {
        return 0;
    }

    private static final int $anonfun$13() {
        return 0;
    }
}

