/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.Serializable;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.conversion.string.BooleanConverter$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Commitment;
import org.openurp.degree.thesis.model.Deadline;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DeferService;
import org.openurp.degree.thesis.service.ThesisPlanService;
import org.openurp.degree.thesis.web.helper.CommitmentPropertyExtractor;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class CommitmentAction
extends ActionSupport
implements EntityAction<Writer>,
ExportSupport<Writer>,
ProjectSupport {
    private Class entityClass;
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private EntityDao entityDao;
    private DeferService deferService;
    private ThesisPlanService thesisPlanService;

    public CommitmentAction() {
        EntitySupport.$init$((EntitySupport)this);
        ProjectSupport.$init$((ProjectSupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public DeferService deferService() {
        return this.deferService;
    }

    public void deferService_$eq(DeferService x$1) {
        this.deferService = x$1;
    }

    public ThesisPlanService thesisPlanService() {
        return this.thesisPlanService;
    }

    public void thesisPlanService_$eq(ThesisPlanService x$1) {
        this.thesisPlanService = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", (Object)this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateOn desc");
        this.put("seasons", (Object)this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<Writer> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        Seq departs = this.getDeparts(this.project$2(lazyRef));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.std.state.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        this.populateConditions(query);
        this.get("confirmed").foreach((Function1)(JProcedure1 & Serializable)confirmed -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)confirmed)) {
                if (Predef$.MODULE$.Boolean2boolean(BooleanConverter$.MODULE$.apply(confirmed))) {
                    query.where("exists(from " + Commitment.class.getName() + " c where c.writer=writer and c.confirmed=true)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                    return;
                }
                query.where("not exists(from " + Commitment.class.getName() + " c where c.writer=writer and c.confirmed=true)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                return;
            }
        });
        query.orderBy((String)this.get(Order$.MODULE$.OrderStr(), (Object)"writer.std.code"));
        query.limit(this.getPageLimit());
        return query;
    }

    public View search() {
        OqlBuilder query = this.getQueryBuilder();
        Seq writers = this.entityDao().search((QueryBuilder)query);
        this.put("writers", (Object)writers);
        Map commitments = ((IterableOnceOps)this.entityDao().findBy(Commitment.class, "writer", (Object)writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("commitments", (Object)commitments);
        this.put("stage", (Object)Stage$.Commitment);
        return this.forward(this.forward$default$1());
    }

    public View defer() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        writers.foreach((Function1)(JProcedure1 & Serializable)writer -> {
            Deadline deadline = writer.getOrCreateDeadline(Stage$.Commitment);
            this.deferService().defer(deadline, Stage$.Commitment);
        });
        return this.redirect("search", "\u5ef6\u671f\u6210\u529f");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Commitment commitment = (Commitment)this.entityDao().get(Commitment.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Writer writer = commitment.writer();
        this.put("commitment", (Object)commitment);
        this.put("writer", (Object)writer);
        this.put("deadline", (Object)writer.getOrCreateDeadline(Stage$.Commitment));
        this.put("plan", (Object)this.thesisPlanService().getDepartPlan(writer));
        return this.forward(this.forward$default$1());
    }

    public void configExport(ExportContext context) {
        context.extractor_$eq((PropertyExtractor)new CommitmentPropertyExtractor(this.entityDao()));
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

