/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.director;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Major;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DefenseGroupService;
import org.openurp.degree.thesis.web.action.director.DirectorSupport;
import org.openurp.degree.thesis.web.helper.RandomReviewAssigner$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CrossReviewAction
extends DirectorSupport {
    private DefenseGroupService groupService;

    public DefenseGroupService groupService() {
        return this.groupService;
    }

    public void groupService_$eq(DefenseGroupService x$1) {
        this.groupService = x$1;
    }

    public View index() {
        Seq offices = this.getOffices();
        this.put("offices", (Object)offices);
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        Iterable advisors = this.groupService().getManageTeacher(this.getAdvisor(), season);
        Iterable reviews = this.listReviews(season);
        this.put("advisors", (Object)advisors);
        this.put("reviews", (Object)reviews);
        this.put("teacherMajors", (Object)this.getTeacherMajors(season, advisors));
        Map reviewStats = ((IterableOps)reviews.filter((Function1 & Serializable)_$2 -> _$2.crossReviewer().nonEmpty())).groupBy((Function1 & Serializable)_$3 -> (Teacher)_$3.crossReviewer().get());
        Map adviseStats = ((IterableOps)reviews.filter((Function1 & Serializable)_$4 -> _$4.writer().advisor().nonEmpty())).groupBy((Function1 & Serializable)_$5 -> ((Advisor)_$5.writer().advisor().get()).teacher());
        this.put("adviseStats", (Object)adviseStats);
        this.put("reviewStats", (Object)reviewStats);
        return this.forward(this.forward$default$1());
    }

    private Iterable<ThesisReview> listReviews(GraduateSeason season) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisReview.class, "review");
        query.where("review.writer.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("review.crossReviewManager=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getAdvisor().teacher()}));
        query.orderBy("review.writer.std.state.major.id,review.writer.advisor.id,review.writer.std.code");
        return this.entityDao().search((QueryBuilder)query);
    }

    public View batchAssignSetting() {
        Seq reviews = this.entityDao().find(ThesisReview.class, (Iterable)this.getLongIds("thesisReview"));
        Advisor advisor = this.getAdvisor();
        this.put("crossReviewers", (Object)this.groupService().getManageTeacher(advisor, ((ThesisReview)reviews.head()).writer().season()));
        this.put("thesisReviews", (Object)reviews);
        return this.forward(this.forward$default$1());
    }

    public View batchAssign() {
        Seq reviews = this.entityDao().find(ThesisReview.class, (Iterable)this.getLongIds("thesisReview"));
        Option reviewer = this.getLong("crossReviewer.id").map((Function1 & Serializable)id -> this.$anonfun$5(BoxesRunTime.unboxToLong((Object)id)));
        reviews.foreach((Function1)(JProcedure1 & Serializable)r -> {
            Option option = reviewer;
            if (None$.MODULE$.equals(option)) {
                r.crossReviewer_$eq((Option)None$.MODULE$);
                return;
            }
            if (option instanceof Some) {
                Teacher t = (Teacher)((Some)option).value();
                if (!r.writer().advisor().map((Function1 & Serializable)_$6 -> _$6.teacher()).contains((Object)t)) {
                    r.crossReviewer_$eq(reviewer);
                    return;
                }
                return;
            }
            throw new MatchError((Object)option);
        });
        this.entityDao().saveOrUpdate((Iterable)reviews);
        return this.redirect("index", "\u6307\u6d3e\u6210\u529f");
    }

    public View randomAssign() {
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        Iterable reviews = (Iterable)this.listReviews(season).filter((Function1 & Serializable)_$7 -> _$7.crossReviewer().isEmpty());
        Iterable advisors = this.groupService().getManageTeacher(this.getAdvisor(), season);
        RandomReviewAssigner$.MODULE$.assign(reviews, advisors);
        this.entityDao().saveOrUpdate(reviews);
        return this.redirect("index", "\u968f\u673a\u5206\u914d\u6210\u529f");
    }

    private Map<Teacher, Set<Major>> getTeacherMajors(GraduateSeason season, Iterable<Teacher> teachers) {
        OqlBuilder sQuery = OqlBuilder$.MODULE$.from(Writer.class.getName(), "w");
        sQuery.where("w.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        sQuery.where("w.advisor is not null and w.std.state.major is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        sQuery.select("distinct w.advisor.teacher,w.std.state.major");
        sQuery.where("w.advisor.teacher in(:teachers)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{teachers}));
        scala.collection.mutable.Map rs = Collections$.MODULE$.newMap();
        rs.$plus$plus$eq((IterableOnce)((IterableOps)this.entityDao().search((QueryBuilder)sQuery).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)((Teacher)x[0]), (Object)((Major)x[1])))).groupBy((Function1 & Serializable)_$8 -> (Teacher)_$8._1()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), (Object)((IterableOnceOps)((IterableOps)x._2()).map((Function1 & Serializable)_$9 -> (Major)_$9._2())).toSet())));
        teachers.foreach((Function1)(JProcedure1 & Serializable)t -> {
            if (!rs.contains(t)) {
                rs.put(t, (Object)Predef$.MODULE$.Set().empty());
                return;
            }
        });
        return rs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final /* synthetic */ Teacher $anonfun$5(long id) {
        return (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)id));
    }
}

