/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.std;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.Proposal;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.Subject;
import org.openurp.degree.thesis.model.SubjectApply;
import org.openurp.degree.thesis.model.SubjectApply$;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.action.std.WriterSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class SubjectAction
extends WriterSupport {
    public View index() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        this.put("plan", (Object)plan);
        this.put("writer", (Object)writer);
        if (writer.mobile().isEmpty()) {
            return this.forward("contact");
        }
        this.put("StageRound1", (Object)Stage$.SubjectChosenRound1);
        this.put("StageRound2", (Object)Stage$.SubjectChosenRound2);
        OqlBuilder query = OqlBuilder$.MODULE$.from(SubjectApply.class, "c");
        query.where("c.writer=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}));
        Option apply = this.entityDao().first((QueryBuilder)query);
        this.put("apply", (Object)apply);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Proposal.class, "p");
        query2.where("p.writer=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}));
        this.put("hasProposal", (Object)BoxesRunTime.boxToBoolean((boolean)this.entityDao().first((QueryBuilder)query2).nonEmpty()));
        return this.forward(this.forward$default$1());
    }

    private Option<View> checkTime(int round, Option<DepartPlan> plans) {
        if (plans.isEmpty()) {
            return Some$.MODULE$.apply((Object)this.forward("not_intime"));
        }
        DepartPlan plan = (DepartPlan)plans.get();
        Instant today = Instant.now();
        int n = round;
        if (SubjectApply$.MODULE$.Round1() == n) {
            StageTime stageTime = plan.getStageTime(Stage$.SubjectChosenRound1);
            if (stageTime.timeSuitable(today) != 0) {
                this.put("begin", (Object)stageTime.beginOn());
                this.put("end", (Object)stageTime.endOn());
                return Some$.MODULE$.apply((Object)this.forward("not_intime"));
            }
        } else if (SubjectApply$.MODULE$.Round2() == n) {
            StageTime stageTime = plan.getStageTime(Stage$.SubjectChosenRound2);
            if (stageTime.timeSuitable(today) != 0) {
                this.put("begin", (Object)stageTime.beginOn());
                this.put("end", (Object)stageTime.endOn());
                return Some$.MODULE$.apply((Object)this.forward("not_intime"));
            }
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return None$.MODULE$;
    }

    public View candinates() {
        View view;
        Object object = new Object();
        try {
            Writer writer = this.getWriter();
            Option plan = this.thesisPlanService().getDepartPlan(writer);
            if (plan.isEmpty()) {
                view = this.forward("not_intime");
            } else {
                GraduateSeason season = ((DepartPlan)Option$.MODULE$.option2Iterable(plan).head()).thesisPlan().season();
                this.put("plan", (Object)plan);
                int round = this.getInt("round", SubjectApply$.MODULE$.Round1());
                this.checkTime(round, plan).foreach((Function1 & Serializable)v -> {
                    throw new NonLocalReturnControl(object, v);
                });
                OqlBuilder subjectQuery = OqlBuilder$.MODULE$.from(Subject.class, "s");
                subjectQuery.where("s.depart=:depart", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer.department()}));
                subjectQuery.where("s.status = :status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Passed}));
                subjectQuery.where(":major in elements(s.majors)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer.major()}));
                subjectQuery.where("s.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
                subjectQuery.where("not exists(from " + SubjectApply.class.getName() + " apply where apply.last=s)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                Seq candinates = this.entityDao().search((QueryBuilder)subjectQuery);
                this.put("candinates", (Object)candinates);
                OqlBuilder stat = OqlBuilder$.MODULE$.from(SubjectApply.class.getName(), "apply");
                stat.where("apply.writer.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
                int n = round;
                OqlBuilder oqlBuilder = SubjectApply$.MODULE$.Round1() == n ? (OqlBuilder)stat.where("apply.first is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).groupBy("apply.first.id").select("apply.first.id,count(*)") : (SubjectApply$.MODULE$.Round2() == n ? (OqlBuilder)stat.where("apply.second is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).groupBy("apply.second.id").select("apply.second.id,count(*)") : (SubjectApply$.MODULE$.Final() == n ? (OqlBuilder)stat.where("apply.last is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).groupBy("apply.last.id").select("apply.last.id,count(*)") : (OqlBuilder)stat.where("1=0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))));
                Map stats = ((IterableOnceOps)this.entityDao().search((QueryBuilder)stat).map((Function1 & Serializable)x -> {
                    Object object = Predef$.MODULE$.ArrowAssoc(x[0]);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, x[1]);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.put("applyStats", (Object)stats);
                view = this.forward(round == SubjectApply$.MODULE$.Round1() ? "candinates_cx" : "candinates_bx");
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                view = (View)ex.value();
            }
            throw ex;
        }
        return view;
    }

    public View applies() {
        int round = this.getInt("round", SubjectApply$.MODULE$.Round1());
        OqlBuilder query = OqlBuilder$.MODULE$.from(SubjectApply.class, "apply");
        long subjectId = BoxesRunTime.unboxToLong((Object)this.getLong("subjectId").getOrElse(SubjectAction::$anonfun$2));
        int n = round;
        OqlBuilder oqlBuilder = SubjectApply$.MODULE$.Round1() == n ? (OqlBuilder)query.where("apply.first.id=:subjectId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)subjectId)})) : (SubjectApply$.MODULE$.Round2() == n ? (OqlBuilder)query.where("apply.second.id=:subjectId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)subjectId)})) : (SubjectApply$.MODULE$.Final() == n ? (OqlBuilder)query.where("apply.last.id=:subjectId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)subjectId)})) : (OqlBuilder)query.where("1=0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))));
        this.put("applies", (Object)this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    public View doApply() {
        View view;
        Object object = new Object();
        try {
            SubjectApply subjectApply;
            Writer writer = this.getWriter();
            int round = this.getInt("round", SubjectApply$.MODULE$.Round1());
            Option plans = this.thesisPlanService().getDepartPlan(writer);
            this.checkTime(round, plans).foreach((Function1 & Serializable)v -> {
                throw new NonLocalReturnControl(object, v);
            });
            OqlBuilder query = OqlBuilder$.MODULE$.from(SubjectApply.class, "xz");
            query.where("xz.writer=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}));
            Option option = this.entityDao().search((QueryBuilder)query).headOption();
            if (option instanceof Some) {
                SubjectApply apply = (SubjectApply)((Some)option).value();
                if (apply.currentRound() == 0) {
                    apply.currentRound_$eq(round);
                }
                subjectApply = apply;
            } else if (None$.MODULE$.equals(option)) {
                SubjectApply ap = new SubjectApply();
                ap.currentRound_$eq(round);
                subjectApply = ap;
            } else {
                throw new MatchError((Object)option);
            }
            SubjectApply apply = subjectApply;
            long subjectId = BoxesRunTime.unboxToLong((Object)this.getLong("subjectId").getOrElse(SubjectAction::$anonfun$3));
            Subject subject = (Subject)this.entityDao().get(Subject.class, (Object)BoxesRunTime.boxToLong((long)subjectId));
            if (apply.last().isEmpty()) {
                apply.writer_$eq(writer);
                if (round == SubjectApply$.MODULE$.Round1()) {
                    apply.first_$eq((Option)Some$.MODULE$.apply((Object)subject));
                } else {
                    apply.second_$eq((Option)Some$.MODULE$.apply((Object)subject));
                }
            }
            this.entityDao().saveOrUpdate((Object)apply, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SubjectApply[0]));
            view = this.redirect("index", "info.save.success");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                view = (View)ex.value();
            }
            throw ex;
        }
        return view;
    }

    public View edit() {
        Writer writer = this.getWriter();
        this.put("writer", (Object)writer);
        Seq apply = this.entityDao().findBy(SubjectApply.class, "writer", (Object)writer);
        apply.foreach((Function1)(JProcedure1 & Serializable)a -> this.put("subject", (Object)a.last()));
        return this.forward(this.forward$default$1());
    }

    public View save() {
        Writer writer = this.getWriter();
        Option option = this.get("thesisTitle");
        if (!None$.MODULE$.equals(option)) {
            if (option instanceof Some) {
                String oldTitle;
                String newTitle = (String)((Some)option).value();
                String string = oldTitle = (String)writer.thesisTitle().getOrElse(SubjectAction::$anonfun$4);
                String string2 = newTitle;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    Object[] objectArray = new Tuple2[2];
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"season");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)writer.season());
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"thesisTitle");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)newTitle);
                    Seq sameTitles = this.entityDao().findBy(Writer.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    if (sameTitles.nonEmpty()) {
                        return this.redirect("index", "\u8bba\u6587\u9898\u76ee\u91cd\u590d");
                    }
                }
                writer.thesisTitle_$eq((Option)Some$.MODULE$.apply((Object)newTitle));
                Option field = this.get("researchField");
                field.foreach((Function1)(JProcedure1 & Serializable)f -> writer.researchField_$eq(field));
                Seq papers = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer);
                if (papers.size() == 1) {
                    papers.foreach((Function1)(JProcedure1 & Serializable)p -> {
                        p.title_$eq(newTitle);
                        if (field.nonEmpty()) {
                            p.researchField_$eq(field);
                            return;
                        }
                    });
                }
                this.entityDao().saveOrUpdate((Object)writer, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[0]));
                this.entityDao().saveOrUpdate((Iterable)papers);
                String msg = "\u4fee\u6539\u8bba\u6587\u9898\u76ee:\u6539\u4e3a" + newTitle;
                Object[] objectArray = new Tuple2[1];
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"oldTitle");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)oldTitle);
                this.businessLogger().info(msg, writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            } else {
                throw new MatchError((Object)option);
            }
        }
        return this.redirect("index", "\u9898\u76ee\u4fee\u6539\u6210\u529f");
    }

    public View saveProfile() {
        Writer writer = this.getWriter();
        writer.mobile_$eq(this.get("mobile"));
        writer.email_$eq(this.get("email"));
        this.entityDao().saveOrUpdate((Object)writer, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[0]));
        return this.redirect("index", "\u4fdd\u5b58\u6210\u529f");
    }

    private static final long $anonfun$2() {
        return 0L;
    }

    private static final long $anonfun$3() {
        return 0L;
    }

    private static final String $anonfun$4() {
        return "--";
    }
}

