/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.service.impl;

import java.io.Serializable;
import java.time.Instant;
import javax.sql.DataSource;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.ems.app.dao.AppDataSourceFactory;
import org.beangle.jdbc.engine.Engine;
import org.beangle.jdbc.engine.Engines$;
import org.beangle.jdbc.query.JdbcExecutor;
import org.beangle.security.Securities$;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.code.edu.model.ExamMode$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.GradingMode$;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.service.ThesisGradeSyncService;
import org.openurp.edu.grade.service.GradeRateService;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ThesisGradeSyncServiceImpl
implements ThesisGradeSyncService,
Logging,
Initializing {
    private Logger logger;
    private JdbcExecutor jdbcExecutor;
    private Engine engine;
    private SemesterService semesterService;
    private DataSource datasource;
    private GradeRateService gradeRateService;
    private EntityDao entityDao;

    public ThesisGradeSyncServiceImpl() {
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public DataSource datasource() {
        return this.datasource;
    }

    public void datasource_$eq(DataSource x$1) {
        this.datasource = x$1;
    }

    public GradeRateService gradeRateService() {
        return this.gradeRateService;
    }

    public void gradeRateService_$eq(GradeRateService x$1) {
        this.gradeRateService = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void init() {
        AppDataSourceFactory dsf = new AppDataSourceFactory();
        DataSource ds = null;
        try {
            dsf.name_$eq("base");
            dsf.init();
            ds = dsf.result();
        }
        catch (Exception exception) {
            Logger$.MODULE$.info$extension(this.logger(), ThesisGradeSyncServiceImpl::init$$anonfun$1);
            ds = this.datasource();
        }
        this.engine = Engines$.MODULE$.forDataSource(ds);
        this.jdbcExecutor = new JdbcExecutor(ds);
    }

    @Override
    public boolean sync(ThesisReview review) {
        Student std = review.writer().std();
        Semester semester = this.semesterService().get(std.project(), review.writer().season().graduateIn().atDay(1));
        if (review.finalScore().isEmpty()) {
            return false;
        }
        Seq rs = this.jdbcExecutor.query("select cg.id,cg.score from edu.course_grades cg,base.courses kc where cg.course_id=kc.id and cg.std_id=? and cg.semester_id=? and (kc.name like '\u6bd5\u4e1a\u8bba\u6587%' or kc.name like '%\u5b66\u4f4d\u8bba\u6587%')", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{review.writer().std().id(), semester.id()}));
        ObjectRef scoreText = ObjectRef.create((Object)((String)review.finalScoreText().get()));
        if (((String)scoreText.elem).equals("\u4f18\u79c0")) {
            scoreText.elem = "\u4f18";
        } else if (((String)scoreText.elem).equals("\u826f\u597d")) {
            scoreText.elem = "\u826f";
        }
        if (rs.isEmpty()) {
            this.getCourse(std).foreach((Function1)(JProcedure1 & Serializable)ci -> {
                int gradingModeId = GradingMode$.MODULE$.RankCn();
                float score = BoxesRunTime.unboxToFloat((Object)review.finalScore().get());
                float gp = BoxesRunTime.unboxToFloat((Object)this.gradeRateService().getConverter(std.project(), new GradingMode(gradingModeId)).calcGp((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)score))).get());
                long id = this.genCourseGradeId();
                this.jdbcExecutor.update("insert into edu.course_grades(id,project_id,std_id,course_id,semester_id,course_type_id,course_take_type_id,grading_mode_id,score,score_text,gp,passed,crn,free_listening,operator,provider,status,exam_mode_id,created_at,updated_at) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), std.project().id(), std.id(), BoxesRunTime.boxToLong((long)ci._1$mcJ$sp()), semester.id(), BoxesRunTime.boxToInteger((int)ci._2$mcI$sp()), BoxesRunTime.boxToInteger((int)CourseTakeType$.MODULE$.Normal()), BoxesRunTime.boxToInteger((int)gradingModeId), BoxesRunTime.boxToFloat((float)score), (String)scoreText$1.elem, BoxesRunTime.boxToFloat((float)gp), BoxesRunTime.boxToBoolean((score >= (float)60 ? 1 : 0) != 0), "--", BoxesRunTime.boxToBoolean((boolean)false), Securities$.MODULE$.user(), BoxesRunTime.unboxToLong((Object)review.id()) + "@ThesisReview", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)ExamMode$.MODULE$.Check()), Instant.now(), Instant.now()}));
                review.courseGradeSynced_$eq(true);
                this.entityDao().saveOrUpdate((Object)review, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisReview[0]));
            });
        } else {
            float score = BoxesRunTime.unboxToFloat((Object)review.finalScore().get());
            Object[] gradeInfo = (Object[])rs.head();
            if (gradeInfo[1] == null || (float)((Number)gradeInfo[1]).intValue() != score) {
                int gradingModeId = GradingMode$.MODULE$.RankCn();
                float gp = BoxesRunTime.unboxToFloat((Object)this.gradeRateService().getConverter(std.project(), new GradingMode(gradingModeId)).calcGp((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)score))).get());
                this.jdbcExecutor.update("update edu.course_grades cg set score=?,score_text=?,gp=?,passed=?,updated_at=? where id = ?", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)score), (String)scoreText.elem, BoxesRunTime.boxToFloat((float)gp), BoxesRunTime.boxToBoolean((score >= (float)60 ? 1 : 0) != 0), Instant.now(), gradeInfo[0]}));
            }
            review.courseGradeSynced_$eq(true);
            this.entityDao().saveOrUpdate((Object)review, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisReview[0]));
        }
        return review.courseGradeSynced();
    }

    private long genCourseGradeId() {
        if (this.engine.name().toLowerCase().startsWith("oracle")) {
            return ((Number)((Object[])this.jdbcExecutor.query("select datetime_id() from dual", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).headOption().get())[0]).longValue();
        }
        return ((Number)((Object[])this.jdbcExecutor.query("select datetime_id()", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).headOption().get())[0]).longValue();
    }

    private Option<Tuple2<Object, Object>> getCourse(Student std) {
        Seq rs = this.jdbcExecutor.query(" select min(kc.id),min(kcz.course_type_id) from edu.audit_plan_results jh,edu.audit_group_results kcz,edu.audit_course_results jhkc,base.courses kc where jh.id=kcz.plan_result_id and kcz.id=jhkc.group_result_id and jhkc.course_id=kc.id and (kc.name like '\u6bd5\u4e1a\u8bba\u6587%' or kc.name like '%\u5b66\u4f4d\u8bba\u6587%') and jh.std_id=?", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.id()}));
        if (rs.isEmpty()) {
            return None$.MODULE$;
        }
        Object[] datas = (Object[])rs.head();
        if (datas[0] == null) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((Number)datas[0]).longValue()), (Object)BoxesRunTime.boxToInteger((int)((Number)datas[1]).intValue())));
    }

    private static final String init$$anonfun$1() {
        return "Using default datasource as openurp datasource";
    }
}

