/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Enums$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Deadline;
import org.openurp.degree.thesis.model.Proposal;
import org.openurp.degree.thesis.model.Signature;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DeferService;
import org.openurp.degree.thesis.service.doc.ThesisDocGenerator$;
import org.openurp.degree.thesis.service.doc.ThesisPdfGenerator$;
import org.openurp.degree.thesis.web.helper.ProposalPropertyExtractor;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ProposalAction
extends RestfulAction<Writer>
implements ProjectSupport,
ExportSupport<Writer> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private DeferService deferService;
    private WebBusinessLogger businessLogger;

    public ProposalAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public DeferService deferService() {
        return this.deferService;
    }

    public void deferService_$eq(DeferService x$1) {
        this.deferService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<Writer> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.std.state.department in(:departs) and writer.advisor is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        this.populateConditions(query);
        query.limit(this.getPageLimit());
        query.orderBy((String)this.get(Order$.MODULE$.OrderStr(), "writer.std.code"));
        this.get("status").foreach((Function1)(JProcedure1 & Serializable)s -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)s)) {
                AuditStatus status;
                AuditStatus auditStatus = status = (AuditStatus)Enums$.MODULE$.of(AuditStatus.class, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).get();
                AuditStatus auditStatus2 = AuditStatus$.Draft;
                if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
                    query.where(" not exists(from " + Proposal.class.getName() + " c where c.writer=writer and c.status in(:statusList))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)AuditStatus$.Rejected, (List)new .colon.colon((Object)AuditStatus$.Submited, (List)new .colon.colon((Object)AuditStatus$.Passed, (List)Nil$.MODULE$)))}));
                    return;
                }
                query.where("exists(from " + Proposal.class.getName() + " c where c.writer=writer and c.status=:status)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{status}));
                return;
            }
        });
        return query;
    }

    public View search() {
        Seq writers = this.entityDao().search(this.getQueryBuilder());
        this.put("writers", writers);
        Map proposals = ((IterableOnceOps)this.entityDao().findBy(Proposal.class, "writer", (Object)writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("proposals", proposals);
        this.put("stage", Stage$.Proposal);
        return this.forward(this.forward$default$1());
    }

    public View reject() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        Seq proposals = this.entityDao().findBy(Proposal.class, "writer", (Object)writers);
        proposals.foreach((Function1)(JProcedure1 & Serializable)p -> {
            p.status_$eq(AuditStatus$.RejectedByDepart);
            String msg = "\u9000\u56de" + p.writer().std().name() + "\u7684\u5f00\u9898\u62a5\u544a";
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.std.code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)p.writer().std().code());
            this.businessLogger().info(msg, p.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        });
        this.entityDao().saveOrUpdate((Iterable)proposals);
        return this.redirect("search", "\u9000\u56de\u6210\u529f");
    }

    public View defer() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        writers.foreach((Function1)(JProcedure1 & Serializable)writer -> {
            Deadline deadline = writer.getOrCreateDeadline(Stage$.Proposal);
            this.deferService().defer(deadline, Stage$.Proposal);
        });
        return this.redirect("search", "info.save.success");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Proposal proposal = (Proposal)this.entityDao().get(Proposal.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Writer writer = proposal.writer();
        this.put("proposal", proposal);
        this.put("writer", writer);
        return this.forward(this.forward$default$1());
    }

    public View doc() {
        Writer writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        Option option = this.entityDao().findBy(Proposal.class, "writer", (Object)writer).headOption();
        if (option instanceof Some) {
            Proposal p = (Proposal)((Some)option).value();
            return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genProposal(p, (Option<Signature>)None$.MODULE$), MediaTypes$.MODULE$.ApplicationDocx(), writer.std().code() + writer.std().name() + "\u5f00\u9898\u62a5\u544a.docx", Stream$.MODULE$.apply$default$4());
        }
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError((Object)option);
    }

    public View batchDoc() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        GraduateSeason season = ((Writer)writers.head()).season();
        Department depart = ((Writer)writers.head()).department();
        String dir = ThesisDocGenerator$.MODULE$.getDepartFolder(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        writers.foreach((Function1 & Serializable)writer -> {
            Option option = this.entityDao().findBy(Proposal.class, "writer", writer).headOption();
            if (option instanceof Some) {
                Proposal p = (Proposal)((Some)option).value();
                InputStream is = ThesisDocGenerator$.MODULE$.genProposal(p, (Option<Signature>)None$.MODULE$);
                FileOutputStream file = new FileOutputStream(new File(dir + Files$.MODULE$.$div() + (writer.std().code() + "\u5f00\u9898\u62a5\u544a.docx")));
                IOs$.MODULE$.copy(is, (OutputStream)file);
                IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{file}));
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                return Status$.MODULE$.NotFound();
            }
            throw new MatchError((Object)option);
        });
        File targetZip = ThesisDocGenerator$.MODULE$.getDepartZipFile(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        Zipper$.MODULE$.zip(new File(dir), targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = season.name() + "_" + depart.name() + " \u5f00\u9898\u62a5\u544aDocx.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public View batchPdf() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        GraduateSeason season = ((Writer)writers.head()).season();
        Department depart = ((Writer)writers.head()).department();
        String dir = ThesisPdfGenerator$.MODULE$.getDepartFolder(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        writers.foreach((Function1 & Serializable)writer -> {
            Option option = this.entityDao().findBy(Proposal.class, "writer", writer).headOption();
            if (option instanceof Some) {
                Proposal p = (Proposal)((Some)option).value();
                InputStream is = ThesisPdfGenerator$.MODULE$.genProposal(p);
                FileOutputStream file = new FileOutputStream(new File(dir + Files$.MODULE$.$div() + (writer.std().code() + "\u5f00\u9898\u62a5\u544a.pdf")));
                IOs$.MODULE$.copy(is, (OutputStream)file);
                IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{file}));
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                return Status$.MODULE$.NotFound();
            }
            throw new MatchError((Object)option);
        });
        File targetZip = ThesisPdfGenerator$.MODULE$.getDepartZipFile(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        Zipper$.MODULE$.zip(new File(dir), targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = season.name() + "_" + depart.name() + " \u5f00\u9898\u62a5\u544aPDF.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public void configExport(ExportContext context) {
        context.extractor_$eq((PropertyExtractor)new ProposalPropertyExtractor(this.entityDao()));
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

