/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Chars$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.commons.lang.Throwables$;
import org.beangle.commons.lang.text.Formatter;
import org.beangle.commons.lang.text.TemporalFormatter;
import org.beangle.commons.logging.Logger$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.doc.excel.schema.ExcelColumn;
import org.beangle.doc.excel.schema.ExcelScheet;
import org.beangle.doc.excel.schema.ExcelSchema;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.doc.transfer.exporter.Exporter;
import org.beangle.doc.transfer.importer.ImportSetting;
import org.beangle.doc.transfer.importer.listener.ForeignerListener;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.ImportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.person.model.Language;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Stage;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.ThesisCheck;
import org.openurp.degree.thesis.model.ThesisDoc;
import org.openurp.degree.thesis.model.ThesisDocType;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DeferService;
import org.openurp.degree.thesis.service.ThesisCheckService;
import org.openurp.degree.thesis.service.doc.ThesisPdfGenerator$;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import org.openurp.degree.thesis.web.helper.RemarkSimpleExporter;
import org.openurp.degree.thesis.web.helper.ThesisCheckFileNaming$;
import org.openurp.degree.thesis.web.helper.ThesisCheckImportListener;
import org.openurp.degree.thesis.web.helper.ThesisCheckPropertyExtractor;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class ThesisCheckAction
extends RestfulAction<ThesisCheck>
implements ProjectSupport,
ExportSupport<ThesisCheck>,
ImportSupport<ThesisCheck> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private DeferService deferService;
    private WebBusinessLogger businessLogger;
    private ThesisCheckService thesisCheckService;

    public ThesisCheckAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public DeferService deferService() {
        return this.deferService;
    }

    public void deferService_$eq(DeferService x$1) {
        this.deferService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public ThesisCheckService thesisCheckService() {
        return this.thesisCheckService;
    }

    public void thesisCheckService_$eq(ThesisCheckService x$1) {
        this.thesisCheckService = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<ThesisCheck> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        this.put("project", this.project$2(lazyRef));
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getBoolean("sameTitle").foreach((Function1 & Serializable)sameTitle -> ThesisCheckAction.getQueryBuilder$$anonfun$1(query, BoxesRunTime.unboxToBoolean((Object)sameTitle)));
        this.getBoolean("docOk").foreach((Function1 & Serializable)docOk -> ThesisCheckAction.getQueryBuilder$$anonfun$2(query, BoxesRunTime.unboxToBoolean((Object)docOk)));
        long seasonId = this.getLongId("thesisCheck.season");
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)seasonId));
        this.put("schoolYear", ThesisCheckFileNaming$.MODULE$.getShortSchoolYear(season));
        query.where("thesisCheck.writer.std.state.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        return query;
    }

    public View paper() {
        scala.collection.immutable.Seq checks = this.entityDao().find(ThesisCheck.class, (Iterable)this.getLongIds("thesisCheck"));
        scala.collection.immutable.Seq papers = (scala.collection.immutable.Seq)checks.flatMap((Function1 & Serializable)_$4 -> _$4.paperDoc());
        GraduateSeason season = ((ThesisCheck)checks.head()).season();
        File dir = new File(System.getProperty("java.io.tmpdir") + ("season" + season.id()) + Files$.MODULE$.$div() + "batch");
        if (dir.exists()) {
            Files$.MODULE$.travel(dir, (Function1)(JProcedure1 & Serializable)f -> f.delete());
        }
        dir.mkdirs();
        PaperDownloadHelper$.MODULE$.download(dir, (Iterable<ThesisCheck>)checks, (Function1<ThesisCheck, String>)(Function1 & Serializable)check -> ThesisCheckFileNaming$.MODULE$.paperFileName2((ThesisCheck)check));
        File targetZip = new File(System.getProperty("java.io.tmpdir") + ("season" + season.id()) + Files$.MODULE$.$div() + "batch.zip");
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = papers.size() == 1 ? season.name() + "_" + ((ThesisDoc)papers.head()).writer().code() + "\u7684\u8bba\u6587.zip" : season.name() + "_" + ((ThesisDoc)papers.head()).writer().code() + ("\u7b49" + papers.size() + "\u7bc7\u8bba\u6587.zip");
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> targetZip.delete());
    }

    public View proposalDoc() {
        ThesisCheck check = (ThesisCheck)this.entityDao().get(ThesisCheck.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisCheck")));
        Option option = check.proposalDoc();
        if (option instanceof Some) {
            ThesisDoc doc = (ThesisDoc)((Some)option).value();
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(doc.filePath());
            HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
            response2.sendRedirect(((URL)path.get()).toString());
            return null;
        }
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError((Object)option);
    }

    public View defenseDoc() {
        ThesisCheck check = (ThesisCheck)this.entityDao().get(ThesisCheck.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisCheck")));
        Option option = check.defenseDoc();
        if (option instanceof Some) {
            ThesisDoc doc = (ThesisDoc)((Some)option).value();
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(doc.filePath());
            HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
            response2.sendRedirect(((URL)path.get()).toString());
            return null;
        }
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError((Object)option);
    }

    public View stat() {
        LazyRef lazyRef = new LazyRef();
        long seasonId = BoxesRunTime.unboxToLong((Object)this.getLong("thesisCheck.season.id").get());
        OqlBuilder query1 = OqlBuilder$.MODULE$.from(ThesisCheck.class.getName(), "check");
        query1.where("check.season.id=:seasonId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query1.where("check.writer.std.state.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$3(lazyRef))}));
        query1.select("check.writer.std.state.department.id,check.writer.std.state.department.code,check.writer.std.state.department.name,count(*)");
        query1.groupBy("check.writer.std.state.department.id,check.writer.std.state.department.code,check.writer.std.state.department.name");
        query1.orderBy("check.writer.std.state.department.code");
        scala.collection.immutable.Seq papers = this.entityDao().search((QueryBuilder)query1);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(ThesisDoc.class.getName(), "doc");
        query2.where("exists(from " + ThesisCheck.class.getName() + " c where c.writer=doc.writer and c.season.id=:seasonId)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query2.where("doc.writer.std.state.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$3(lazyRef))}));
        query2.where("doc.stage=:stage", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Stage$.Proposal}));
        query2.select("doc.writer.std.state.department.id,count(*)");
        query2.groupBy("doc.writer.std.state.department.id");
        scala.collection.immutable.Map proposals = ((IterableOnceOps)this.entityDao().search((QueryBuilder)query2).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x[0], x[1]))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        OqlBuilder query3 = OqlBuilder$.MODULE$.from(ThesisDoc.class.getName(), "doc");
        query3.where("exists(from " + ThesisCheck.class.getName() + " c where c.writer=doc.writer and c.season.id=:seasonId)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query3.where("doc.writer.std.state.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$3(lazyRef))}));
        query3.where("doc.stage=:stage", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Stage$.OralDefense}));
        query3.select("doc.writer.std.state.department.id,count(*)");
        query3.groupBy("doc.writer.std.state.department.id");
        scala.collection.immutable.Map defenses = ((IterableOnceOps)this.entityDao().search((QueryBuilder)query3).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x[0], x[1]))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map zipTimes = Collections$.MODULE$.newMap();
        scala.collection.mutable.Map zipSizes = Collections$.MODULE$.newMap();
        papers.foreach((Function1)(JProcedure1 & Serializable)p -> {
            int departId = ((Number)p[0]).intValue();
            File f = ThesisPdfGenerator$.MODULE$.getDepartZipFile(seasonId, departId, "thesis_check");
            if (f.exists()) {
                zipTimes.put((Object)BoxesRunTime.boxToInteger((int)departId), (Object)new Date(f.lastModified()));
                zipSizes.put((Object)BoxesRunTime.boxToInteger((int)departId), (Object)BoxesRunTime.boxToLong((long)f.length()));
                return;
            }
        });
        this.put("papers", papers);
        this.put("proposals", proposals);
        this.put("defenses", defenses);
        this.put("zipTimes", zipTimes);
        this.put("zipSizes", zipSizes);
        this.put("seasonId", BoxesRunTime.boxToLong((long)seasonId));
        return this.forward(this.forward$default$1());
    }

    public View genZip() {
        long seasonId = this.getLongId("season");
        int departmentId = this.getIntId("department");
        OqlBuilder query1 = OqlBuilder$.MODULE$.from(ThesisCheck.class, "check");
        query1.where("check.season.id=:seasonIds", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query1.where("check.writer.std.state.department.id=:departId", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)departmentId)}));
        scala.collection.immutable.Seq checks = this.entityDao().search((QueryBuilder)query1);
        scala.collection.immutable.Map writer2Check = ((IterableOnceOps)checks.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String checkDir = ThesisPdfGenerator$.MODULE$.getDepartFolder(seasonId, departmentId, "thesis_check");
        PaperDownloadHelper$.MODULE$.download(new File(checkDir), (Iterable<ThesisCheck>)checks, (Function1<ThesisCheck, String>)(Function1 & Serializable)check -> ThesisCheckFileNaming$.MODULE$.paperFileName((ThesisCheck)check));
        Buffer docs = Collections$.MODULE$.newBuffer();
        checks.foreach((Function1 & Serializable)c -> {
            docs.addAll((IterableOnce)c.proposalDoc());
            return (Buffer)docs.addAll((IterableOnce)c.defenseDoc());
        });
        Seq<File> zipFiles = PaperDownloadHelper$.MODULE$.downloadDocs(new File(checkDir), (Map<Writer, Iterable<ThesisDoc>>)docs.groupBy((Function1 & Serializable)x -> x.writer()), (Option<Function1<Writer, String>>)Some$.MODULE$.apply((Function1 & Serializable)f -> ThesisCheckFileNaming$.MODULE$.attachFileName((ThesisCheck)writer2Check.apply(f))));
        File targetZip = ThesisPdfGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "thesis_check");
        Zipper$.MODULE$.zip(new File(checkDir), targetZip, Zipper$.MODULE$.zip$default$3());
        return this.redirect("stat", "thesisCheck.season.id=" + seasonId, "\u751f\u6210\u6210\u529f");
    }

    public View downloadFiles() {
        scala.collection.immutable.Seq checks = this.entityDao().find(ThesisCheck.class, (Iterable)this.getLongIds("thesisCheck"));
        scala.collection.immutable.Map writer2Check = ((IterableOnceOps)checks.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        long seasonId = BoxesRunTime.unboxToLong((Object)((ThesisCheck)checks.head()).season().id());
        int departmentId = BoxesRunTime.unboxToInt((Object)((ThesisCheck)checks.head()).writer().department().id());
        String checkDir = ThesisPdfGenerator$.MODULE$.getDepartFolder(seasonId, departmentId, "thesis_check_tmp");
        PaperDownloadHelper$.MODULE$.download(new File(checkDir), (Iterable<ThesisCheck>)checks, (Function1<ThesisCheck, String>)(Function1 & Serializable)check -> ThesisCheckFileNaming$.MODULE$.paperFileName((ThesisCheck)check));
        Buffer docs = Collections$.MODULE$.newBuffer();
        checks.foreach((Function1 & Serializable)c -> {
            docs.addAll((IterableOnce)c.proposalDoc());
            return (Buffer)docs.addAll((IterableOnce)c.defenseDoc());
        });
        Seq<File> zipFiles = PaperDownloadHelper$.MODULE$.downloadDocs(new File(checkDir), (Map<Writer, Iterable<ThesisDoc>>)docs.groupBy((Function1 & Serializable)x -> x.writer()), (Option<Function1<Writer, String>>)Some$.MODULE$.apply((Function1 & Serializable)f -> ThesisCheckFileNaming$.MODULE$.attachFileName((ThesisCheck)writer2Check.apply(f))));
        File targetZip = ThesisPdfGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "thesis_check_tmp");
        Zipper$.MODULE$.zip(new File(checkDir), targetZip, Zipper$.MODULE$.zip$default$3());
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), ((ThesisCheck)checks.head()).writer().code() + "\u7b49" + checks.size() + "\u4eba\u7684\u8bba\u6587\u6750\u6599.zip").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            targetZip.delete();
            Files$.MODULE$.travel(new File(checkDir), (Function1)(JProcedure1 & Serializable)f -> f.delete());
            new File(checkDir).delete();
        });
    }

    public View downloadDepartZip() {
        long seasonId = this.getLongId("season");
        int departmentId = this.getIntId("department");
        File file = ThesisPdfGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "thesis_check");
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)departmentId));
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)seasonId));
        String fileName = season.name() + "_" + depart.school().code() + "_" + depart.name() + "_\u8bba\u6587\u6750\u6599.zip";
        return Stream$.MODULE$.apply(file, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public View uploadDocForm() {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisCheck.season")));
        this.put("season", season);
        scala.collection.immutable.Seq docTypes = this.entityDao().findBy(ThesisDocType.class, "code", (Object)((SeqOps)new .colon.colon((Object)"thesisPaper", (List)new .colon.colon((Object)"oralDefense", (List)new .colon.colon((Object)"proposal", (List)Nil$.MODULE$)))));
        this.put("docTypes", docTypes);
        return this.forward(this.forward$default$1());
    }

    private Iterable<String> processZip(GraduateSeason season, File zipfile, ThesisDocType docType, String encoding) {
        RuntimeException runtimeException;
        Buffer messages = Collections$.MODULE$.newBuffer();
        Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
        ZipFile file = encoding == null ? new ZipFile(zipfile) : new ZipFile(zipfile, encoding);
        IntRef i = IntRef.create((int)0);
        try {
            Enumeration en = file.getEntries();
            CollectionConverters$.MODULE$.asScala(en).foreach((Function1)(JProcedure1 & Serializable)ze -> {
                ++i$1.elem;
                if (!ze.isDirectory()) {
                    String fileName;
                    String string = fileName = ze.getName().contains("/") ? Strings$.MODULE$.substringAfterLast(ze.getName(), "/") : ze.getName();
                    if (fileName.indexOf(".") < 1) {
                        Logger$.MODULE$.warn$extension(this.logger(), () -> ThesisCheckAction.processZip$$anonfun$1$$anonfun$1(fileName));
                        return;
                    }
                    String usernameCode = Strings$.MODULE$.substringBefore(fileName, ".").trim();
                    char[] usercode = usernameCode.toCharArray();
                    for (int j = 0; j < usercode.length; ++j) {
                        if (Chars$.MODULE$.isAsciiAlpha(usercode[j]) || Chars$.MODULE$.isNumber(usercode[j])) continue;
                        usercode[j] = 32;
                    }
                    Object object = Predef$.MODULE$.charArrayOps(usercode);
                    String stdCode = new String((char[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$5 -> ThesisCheckAction.$anonfun$10(BoxesRunTime.unboxToChar((Object)_$5))));
                    if (Strings$.MODULE$.isBlank((CharSequence)stdCode)) {
                        stdCode = usernameCode;
                    }
                    OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisCheck.class, "c");
                    query.where("(lower(c.writer.std.code)=:code or c.writerName=:name) and c.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{stdCode.toLowerCase(), stdCode.toLowerCase(), season}));
                    scala.collection.immutable.Seq checks = this.entityDao().search((QueryBuilder)query);
                    if (checks.size() != 1) {
                        messages.addOne((Object)("\u4ece" + usernameCode + "\u627e\u4e0d\u5230\u552f\u4e00\u7684\u5b66\u751f"));
                        return;
                    }
                    Writer writer = ((ThesisCheck)checks.head()).writer();
                    String storeName = writer.std().code() + "." + Strings$.MODULE$.substringAfterLast(fileName, ".");
                    Object[] objectArray = new Tuple2[2];
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)writer);
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"docType");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)docType);
                    ThesisDoc dd = (ThesisDoc)this.entityDao().findBy(ThesisDoc.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption().getOrElse(ThesisCheckAction::$anonfun$11);
                    dd.writer_$eq(writer);
                    dd.stage_$eq(docType.stage());
                    dd.docType_$eq(docType);
                    if (dd.filePath() != null && dd.filePath().startsWith("/")) {
                        blob.remove(dd.filePath());
                    }
                    BlobMeta meta = blob.upload("/" + writer.season().id().toString() + ("/archive/" + docType.code() + "/"), file.getInputStream(ze), storeName, writer.std().code() + " " + writer.std().name());
                    dd.fileExt_$eq(meta.mediaType());
                    dd.filePath_$eq(meta.filePath());
                    dd.updatedAt_$eq(Instant.now());
                    this.entityDao().saveOrUpdate((Object)dd, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisDoc[0]));
                    checks.foreach((Function1)(JProcedure1 & Serializable)c -> {
                        Stage stage = docType.stage();
                        Stage stage2 = Stage$.OralDefense;
                        if (!(stage != null ? !stage.equals(stage2) : stage2 != null)) {
                            c.defenseDoc_$eq((Option)Some$.MODULE$.apply((Object)dd));
                        } else {
                            Stage stage3 = docType.stage();
                            Stage stage4 = Stage$.Proposal;
                            if (!(stage3 != null ? !stage3.equals(stage4) : stage4 != null)) {
                                c.proposalDoc_$eq((Option)Some$.MODULE$.apply((Object)dd));
                            } else {
                                Stage stage5 = docType.stage();
                                Stage stage6 = Stage$.ThesisFinalSubmit;
                                if (!(stage5 != null ? !stage5.equals(stage6) : stage6 != null)) {
                                    c.paperDoc_$eq((Option)Some$.MODULE$.apply((Object)dd));
                                }
                            }
                        }
                        this.entityDao().saveOrUpdate(c, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisCheck[0]));
                    });
                    return;
                }
            });
            file.close();
            runtimeException = BoxedUnit.UNIT;
        }
        catch (IOException e) {
            runtimeException = Throwables$.MODULE$.propagate((Throwable)e);
        }
        return messages;
    }

    public View uploadDoc() {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisCheck.season")));
        ThesisDocType docType = (ThesisDocType)this.entityDao().get(ThesisDocType.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("docType")));
        Buffer messages = Collections$.MODULE$.newBuffer();
        Iterable parts = this.getAll("file", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            File tmpFile = new File(SystemInfo$.MODULE$.tmpDir() + "/doc" + System.currentTimeMillis());
            IOs$.MODULE$.copy(((Part)parts.head()).getInputStream(), (OutputStream)new FileOutputStream(tmpFile));
            messages.addAll(this.processZip(season, tmpFile, docType, "GBK"));
        }
        if (messages.nonEmpty()) {
            this.put("messages", messages);
            this.put("season", season);
            return this.forward(this.forward$default$1());
        }
        return this.redirect("search", "&thesisCheck.season.id=" + season.id(), "\u4e0a\u4f20\u6210\u529f");
    }

    public void editSetting(ThesisCheck check) {
        this.put("languages", this.codeService().get(Language.class));
        super.editSetting((Entity)check);
    }

    public View saveAndRedirect(ThesisCheck check) {
        this.entityDao().saveOrUpdate((Object)check, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisCheck[0]));
        Option paper = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)check.writer()).headOption();
        paper.foreach((Function1)(JProcedure1 & Serializable)pd -> {
            String string = check.title();
            String string2 = "--";
            if (string == null ? string2 != null : !string.equals(string2)) {
                check.writer().thesisTitle_$eq((Option)Some$.MODULE$.apply((Object)check.title()));
                check.writer().researchField_$eq(check.researchField());
                pd.title_$eq(check.title());
            }
            if (check.language().nonEmpty()) {
                pd.language_$eq(check.language());
            }
            if (check.keywords().nonEmpty()) {
                pd.keywords_$eq(check.keywords());
            }
            if (check.researchField().nonEmpty()) {
                pd.researchField_$eq(check.researchField());
            }
            this.entityDao().saveOrUpdate(pd, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPaper[0]));
        });
        ThesisDocType thesisPaperType = (ThesisDocType)this.entityDao().findBy(ThesisDocType.class, "code", (Object)"thesisPaper").head();
        ThesisDocType proposalType = (ThesisDocType)this.entityDao().findBy(ThesisDocType.class, "code", (Object)"proposal").head();
        ThesisDocType defenseType = (ThesisDocType)this.entityDao().findBy(ThesisDocType.class, "code", (Object)"oralDefense").head();
        this.entityDao().findBy(ThesisDocType.class, "code", (Object)"cover").foreach((Function1)(JProcedure1 & Serializable)coverType -> this.uploadSingleDoc(check, "cover_file", (ThesisDocType)coverType));
        this.uploadSingleDoc(check, "paper_file", thesisPaperType);
        this.uploadSingleDoc(check, "proposal_file", proposalType);
        this.uploadSingleDoc(check, "defense_file", defenseType);
        return this.redirect("search", "info.save.success");
    }

    private void uploadSingleDoc(ThesisCheck check, String partName, ThesisDocType docType) {
        Iterable parts = this.getAll(partName, Part.class, ClassTag$.MODULE$.apply(Part.class));
        Writer writer = check.writer();
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            String storeName = writer.std().code() + "." + Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"docType");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)docType);
            ThesisDoc dd = (ThesisDoc)this.entityDao().findBy(ThesisDoc.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption().getOrElse(ThesisCheckAction::$anonfun$12);
            dd.writer_$eq(writer);
            dd.stage_$eq(docType.stage());
            if (dd.filePath() != null && dd.filePath().startsWith("/")) {
                blob.remove(dd.filePath());
            }
            BlobMeta meta = blob.upload("/" + writer.season().id().toString() + ("/archive/" + docType.code() + "/"), part.getInputStream(), storeName, writer.std().code() + " " + writer.std().name());
            dd.fileExt_$eq(meta.mediaType());
            dd.filePath_$eq(meta.filePath());
            dd.docType_$eq(docType);
            dd.updatedAt_$eq(Instant.now());
            this.entityDao().saveOrUpdate((Object)dd, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisDoc[0]));
            Stage stage = docType.stage();
            Stage stage2 = Stage$.OralDefense;
            if (!(stage != null ? !stage.equals(stage2) : stage2 != null)) {
                check.defenseDoc_$eq((Option)Some$.MODULE$.apply((Object)dd));
            } else {
                Stage stage3 = docType.stage();
                Stage stage4 = Stage$.Proposal;
                if (!(stage3 != null ? !stage3.equals(stage4) : stage4 != null)) {
                    check.proposalDoc_$eq((Option)Some$.MODULE$.apply((Object)dd));
                } else {
                    Stage stage5 = docType.stage();
                    Stage stage6 = Stage$.ThesisFinalSubmit;
                    if (!(stage5 != null ? !stage5.equals(stage6) : stage6 != null)) {
                        check.paperDoc_$eq((Option)Some$.MODULE$.apply((Object)dd));
                    }
                }
            }
            this.entityDao().saveOrUpdate((Object)check, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisCheck[0]));
            String msg = "\u4e0a\u4f20\u4e86" + writer.code() + "\u7684\u8bba\u6587\u6750\u6599:" + docType.name();
            Object[] objectArray2 = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)dd.filePath());
            this.businessLogger().info(msg, writer.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
            return;
        }
    }

    @response
    public Object downloadTemplate() {
        boolean writerOnly = this.getBoolean("writerOnly", false);
        if (writerOnly) {
            ExcelSchema schema = new ExcelSchema();
            ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
            sheet.add("\u5b66\u4f4d\u6388\u4e88\u5355\u4f4d\u4ee3\u7801", "dummy1");
            sheet.add("\u5b66\u4f4d\u6388\u4e88\u5355\u4f4d\u540d\u79f0", "dummy2");
            ExcelColumn excelColumn = sheet.add("\u59d3\u540d", "thesisCheck.writerName");
            excelColumn.required(excelColumn.required$default$1());
            sheet.add("\u57f9\u517b\u5355\u4f4d\u7801", "dummy3");
            ExcelColumn excelColumn2 = sheet.add("\u5b66\u58eb\u5b66\u4f4d\u4e13\u4e1a\u4ee3\u7801", "thesisCheck.degreeMajorCode");
            excelColumn2.required(excelColumn2.required$default$1());
            ExcelColumn excelColumn3 = sheet.add("\u5b66\u58eb\u5b66\u4f4d\u4e13\u4e1a\u540d\u79f0", "thesisCheck.degreeMajorName");
            excelColumn3.required(excelColumn3.required$default$1());
            ExcelColumn excelColumn4 = sheet.add("\u8bc1\u4e66\u4e13\u4e1a\u540d\u79f0", "thesisCheck.certMajorName");
            excelColumn4.required(excelColumn4.required$default$1());
            ExcelColumn excelColumn5 = sheet.add("\u5165\u5b66\u5e74\u6708", "thesisCheck.enrollIn");
            excelColumn5.required(excelColumn5.required$default$1());
            ExcelColumn excelColumn6 = sheet.add("\u5b66\u53f7", "writer.std.code");
            excelColumn6.required(excelColumn6.required$default$1());
            ExcelColumn excelColumn7 = sheet.add("\u8003\u751f\u53f7", "thesisCheck.examineeCode");
            excelColumn7.required(excelColumn7.required$default$1());
            ExcelColumn excelColumn8 = sheet.add("\u6bd5\u4e1a\u5e74\u6708", "thesisCheck.graduateIn");
            excelColumn8.required(excelColumn8.required$default$1());
            sheet.add("\u662f\u5426\u4e3b\u8f85\u4fee\u5b66\u4f4d", "thesisCheck.majorMinorDegree");
            sheet.add("\u662f\u5426\u53cc\u5b66\u58eb\u5b66\u4f4d", "thesisCheck.dualDegree");
            sheet.add("\u662f\u5426\u8054\u5408\u5b66\u4f4d", "thesisCheck.jointDegree");
            sheet.add("\u8054\u5408\u57f9\u517b\u5355\u4f4d\u540d\u79f0", "thesisCheck.jointOrgCode");
            sheet.add("\u662f\u5426\u7b2c\u4e8c\u5b66\u4f4d", "thesisCheck.secondDegree");
            sheet.add("\u662f\u5426\u8f85\u4fee\u5b66\u4f4d", "thesisCheck.minorDegree");
            sheet.add("\u5b66\u4f4d\u7c7b\u578b", "thesisCheck.eduType");
            sheet.add("\u8bba\u6587\u7c7b\u578b", "dummy4");
            sheet.add("\u5bfc\u5e08\u59d3\u540d", "dummy5");
            sheet.add("\u8bba\u6587\u9898\u76ee", "dummy6");
            sheet.add("\u8bba\u6587\u5173\u952e\u8bcd", "dummy7");
            sheet.add("\u8bba\u6587\u7814\u7a76\u65b9\u5411", "dummy8");
            sheet.add("\u8bba\u6587\u64b0\u5199\u8bed\u79cd", "dummy9");
            sheet.add("\u8bba\u6587\u539f\u6587\u6216\u8bf4\u660e\u6587\u4ef6\u540d\u79f0", "dummy10");
            sheet.add("\u652f\u6491\u6750\u6599\u6587\u4ef6\u540d\u79f0", "dummy11");
            sheet.add("\u67e5\u91cd\u62a5\u544a\u6587\u4ef6\u540d\u79f0", "dummy12");
            sheet.add("\u662f\u5426\u672c\u4e13\u4e1a\u7b2c\u4e00\u5c4a\u6bd5\u4e1a\u751f", "dummy13");
            sheet.add("\u6bd5\u4e1a\u751f\u6240\u5728\u9662\u7cfb\u4ee3\u7801", "thesisCheck.departNo");
            sheet.add("\u6bd5\u4e1a\u751f\u6240\u5728\u9662\u7cfb\u540d\u79f0", "thesisCheck.departName");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            schema.generate((OutputStream)os);
            return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u62bd\u68c0\u540d\u5355\u6a21\u677f.xlsx", Stream$.MODULE$.apply$default$4());
        }
        Seq languages = (Seq)this.codeService().get(Language.class).map((Function1 & Serializable)x -> x.name());
        ExcelSchema schema = new ExcelSchema();
        List thesisTypes = (List)new .colon.colon((Object)"\u6bd5\u4e1a\u8bba\u6587", (List)new .colon.colon((Object)"\u6bd5\u4e1a\u8bbe\u8ba1", (List)new .colon.colon((Object)"\u6d89\u5bc6\u8bba\u6587", (List)new .colon.colon((Object)"\u65e0", (List)Nil$.MODULE$))));
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u8bba\u6587\u4fe1\u606f\u6a21\u677f");
        ExcelColumn excelColumn = sheet.add("\u5b66\u53f7", "writer.std.code").length(15);
        excelColumn.required(excelColumn.required$default$1()).remark("\u226415\u4f4d");
        ExcelColumn excelColumn9 = sheet.add("\u5b66\u58eb\u5b66\u4f4d\u4e13\u4e1a\u4ee3\u7801", "thesisCheck.degreeMajorCode");
        excelColumn9.required(excelColumn9.required$default$1());
        ExcelColumn excelColumn10 = sheet.add("\u8bba\u6587\u7c7b\u578b", "thesisCheck.thesisType").ref((Seq)thesisTypes);
        excelColumn10.required(excelColumn10.required$default$1());
        ExcelColumn excelColumn11 = sheet.add("\u5bfc\u5e08\u59d3\u540d", "thesisCheck.advisor");
        excelColumn11.required(excelColumn11.required$default$1());
        ExcelColumn excelColumn12 = sheet.add("\u8bba\u6587\u9898\u76ee", "thesisCheck.title").length(200);
        excelColumn12.required(excelColumn12.required$default$1());
        ExcelColumn excelColumn13 = sheet.add("\u8bba\u6587\u5173\u952e\u8bcd", "thesisCheck.keywords");
        excelColumn13.required(excelColumn13.required$default$1()).remark("\u91c7\u7528\u5168\u89d2\u5206\u53f7\uff1b\u8fdb\u884c\u5206\u9694");
        ExcelColumn excelColumn14 = sheet.add("\u8bba\u6587\u7814\u7a76\u65b9\u5411", "thesisCheck.researchField");
        excelColumn14.required(excelColumn14.required$default$1());
        ExcelColumn excelColumn15 = sheet.add("\u8bba\u6587\u64b0\u5199\u8bed\u79cd", "thesisCheck.language.name").ref(languages);
        excelColumn15.required(excelColumn15.required$default$1());
        ExcelColumn excelColumn16 = sheet.add("\u662f\u5426\u672c\u4e13\u4e1a\u7b2c\u4e00\u5c4a\u6bd5\u4e1a\u751f", "thesisCheck.firstSeason");
        excelColumn16.required(excelColumn16.required$default$1()).remark("\u662f/\u5426");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u8bba\u6587\u4fe1\u606f\u6a21\u677f.xlsx", Stream$.MODULE$.apply$default$4());
    }

    public View importWriters() {
        return this.forward(this.forward$default$1());
    }

    public void configImport(ImportSetting setting) {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisCheck.season")));
        ForeignerListener fl = new ForeignerListener(this.entityDao());
        fl.addForeigerKey("name");
        setting.listeners_$eq((List)new .colon.colon((Object)fl, (List)new .colon.colon((Object)new ThesisCheckImportListener(season, this.entityDao(), this.thesisCheckService()), (List)Nil$.MODULE$)));
    }

    public void configExport(ExportContext context) {
        context.registerFormatter(LocalDate.class, (Formatter)new TemporalFormatter("yyyyMMdd"));
        Object object = Predef$.MODULE$.refArrayOps((Object[])context.attrs());
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (context.titles()[i].contains("\u5e74\u6708")) {
                context.registerFormatter(context.attrs()[i], (Formatter)new TemporalFormatter("yyyyMM"));
                return;
            }
        });
        context.extractor_$eq((PropertyExtractor)new ThesisCheckPropertyExtractor(this.entityDao()));
        context.exporter_$eq((Exporter)new RemarkSimpleExporter((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\u586b\u5199\u8bf4\u660e\uff1a\n1.A-X\u5217\u5185\u5bb9\u4e3a\u539f\u59cb\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\uff0c\u8bf7\u5728\u672c\u79d1\u62bd\u68c0\u5e73\u53f0\u3010\u8bba\u6587\u4e0a\u62a5\u3011-\u3010\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u8be6\u60c5\u3011\u9875\u9762\u4e0b\u8f7d\uff0c\u539f\u59cb\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5426\u5219\u65e0\u6cd5\u5b8c\u6210\u4e0a\u4f20\uff1b\u82e5S-X\u5217\u4fe1\u606f\u5168\u90e8\u4e3a\u7a7a\uff0c\u8868\u660e\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\u4fe1\u606f\uff0c\u987b\u6309\u7167\u7b2c\u4e8c\u884c\u586b\u5199\u8bf4\u660e\u8865\u5145\u5b8c\u6574\uff1b\n2.S-AD\u5217\u4e3a\u5f85\u8865\u5145\u5b57\u6bb5\uff0c\u8bf7\u6309\u7167\u7b2c\u4e8c\u884c\u586b\u5199\u8bf4\u660e\u8fdb\u884c\u586b\u5199\uff1b\n3.\u5982\u8868\u4e2d\u542b\u6837\u4f8b\u6570\u636e\uff0c\u4e0a\u4f20\u524d\u987b\u5220\u9664\u6837\u4f8b\u6570\u636e\u884c\u3002", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", "\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("1.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u540e\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b\n          |2.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5fc5\u586b\u9879\uff1a\u4e0b\u62c9\u9009\u62e9\u8bba\u6587\u7c7b\u578b\uff0c\u6216\u53c2\u7167\u8868\u4e2d\u9644\u4ef62\u8bba\u6587\u7c7b\u578b\u5b57\u5178\u586b\u5199\u3002\"\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("1.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u540e\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b\n          |2.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5fc5\u586b\u9879\uff08\u82e5S\u5217\u8bba\u6587\u7c7b\u578b\u4e3a\u201c\u6d89\u5bc6\u8bba\u6587\u201d\u6216\u201c\u65e0\u201d\uff0c\u4e0d\u586b\uff09\uff1a\u6309\u5b9e\u9645\u60c5\u51b5\u586b\u5199\uff0c\u82e5\u6709\u591a\u4f4d\u6307\u5bfc\u8001\u5e08\uff0c\u4ee5\u4e2d\u82f1\u6587\u5206\u53f7\u201c\uff1b\u201d\u5206\u9694\u3002\"\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("1.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u540e\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b\n          |2.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5fc5\u586b\u9879\uff1b\u82e5S\u5217\u8bba\u6587\u7c7b\u578b\u4e3a\u201c\u6d89\u5bc6\u8bba\u6587\u201d\u6216\u201c\u65e0\u201d\uff0c\u4e0d\u586b\u3002\"\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("1.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u540e\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b\n          |2.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5fc5\u586b\u9879\uff08\u82e5S\u5217\u8bba\u6587\u7c7b\u578b\u4e3a\u201c\u6d89\u5bc6\u8bba\u6587\u201d\u6216\u201c\u65e0\u201d\uff0c\u4e0d\u586b\uff09\uff1a\u9650100\u4e2a\u6c49\u5b57\u4ee5\u5185\uff0c\u4ee5\u4e2d\u82f1\u6587\u5206\u53f7\u201c\uff1b\u201d\u5206\u9694\u3002\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("1.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u540e\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b\n          |2.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5fc5\u586b\u9879\uff08\u82e5S\u5217\u8bba\u6587\u7c7b\u578b\u4e3a\u201c\u6d89\u5bc6\u8bba\u6587\u201d\u6216\u201c\u65e0\u201d\uff0c\u4e0d\u586b\uff09\uff1a\n          |\u2460\u987b\u4e3a\u4e2d\u6587\uff1b\n          |\u2461\u6bcf\u4e2a\u7814\u7a76\u65b9\u5411\u965015\u4e2a\u6c49\u5b57\u4ee5\u5185\uff0c\u9650\u586b\u4e24\u4e2a\u7814\u7a76\u65b9\u5411\uff0c\u4ee5\u4e2d\u82f1\u6587\u5206\u53f7\u201c\uff1b\u201d\u5206\u9694\uff1b\n          |\u2462\u8bba\u6587\u7814\u7a76\u65b9\u5411\u4e0d\u80fd\u4e0e\u4e13\u4e1a\u540d\u79f0\u76f8\u540c\u3002")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("1.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u540e\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5b66\u4f4d\u6388\u4e88\u4fe1\u606f\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u52ff\u4fee\u6539\uff1b\n          |2.\u82e5\u4e3a2024\u5e746\u67081\u65e5\u4e4b\u524d\u6388\u4e88\u7684\u5b66\u4f4d\uff0c\u8be5\u5217\u4e3a\u5fc5\u586b\u9879\uff08\u82e5S\u5217\u8bba\u6587\u7c7b\u578b\u4e3a\u201c\u6d89\u5bc6\u8bba\u6587\u201d\u6216\u201c\u65e0\u201d\uff0c\u4e0d\u586b\uff09\uff1a\u4e0b\u62c9\u9009\u62e9\u8bed\u79cd\uff0c\u6216\u53c2\u7167\u8868\u4e2d\u9644\u4ef63\u64b0\u5199\u8bed\u79cd\u5b57\u5178\u586b\u5199\u3002\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\u5fc5\u586b\uff1b\n          |\u2460\u672c\u5217\u6700\u591a\u53ef\u586b\u5199\u4e00\u4e2a\u6587\u4ef6\u540d\uff0c\u4ec5\u652f\u6301.PDF\u540e\u7f00\u6587\u4ef6\u540d\uff08\u540e\u7f00\u540d\u4e0d\u533a\u5206\u82f1\u6587\u5927\u5c0f\u5199\uff09\uff1b\n          |\u2461\u82e5S\u5217\u4e3a\u3010\u6bd5\u4e1a\u8bba\u6587\u3011\uff0c\u5219\u672c\u5217\u586b\u5199\u6bd5\u4e1a\u8bba\u6587\u6587\u4ef6\u540d\u79f0\u3002\u5efa\u8bae\u547d\u540d\u683c\u5f0f\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_LW.PDF\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u5317\u4eac\u5927\u5b66\uff0810001\uff09\u56fd\u9645\u7ecf\u6d4e\u4e0e\u8d38\u6613\uff08020401\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u8bba\u6587\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_10001_020401_20610709150378_LW.PDF\n          |\u2462\u82e5S\u5217\u4e3a\u3010\u6bd5\u4e1a\u8bbe\u8ba1\u3011\uff0c\u5219\u672c\u5217\u586b\u5199\u6bd5\u4e1a\u8bbe\u8ba1\u6587\u4ef6\u540d\u79f0\u6216\u6bd5\u4e1a\u8bbe\u8ba1\u8bf4\u660e\u6587\u4ef6\u540d\u79f0\u3002\u5efa\u8bae\u547d\u540d\u683c\u5f0f\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_BS.PDF\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u4e2d\u56fd\u4eba\u6c11\u5927\u5b66\uff0810002\uff09\u7f8e\u672f\u5b66\uff08130401\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u6bd5\u4e1a\u8bbe\u8ba1\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_10002_130401_20610709150378_BS.PDF\n          |\u2463\u82e5S\u5217\u4e3a\u3010\u6d89\u5bc6\u8bba\u6587\u3011\uff0c\u5219\u672c\u5217\u987b\u586b\u5199\u76f8\u5173\u5b9a\u5bc6\u6750\u6599\u6587\u4ef6\u540d\u79f0\u3002\u5efa\u8bae\u547d\u540d\u683c\u5f0f\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_SM.PDF\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u5317\u4eac\u7406\u5de5\u5927\u5b66\uff0810007\uff09\u6d4b\u63a7\u6280\u672f\u4e0e\u4eea\u5668\uff08080301\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u5b9a\u5bc6\u8bc1\u660e\u6750\u6599\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_10007_080301_20610709150378_SM.PDF\n          |\u2464\u82e5S\u5217\u4e3a\u3010\u5176\u4ed6\u3011\uff0c\u5219\u672c\u5217\u586b\u5199\u6587\u672c\u7c7b\u6587\u4ef6\u540d\u79f0\u6216\u975e\u6587\u672c\u7c7b\u8bf4\u660e\u6587\u4ef6\u540d\u79f0\u3002\u5efa\u8bae\u547d\u540d\u683c\u5f0f\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_QT.PDF\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u4e2d\u56fd\u4f20\u5a92\u5927\u5b66\uff0810033\uff09\u8868\u6f14\uff08130301\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u6587\u672c\u7c7b\u6587\u4ef6\u540d\u79f0\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_10033_130301_20610709150378_QT.PDF\n          |\u2465\u82e5S\u5217\u4e3a\u3010\u65e0\u3011\uff0c\u5219\u672c\u5217\u586b\u5199\u300a\u666e\u901a\u9ad8\u7b49\u5b66\u6821\u672c\u79d1\u4e13\u4e1a\u7c7b\u6559\u5b66\u8d28\u91cf\u56fd\u5bb6\u6807\u51c6\u300b\u4e0d\u8981\u6c42\u505a\u6bd5\u4e1a\u8bba\u6587\uff08\u8bbe\u8ba1\uff09\u7684\u89c4\u5b9a\u6216\u57f9\u517b\u65b9\u6848\u3001\u6210\u7ee9\u5355\u7b49\u8bc1\u660e\u6750\u6599\u6587\u4ef6\u540d\u79f0\u3002\uff08\u300a\u6807\u51c6\u300b\u4e2d\u6709\u6bd5\u4e1a\u8bba\u6587\uff08\u8bbe\u8ba1\uff09\u8981\u6c42\u7684\uff0c\u987b\u4e0a\u4f20\u672c\u6821\u8be5\u4e13\u4e1a\u7684\u57f9\u517b\u65b9\u6848\u3002\uff09\n          |\u5efa\u8bae\u547d\u540d\u683c\u5f0f\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_W.PDF\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u9996\u90fd\u533b\u79d1\u5927\u5b66\uff0810025\uff09\u4e34\u5e8a\u533b\u5b66\uff08100201K\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u65e0\u6bd5\u4e1a\u8bba\u6587\uff08\u8bbe\u8ba1\uff09\u8bc1\u660e\u6750\u6599\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_10025_100201K_20610709150378_W.PDF\u3002\n          |\u65e0\u8bba\u6587\u5982\u9700\u4e0a\u4f20\u540c\u4e00\u4efd\u8bc1\u660e\u6750\u6599\uff0c\u987b\u586b\u5199\u76f8\u540c\u7684\u6587\u4ef6\u540d\u79f0\u3002")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\u9009\u586b\uff08\u82e5\u4e3a\u975e\u6587\u672c\u7c7b\u6bd5\u4e1a\u8bbe\u8ba1\u6216\u975e\u6587\u672c\u7c7b\u201c\u5176\u4ed6\u201d\uff0c\u5219\u8be5\u5217\u4e3a\u5fc5\u586b\uff09\uff1b\n          |\u672c\u5217\u6700\u591a\u53ef\u586b\u5199\u4e00\u4e2a\u6587\u4ef6\u540d\uff0c\u586b\u5199\u5185\u5bb9\u4e3a\u652f\u6491\u6750\u6599\u538b\u7f29\u5305\u6587\u4ef6\u540d\u79f0\uff0c\u4ec5\u652f\u6301.ZIP\u540e\u7f00\u6587\u4ef6\u540d\uff08\u540e\u7f00\u540d\u4e0d\u533a\u5206\u82f1\u6587\u5927\u5c0f\u5199\uff09\uff1b\u538b\u7f29\u5305\u6587\u4ef6\u5927\u5c0f\u4e0d\u8d85\u8fc72GB\u3002\n          |\u5efa\u8bae\u538b\u7f29\u5305\u6587\u4ef6\u547d\u540d\u89c4\u5219\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_CL.ZIP\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u5317\u4eac\u822a\u7a7a\u822a\u5929\u5927\u5b66\uff0810006\uff09\u8f6f\u4ef6\u5de5\u7a0b\uff08080902\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u652f\u6491\u6750\u6599\u6587\u4ef6\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_10006_080902_20610709150378_CL.ZIP")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\u9009\u586b\uff08\u82e5\u6240\u5728\u7701\u7ea7\u6559\u80b2\u884c\u653f\u90e8\u95e8\u8bbe\u7f6e\u4e86\u4e0a\u4f20\u67e5\u91cd\u62a5\u544a\u7684\u8981\u6c42\uff0c\u5219\u8be5\u5217\u4e3a\u5fc5\u586b\uff09\uff1b\n          |\u672c\u5217\u6700\u591a\u53ef\u586b\u5199\u4e00\u4e2a\u6587\u4ef6\u540d\uff0c\u586b\u5199\u5185\u5bb9\u4e3a\u67e5\u91cd\u62a5\u544a\u6587\u4ef6\u540d\u79f0\uff0c\u4ec5\u652f\u6301.PDF\u540e\u7f00\u6587\u4ef6\u540d\uff08\u540e\u7f00\u540d\u4e0d\u533a\u5206\u82f1\u6587\u5927\u5c0f\u5199\uff09\u3002\n          |\u5efa\u8bae\u67e5\u91cd\u62a5\u544a\u6587\u4ef6\u547d\u540d\u89c4\u5219\uff1a\u5b66\u5e74\u5ea6_\u7701\u5e02\u4ee3\u7801_\u5355\u4f4d\u4ee3\u7801_\u4e13\u4e1a\u4ee3\u7801_\u8003\u751f\u53f7_CCBG.PDF\u3002\u4f8b\u59822324\u5b66\u5e74\u5ea6\u5317\u4eac\u5e02\uff0811\uff09\u4e2d\u56fd\u77ff\u4e1a\u5927\u5b66\uff08\u5317\u4eac\uff09\uff0811413\uff09\u6cd5\u5b66\uff08030101K\uff09\u4e13\u4e1a\uff0c\u8003\u751f\u53f7\u4e3a20610709150378\u5b66\u751f\u7684\u67e5\u91cd\u62a5\u544a\u6587\u4ef6\u5efa\u8bae\u547d\u540d\u4e3a\uff1a2324_11_11413_030101K_20610709150378_CCBG.PDF")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\u5fc5\u586b\uff1b\n          |\u586b\u5199\u201c\u662f\u201d\u6216\u201c\u5426\u201d\u3002\"\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\u5fc5\u586b\uff1b\n          |\u965020\u5b57\u7b26\u4ee5\u5185\uff1b\n          |\u82e5\u6821\u7ea7\u7528\u6237\u5df2\u5f00\u901a\u9662\u7cfb\u7528\u6237\u4e0a\u62a5\uff0c\u5219\u8be5\u5217\u5185\u5bb9\u987b\u4e0e\u6821\u7ea7\u7528\u6237\u3010\u9662\u7cfb\u7528\u6237\u7ba1\u7406\u3011\u9875\u9762\u201c\u9662\u7cfb\u4ee3\u7801\u201d\u4fdd\u6301\u4e00\u81f4\u3002\"\n          |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\u5fc5\u586b\uff1b\n          |\u965020\u5b57\u7b26\u4ee5\u5185\uff1b\n          |\u82e5\u6821\u7ea7\u7528\u6237\u5df2\u5f00\u901a\u9662\u7cfb\u7528\u6237\u4e0a\u62a5\uff0c\u5219\u8be5\u5217\u5185\u5bb9\u987b\u4e0e\u6821\u7ea7\u7528\u6237\u3010\u9662\u7cfb\u7528\u6237\u7ba1\u7406\u3011\u9875\u9762\u201c\u9662\u7cfb\u540d\u79f0\u201d\u4fdd\u6301\u4e00\u81f4\u3002\"\n          |"))})))));
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
    }

    public View updateDoc() {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisCheck.season")));
        scala.collection.immutable.Seq checks = this.entityDao().findBy(ThesisCheck.class, "season", (Object)season);
        checks.foreach((Function1)(JProcedure1 & Serializable)c -> this.thesisCheckService().updateDoc((ThesisCheck)c));
        return this.redirect("search", "\u64cd\u4f5c\u6210\u529f");
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder query$1, boolean sameTitle) {
        if (sameTitle) {
            return (OqlBuilder)query$1.where("thesisCheck.title = thesisCheck.writer.thesisTitle", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return (OqlBuilder)query$1.where("thesisCheck.title != thesisCheck.writer.thesisTitle", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder query$2, boolean docOk) {
        if (docOk) {
            return (OqlBuilder)query$2.where("thesisCheck.paperDoc is not null and thesisCheck.proposalDoc is not null and thesisCheck.defenseDoc is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return (OqlBuilder)query$2.where("thesisCheck.paperDoc is null or thesisCheck.proposalDoc is null or thesisCheck.defenseDoc is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private static final String processZip$$anonfun$1$$anonfun$1(String fileName$1) {
        return fileName$1 + " format is error";
    }

    private static final /* synthetic */ boolean $anonfun$10(char _$5) {
        return _$5 != ' ';
    }

    private static final ThesisDoc $anonfun$11() {
        return new ThesisDoc();
    }

    private static final ThesisDoc $anonfun$12() {
        return new ThesisDoc();
    }
}

