/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Deadline;
import org.openurp.degree.thesis.model.MidtermCheck;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DeferService;
import org.openurp.degree.thesis.service.doc.ThesisDocGenerator$;
import org.openurp.degree.thesis.web.helper.MidtermCheckPropertyExtractor;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MidtermCheckAction
extends RestfulAction<Writer>
implements ProjectSupport,
ExportSupport<Writer> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private DeferService deferService;
    private WebBusinessLogger businessLogger;

    public MidtermCheckAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public DeferService deferService() {
        return this.deferService;
    }

    public void deferService_$eq(DeferService x$1) {
        this.deferService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", (Object)this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", (Object)this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<Writer> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        Seq departs = this.getDeparts(this.project$2(lazyRef));
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.std.state.department in(:departs) and writer.thesisTitle is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        this.populateConditions(query);
        query.limit(this.getPageLimit());
        query.orderBy((String)this.get(Order$.MODULE$.OrderStr(), (Object)"writer.std.code"));
        this.get("status").foreach((Function1)(JProcedure1 & Serializable)s -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)s)) {
                String string = s;
                switch (string == null ? 0 : string.hashCode()) {
                    case -990180745: {
                        if (!"\u5b66\u9662\u5ba1\u67e5\u672a\u901a\u8fc7".equals(string)) break;
                        query.where("exists(from " + MidtermCheck.class.getName() + " c where c.writer=writer and c.status=:unpassed)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Rejected}));
                        return;
                    }
                    case -358374844: {
                        if (!"\u6559\u5e08\u5ba1\u67e5\u672a\u901a\u8fc7".equals(string)) break;
                        query.where("exists(from " + MidtermCheck.class.getName() + " c join c.details as d where c.writer=writer and d.passed=false)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        return;
                    }
                    case 26192254: {
                        if (!"\u672a\u63d0\u4ea4".equals(string)) break;
                        query.where("not exists(from " + MidtermCheck.class.getName() + " c where c.writer=writer)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        return;
                    }
                    case 1235689120: {
                        if (!"\u6559\u5e08\u5ba1\u67e5\u901a\u8fc7".equals(string)) break;
                        query.where("exists(from " + MidtermCheck.class.getName() + " c where c.writer=writer and c.status=:status)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.PassedByAdvisor}));
                        return;
                    }
                    case 1769497613: {
                        if (!"\u5b66\u9662\u5ba1\u67e5\u901a\u8fc7".equals(string)) break;
                        query.where("exists(from " + MidtermCheck.class.getName() + " c where c.writer=writer and c.status=:passed)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Passed}));
                        return;
                    }
                    case 1904941113: {
                        if (!"\u5f85\u6559\u5e08\u68c0\u67e5".equals(string)) break;
                        query.where("exists(from " + MidtermCheck.class.getName() + " c where c.writer=writer and size(c.details)=0)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        return;
                    }
                }
                return;
            }
        });
        return query;
    }

    public View search() {
        OqlBuilder query = this.getQueryBuilder();
        Seq writers = this.entityDao().search((QueryBuilder)query);
        this.put("writers", (Object)writers);
        Map midtermChecks = ((IterableOnceOps)this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("midtermChecks", (Object)midtermChecks);
        this.put("stage", (Object)Stage$.MidtermCheck);
        return this.forward(this.forward$default$1());
    }

    public View reject() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        Seq midtermChecks = this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writers);
        midtermChecks.foreach((Function1)(JProcedure1 & Serializable)mc -> {
            mc.status_$eq(AuditStatus$.RejectedByDepart);
            String msg = "\u9000\u56de" + mc.writer().std().name() + "\u7684\u4e2d\u671f\u68c0\u67e5";
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.std.code");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)mc.writer().std().code());
            this.businessLogger().info(msg, mc.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        });
        this.entityDao().saveOrUpdate((Iterable)midtermChecks);
        return this.redirect("search", "\u9000\u56de\u6210\u529f");
    }

    public View defer() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        writers.foreach((Function1)(JProcedure1 & Serializable)writer -> {
            Deadline deadline = writer.getOrCreateDeadline(Stage$.MidtermCheck);
            this.deferService().defer(deadline, Stage$.MidtermCheck);
        });
        return this.redirect("search", "info.save.success");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        MidtermCheck midtermCheck = (MidtermCheck)this.entityDao().get(MidtermCheck.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Writer writer = midtermCheck.writer();
        this.put("midtermCheck", (Object)midtermCheck);
        this.put("writer", (Object)writer);
        return this.forward(this.forward$default$1());
    }

    public View batchAuditSetting() {
        List writerIds = this.getLongIds("writer");
        OqlBuilder query = OqlBuilder$.MODULE$.from(MidtermCheck.class, "c");
        query.where("c.writer.id in(:ids)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writerIds}));
        query.where("size(c.details)>0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Seq checks = this.entityDao().search((QueryBuilder)query);
        this.put("checks", (Object)checks);
        return this.forward(this.forward$default$1());
    }

    public View batchAudit() {
        Seq checks = this.entityDao().find(MidtermCheck.class, (Iterable)this.getLongIds("midtermCheck"));
        boolean passed = this.getBoolean("passed", true);
        Option conclusion = this.get("conclusion");
        checks.foreach((Function1)(JProcedure1 & Serializable)check -> {
            if (check.details().nonEmpty()) {
                check.status_$eq(passed ? AuditStatus$.Passed : AuditStatus$.Rejected);
                check.conclusion_$eq(conclusion);
                return;
            }
        });
        this.entityDao().saveOrUpdate((Iterable)checks);
        return this.redirect("search", "\u5ba1\u6838\u6210\u529f");
    }

    public View doc() {
        Writer writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        Option option = this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writer).headOption();
        if (option instanceof Some) {
            MidtermCheck p = (MidtermCheck)((Some)option).value();
            return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genMidtermCheck(writer, (Option)Some$.MODULE$.apply((Object)p)), MediaTypes$.MODULE$.ApplicationDocx(), writer.std().code() + writer.std().name() + "\u4e2d\u671f\u68c0\u67e5\u8868.docx", Stream$.MODULE$.apply$default$4());
        }
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError((Object)option);
    }

    public View batchDoc() {
        Seq writers = this.entityDao().find(Writer.class, (Iterable)this.getLongIds("writer"));
        GraduateSeason season = ((Writer)writers.head()).season();
        Department depart = ((Writer)writers.head()).department();
        String dir = ThesisDocGenerator$.MODULE$.getDepartFolder(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        writers.foreach((Function1 & Serializable)writer -> {
            Option option = this.entityDao().findBy(MidtermCheck.class, "writer", writer).headOption();
            if (option instanceof Some) {
                MidtermCheck p = (MidtermCheck)((Some)option).value();
                InputStream is = ThesisDocGenerator$.MODULE$.genMidtermCheck(writer, (Option)Some$.MODULE$.apply((Object)p));
                FileOutputStream file = new FileOutputStream(new File(dir + Files$.MODULE$.$div() + (writer.std().code() + "\u4e2d\u671f\u68c0\u67e5\u8868.docx")));
                IOs$.MODULE$.copy(is, (OutputStream)file);
                IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{file}));
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                return Status$.MODULE$.NotFound();
            }
            throw new MatchError((Object)option);
        });
        File targetZip = ThesisDocGenerator$.MODULE$.getDepartZipFile(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        Zipper$.MODULE$.zip(new File(dir), targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = season.name() + "_" + depart.name() + " \u4e2d\u671f\u68c0\u67e5\u8868.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public void configExport(ExportContext context) {
        context.extractor_$eq((PropertyExtractor)new MidtermCheckPropertyExtractor(this.entityDao()));
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

