/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.advisor;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.Subject;
import org.openurp.degree.thesis.model.SubjectApply;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.service.SubjectService;
import org.openurp.degree.thesis.web.action.advisor.AdvisorSupport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class SubjectAction
extends AdvisorSupport
implements EntityAction<Subject> {
    private Class entityClass;
    private SubjectService subjectService;

    public SubjectAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public SubjectService subjectService() {
        return this.subjectService;
    }

    public void subjectService_$eq(SubjectService x$1) {
        this.subjectService = x$1;
    }

    public View index() {
        return this.forward(this.forward$default$1());
    }

    public View search() {
        this.put("subjects", (Object)this.entityDao().search((QueryBuilder)this.getQueryBuilder()));
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<Subject> getQueryBuilder() {
        Advisor advisor = this.getAdvisor();
        this.put("SubjectStage", (Object)Stage$.Subject);
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        this.thesisPlanService().getPlan().foreach((Function1)(JProcedure1 & Serializable)plan -> {
            query.where("subject.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{plan.season()}));
            Buffer departPlans = (Buffer)plan.departPlans().filter((Function1 & Serializable)x -> advisor.departs().contains((Object)x.department()));
            this.put("departPlans", (Object)departPlans);
            this.put("openedDeparts", ((IterableOps)departPlans.filter((Function1 & Serializable)x -> x.getStageTime(Stage$.Subject).timeSuitable(Instant.now()) == 0)).map((Function1 & Serializable)_$2 -> _$2.department()));
        });
        query.where("subject.advisor =:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor}));
        return (OqlBuilder)query.limit(null);
    }

    public View others() {
        Advisor advisor = this.getAdvisor();
        OqlBuilder query = OqlBuilder$.MODULE$.from(Subject.class, "subject");
        query.where("subject.depart in(:departs) and subject.advisor != :me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.departs(), advisor}));
        query.where("subject.status=:passed", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Passed}));
        this.thesisPlanService().getPlan().foreach((Function1 & Serializable)plan -> (OqlBuilder)query.where("subject.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{plan.season()})));
        Seq subjects = this.entityDao().search((QueryBuilder)query);
        this.put("subjects", (Object)subjects);
        return this.forward(this.forward$default$1());
    }

    public View history() {
        Advisor js = this.getAdvisor();
        ThesisPlan plan = (ThesisPlan)this.thesisPlanService().getPlan().get();
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(Subject.class, "subject").where("subject.advisor=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{js}));
        query.where("subject.season.graduateIn<:graduateIn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{plan.season().graduateIn()}));
        query.where("not exists(from " + Subject.class.getName() + " s2 where s2.name=subject.name and s2.advisor=subject.advisor and s2.season.graduateIn > subject.season.graduateIn)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.orderBy("subject.season.graduateIn desc");
        Seq lstmList = this.entityDao().search((QueryBuilder)query);
        this.put("lstmList", (Object)lstmList);
        this.put("majors", (Object)this.subjectService().getMajors(plan.season(), (Iterable)js.departs()));
        return this.forward(this.forward$default$1());
    }

    public View addFromHistory() {
        Advisor js = this.getAdvisor();
        Seq majors = this.entityDao().find(Major.class, this.getAll("majorId", Long.TYPE, ClassTag$.MODULE$.apply(Long.TYPE)));
        ArrayBuffer closedDeparts = new ArrayBuffer();
        ThesisPlan plan = (ThesisPlan)this.thesisPlanService().getPlan().get();
        this.getAll("lstmId").foreach((Function1)(JProcedure1 & Serializable)id -> {
            Subject lstm = (Subject)this.entityDao().get(Subject.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id.toString()))));
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"season");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)plan.season());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)lstm.name());
            Seq ksList = this.entityDao().findBy(Subject.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            if (ksList.isEmpty()) {
                if (this.thesisPlanService().isOpen(plan, lstm.depart(), Stage$.Subject)) {
                    Subject kt = new Subject();
                    kt.advisor_$eq(js);
                    if (js.departs().contains((Object)lstm.depart())) {
                        kt.depart_$eq(lstm.depart());
                    } else {
                        kt.depart_$eq((Department)js.departs().head());
                    }
                    kt.name_$eq(lstm.name());
                    kt.contents_$eq(lstm.contents());
                    kt.status_$eq(AuditStatus$.Draft);
                    kt.season_$eq(plan.season());
                    kt.majors().$plus$plus$eq((IterableOnce)majors);
                    this.entityDao().saveOrUpdate((Object)kt, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subject[0]));
                    return;
                }
                closedDeparts.addOne((Object)lstm.depart().name());
                return;
            }
        });
        if (closedDeparts.nonEmpty()) {
            return this.redirect("search", closedDeparts.mkString(",") + "\u7684\u5f00\u9898\u5df2\u7ecf\u5173\u95ed\uff0c\u6dfb\u52a0\u5931\u8d25");
        }
        return this.redirect("search", "info.save.success");
    }

    @mapping(method="post")
    public View save() {
        Subject subject = (Subject)this.populateEntity();
        ThesisPlan plan = (ThesisPlan)this.thesisPlanService().getPlan().get();
        if (subject.season() == null || !subject.season().persisted()) {
            subject.season_$eq(plan.season());
        }
        if (this.thesisPlanService().isOpen(plan, subject.depart(), Stage$.Subject)) {
            if (this.isDuplicated(BoxesRunTime.unboxToLong((Object)subject.id()), BoxesRunTime.unboxToLong((Object)subject.season().id()), subject.name())) {
                return this.redirect("search", "\u9898\u76ee\u91cd\u590d");
            }
            Seq majors = this.entityDao().find(Major.class, this.getAll("majorId", Long.TYPE, ClassTag$.MODULE$.apply(Long.TYPE)));
            subject.majors().clear();
            subject.majors().$plus$plus$eq((IterableOnce)majors);
            subject.advisor_$eq(this.getAdvisor());
            subject.status_$eq(AuditStatus$.Submited);
            this.saveOrUpdate((Object)subject);
            return this.redirect("search", "info.save.success");
        }
        return this.redirect("search", "\u5f00\u9898\u5df2\u7ecf\u5173\u95ed");
    }

    @response
    public boolean checkName(@param(value="subject_id") long id, @param(value="season_id") long seasonId, @param(value="subject.name") String mc) {
        return !this.isDuplicated(id, seasonId, mc);
    }

    private boolean isDuplicated(long subjectId, long seasonId, String name) {
        OqlBuilder query = (OqlBuilder)OqlBuilder$.MODULE$.from(Subject.class, "subject").where("subject.season.id = :seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)})).where("subject.id != :id and subject.name = :name", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)subjectId), name}));
        return this.entityDao().search((QueryBuilder)query).nonEmpty();
    }

    private Option<View> checkTime(Option<DepartPlan> plans) {
        if (plans.isEmpty()) {
            return Some$.MODULE$.apply((Object)this.forward("not_intime"));
        }
        DepartPlan plan = (DepartPlan)plans.get();
        Instant today = Instant.now();
        StageTime stageTime = plan.getStageTime(Stage$.Subject);
        if (stageTime.timeSuitable(today) != 0) {
            this.put("begin", (Object)stageTime.beginOn());
            this.put("end", (Object)stageTime.endOn());
            return Some$.MODULE$.apply((Object)this.forward("not_intime"));
        }
        return None$.MODULE$;
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        Subject subject = (Subject)this.entityDao().get(Subject.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Advisor js = this.getAdvisor();
        this.put("majors", (Object)this.subjectService().getMajors(subject.season(), (Iterable)js.departs()));
        this.put("departs", (Object)js.departs());
        if (subject.persisted()) {
            String string = subject.advisor().teacher().code();
            String string2 = Securities$.MODULE$.user();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new RuntimeException("Cannot edit other data");
            }
        }
        this.put("subject", (Object)subject);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="new", view="new,form")
    public View editNew() {
        Option plan = this.thesisPlanService().getPlan();
        Subject subject = new Subject();
        subject.season_$eq(((ThesisPlan)plan.get()).season());
        this.put("subject", (Object)subject);
        Advisor js = this.getAdvisor();
        this.put("majors", (Object)this.subjectService().getMajors(((ThesisPlan)plan.get()).season(), (Iterable)js.departs()));
        this.put("departs", (Object)js.departs());
        Advisor advisor = this.getAdvisor();
        return this.forward(this.forward$default$1());
    }

    @mapping(method="delete")
    public View remove() {
        Subject subject = (Subject)this.entityDao().get(Subject.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("subject")));
        String string = subject.advisor().code();
        String string2 = Securities$.MODULE$.user();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.entityDao().remove((Object)subject, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subject[0]));
        }
        return this.redirect("search", "\u5220\u9664\u6210\u529f");
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        this.put("subject", (Object)this.entityDao().get(Subject.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id)))));
        return this.forward(this.forward$default$1());
    }

    public View applies() {
        Advisor advisor = this.getAdvisor();
        Seq applies = this.entityDao().findBy(SubjectApply.class, "last.advisor", (Object)advisor);
        this.put("applies", (Object)applies);
        return this.forward(this.forward$default$1());
    }
}

