/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.std;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import org.beangle.commons.activation.MediaType;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.webmvc.To;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.person.model.Language;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.BlindPeerReview;
import org.openurp.degree.thesis.model.Commitment;
import org.openurp.degree.thesis.model.CopyCheck;
import org.openurp.degree.thesis.model.DefenseInfo;
import org.openurp.degree.thesis.model.DefenseWriter;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.Guidance;
import org.openurp.degree.thesis.model.MidtermCheck;
import org.openurp.degree.thesis.model.Proposal;
import org.openurp.degree.thesis.model.Signature;
import org.openurp.degree.thesis.model.Stage;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.ThesisArchive;
import org.openurp.degree.thesis.model.ThesisDoc;
import org.openurp.degree.thesis.model.ThesisDocType;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.doc.ThesisDocGenerator$;
import org.openurp.degree.thesis.web.action.std.GuidanceAction;
import org.openurp.degree.thesis.web.action.std.WriterSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DocAction
extends WriterSupport {
    private CodeService codeService;

    public CodeService codeService() {
        return this.codeService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public View index() {
        Writer writer = this.getWriter();
        this.put("writer", (Object)writer);
        Seq commitment = this.entityDao().findBy(Commitment.class, "writer", (Object)writer);
        this.put("commitment_confirmed", (Object)BoxesRunTime.boxToBoolean((boolean)commitment.headOption().exists((Function1 & Serializable)_$2 -> _$2.confirmed())));
        Seq proposal = this.entityDao().findBy(Proposal.class, "writer", (Object)writer);
        this.put("proposal_status", proposal.headOption().map((Function1 & Serializable)_$3 -> _$3.status()).getOrElse(DocAction::index$$anonfun$3));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Stage$.Guidance1);
        Seq guidance1s = this.entityDao().findBy(Guidance.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[2];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)writer);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Stage$.Guidance2);
        Seq guidance2s = this.entityDao().findBy(Guidance.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        this.put("guidance1_count", (Object)BoxesRunTime.boxToInteger((int)guidance1s.size()));
        this.put("guidance2_count", (Object)BoxesRunTime.boxToInteger((int)guidance2s.size()));
        Option review = this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption();
        this.put("advisor_reviewed", (Object)BoxesRunTime.boxToBoolean((review.nonEmpty() && ((ThesisReview)review.get()).advisorScore().nonEmpty() ? 1 : 0) != 0));
        this.put("cross_reviewed", (Object)BoxesRunTime.boxToBoolean((review.nonEmpty() && ((ThesisReview)review.get()).crossReviewScore().nonEmpty() ? 1 : 0) != 0));
        Option bpr = this.entityDao().findBy(BlindPeerReview.class, "writer", (Object)writer).headOption();
        this.put("blind_reviewed", (Object)BoxesRunTime.boxToBoolean((bpr.nonEmpty() && ((BlindPeerReview)bpr.get()).score().nonEmpty() ? 1 : 0) != 0));
        Seq docs = this.entityDao().findBy(ThesisDoc.class, "writer", (Object)writer);
        Map docsMap = ((IterableOnceOps)docs.map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.docType().code(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("docsMap", (Object)docsMap);
        this.put("signature", (Object)this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption());
        Option archive = this.entityDao().findBy(ThesisArchive.class, "writer", (Object)writer).headOption();
        this.put("archive", (Object)archive);
        return this.forward(this.forward$default$1());
    }

    public View cover() {
        Writer writer = this.getWriter();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genCover(writer), this.docx(), writer.std().code() + "\u8bba\u6587\u5c01\u9762.docx", Stream$.MODULE$.apply$default$4());
    }

    public View proposal() {
        Writer writer = this.getWriter();
        boolean pdf = this.getBoolean("pdf", false);
        if (pdf) {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Stage$.Proposal);
            Seq docs = this.entityDao().findBy(ThesisDoc.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return this.downloadDoc(docs.headOption());
        }
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        Option option = this.entityDao().findBy(Proposal.class, "writer", (Object)writer).headOption();
        if (option instanceof Some) {
            Proposal p = (Proposal)((Some)option).value();
            return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genProposal(p, signature), this.docx(), writer.std().code() + "\u5f00\u9898\u62a5\u544a.docx", Stream$.MODULE$.apply$default$4());
        }
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError((Object)option);
    }

    public View download() {
        Writer writer = this.getWriter();
        ThesisDoc doc = (ThesisDoc)this.entityDao().get(ThesisDoc.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("doc")));
        Writer writer2 = doc.writer();
        Writer writer3 = writer;
        if (!(writer2 != null ? !writer2.equals(writer3) : writer3 != null)) {
            return this.downloadDoc((Option)Some$.MODULE$.apply((Object)doc));
        }
        return Status$.MODULE$.NotFound();
    }

    private View downloadDoc(Option<ThesisDoc> doc) {
        Option<ThesisDoc> option = doc;
        if (option instanceof Some) {
            ThesisDoc d = (ThesisDoc)((Some)option).value();
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(d.filePath());
            HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
            response2.sendRedirect(((URL)path.get()).toString());
            return null;
        }
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        throw new MatchError(option);
    }

    public View commitment() {
        Writer writer = this.getWriter();
        Option commitment = this.entityDao().findBy(Commitment.class, "writer", (Object)writer).headOption();
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genCommitment(writer, commitment, signature), this.docx(), writer.std().code() + "\u627f\u8bfa\u4e66.docx", Stream$.MODULE$.apply$default$4());
    }

    public View task() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genTask(writer, plan, signature), this.docx(), writer.std().code() + "\u4efb\u52a1\u4e66.docx", Stream$.MODULE$.apply$default$4());
    }

    public View guidance1() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Stage$.Guidance1);
        Seq guidances = this.entityDao().findBy(Guidance.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (guidances.size() < 2) {
            return this.redirect((To)this.to(GuidanceAction.class, "index", "stage=" + Stage$.Guidance1.id()), "\u5c1a\u672a\u586b\u5199\u5b8c\u6210");
        }
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genGuidance(writer, plan, guidances, 1, signature), this.docx(), writer.std().code() + "\u6559\u5e08\u6307\u5bfc\u8bb0\u5f55I.docx", Stream$.MODULE$.apply$default$4());
    }

    public View guidance2() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Stage$.Guidance2);
        Seq guidances = this.entityDao().findBy(Guidance.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (guidances.size() < 2) {
            return this.redirect((To)this.to(GuidanceAction.class, "index", "stage=" + Stage$.Guidance2.id()), "\u5c1a\u672a\u586b\u5199\u5b8c\u6210");
        }
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genGuidance(writer, plan, guidances, 2, signature), this.docx(), writer.std().code() + "\u6559\u5e08\u6307\u5bfc\u8bb0\u5f55II.docx", Stream$.MODULE$.apply$default$4());
    }

    public View midtermCheck() {
        Writer writer = this.getWriter();
        Option midtermCheck = this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genMidtermCheck(writer, midtermCheck), this.docx(), writer.std().code() + "\u4e2d\u671f\u68c0\u67e5\u8868.docx", Stream$.MODULE$.apply$default$4());
    }

    public View copyCheck() {
        Writer writer = this.getWriter();
        Seq checks = this.entityDao().findBy(CopyCheck.class, "writer", (Object)writer);
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genCopyCheck(writer, checks, signature), this.docx(), writer.std().code() + "\u53cd\u6284\u88ad\u68c0\u6d4b\u60c5\u51b5\u8bb0\u5f55\u8868.docx", Stream$.MODULE$.apply$default$4());
    }

    public View blindReview() {
        Writer writer = this.getWriter();
        Option review = this.entityDao().findBy(BlindPeerReview.class, "writer", (Object)writer).headOption();
        if (review.isEmpty()) {
            return this.redirect("index", "\u6ca1\u6709\u6821\u5916\u9001\u5ba1\u4fe1\u606f");
        }
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genBlindReview(writer, review), this.docx(), writer.std().code() + "\u6821\u5916\u9001\u5ba1\u60c5\u51b5\u8bb0\u5f55\u8868.docx", Stream$.MODULE$.apply$default$4());
    }

    public View advisorReview() {
        Writer writer = this.getWriter();
        Option review = this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption();
        if (review.isEmpty() || ((ThesisReview)review.get()).advisorScore().isEmpty()) {
            return this.redirect("index", "\u6307\u5bfc\u6559\u5e08\u5c1a\u672a\u8bc4\u5206");
        }
        Option signature = this.entityDao().findBy(Signature.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genAdvisorReview(writer, review, signature), this.docx(), writer.std().code() + "\u6307\u5bfc\u6559\u5e08\u8bc4\u5206\u8868.docx", Stream$.MODULE$.apply$default$4());
    }

    public View crossReview() {
        Writer writer = this.getWriter();
        Option review = this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption();
        if (review.isEmpty() || ((ThesisReview)review.get()).crossReviewScore().isEmpty()) {
            return this.redirect("index", "\u4ea4\u53c9\u8bc4\u9605\u5c1a\u672a\u8bc4\u5206");
        }
        GraduateSeason season = writer.season();
        ObjectRef signature = ObjectRef.create((Object)None$.MODULE$);
        ((ThesisReview)review.get()).crossReviewer().foreach((Function1)(JProcedure1 & Serializable)reviewer -> {
            OqlBuilder q = OqlBuilder$.MODULE$.from(Signature.class, "s");
            q.where("s.writer.season=:season and s.writer.advisor.teacher=:teacher", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season, reviewer}));
            q.where("s.advisorUrl is not null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            signature$1.elem = this.entityDao().search((QueryBuilder)q).headOption();
        });
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genCrossReview(writer, review, (Option)signature.elem), this.docx(), writer.std().code() + "\u8bc4\u9605\u8868.docx", Stream$.MODULE$.apply$default$4());
    }

    public View defense() {
        Writer writer = this.getWriter();
        boolean pdf = this.getBoolean("pdf", false);
        if (pdf) {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Stage$.OralDefense);
            Seq docs = this.entityDao().findBy(ThesisDoc.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return this.downloadDoc(docs.headOption());
        }
        OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseWriter.class, "dw");
        query.where("dw.writer = :writer", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}));
        query.where("dw.group.published=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option defenseGroup = ((IterableOps)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)_$4 -> _$4.group())).headOption();
        Option review = this.entityDao().findBy(ThesisReview.class, "writer", (Object)writer).headOption();
        Option defenseInfo = this.entityDao().findBy(DefenseInfo.class, "writer", (Object)writer).headOption();
        return Stream$.MODULE$.apply(ThesisDocGenerator$.MODULE$.genDefense(writer, review, defenseGroup, defenseInfo), this.docx(), writer.std().code() + "\u7b54\u8fa9\u8bb0\u5f55\u53ca\u8bc4\u5206\u8868.docx", Stream$.MODULE$.apply$default$4());
    }

    public View uploadForm() {
        Writer writer = this.getWriter();
        Option paper = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer).headOption();
        if (paper.isEmpty()) {
            return this.redirect("index", "\u8fd8\u6ca1\u6709\u4f60\u7684\u8bba\u6587\uff0c\u6682\u505c\u4e0a\u4f20");
        }
        List dt = this.findDocTypes(writer);
        this.put("docTypes", (Object)dt);
        this.put("writer", (Object)writer);
        Map docs = ((IterableOnceOps)this.entityDao().findBy(ThesisDoc.class, "writer", (Object)writer).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.docType(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("docs", (Object)docs);
        this.put("paper", (Object)paper);
        this.put("languages", (Object)this.codeService().get(Language.class));
        ThesisArchive archive = (ThesisArchive)this.entityDao().findBy(ThesisArchive.class, "writer", (Object)writer).headOption().getOrElse(DocAction::$anonfun$4);
        this.put("archive", (Object)archive);
        return this.forward(this.forward$default$1());
    }

    public View upload() {
        Writer writer = this.getWriter();
        ThesisArchive archive = (ThesisArchive)this.entityDao().findBy(ThesisArchive.class, "writer", (Object)writer).headOption().getOrElse(DocAction::$anonfun$5);
        if (BoxesRunTime.unboxToBoolean((Object)archive.archived().getOrElse(DocAction::upload$$anonfun$1))) {
            return this.redirect("index", "\u4f60\u5df2\u7ecf\u4e0a\u4f20\u8fc7\u5f52\u6863\u6750\u6599\uff0c\u65e0\u9700\u91cd\u590d\u4e0a\u4f20");
        }
        if (BoxesRunTime.unboxToBoolean((Object)archive.confirmed().getOrElse(DocAction::upload$$anonfun$2))) {
            return this.redirect("index", "\u5bfc\u5e08\u5df2\u7ecf\u786e\u8ba4\uff0c\u65e0\u9700\u91cd\u590d\u4e0a\u4f20");
        }
        String field = (String)this.get("paper.researchField", (Object)"");
        String string = writer.std().major().name();
        String string2 = field;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.redirect("uploadForm", "\u8bba\u6587\u7814\u7a76\u65b9\u5411\u4e0e\u5b66\u751f\u4e13\u4e1a\u4e0d\u80fd\u4e00\u81f4");
        }
        this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer).headOption().foreach((Function1)(JProcedure1 & Serializable)paper -> {
            paper.researchField_$eq(this.get("paper.researchField"));
            this.get("paper.keywords").foreach((Function1)(JProcedure1 & Serializable)k -> {
                String v = Strings$.MODULE$.replace(k, ",", "\uff1b");
                v = Strings$.MODULE$.replace(v, "\uff0c", "\uff1b");
                paper.keywords_$eq((Option)Some$.MODULE$.apply((Object)v));
            });
            paper.thesisType_$eq(this.get("paper.thesisType"));
            paper.language_$eq((Option)Some$.MODULE$.apply((Object)this.entityDao().get(Language.class, (Object)BoxesRunTime.boxToInteger((int)this.getInt("paper.language.id", 0)))));
            this.entityDao().saveOrUpdate(paper, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPaper[0]));
            List dt = this.findDocTypes(writer);
            dt.foreach((Function1)(JProcedure1 & Serializable)docType -> this.uploadDoc(writer, docType));
        });
        archive.writer_$eq(writer);
        archive.uploadAt_$eq((Option)Some$.MODULE$.apply((Object)Instant.now()));
        archive.confirmed_$eq((Option)None$.MODULE$);
        archive.confirmedBy_$eq((Option)None$.MODULE$);
        archive.archived_$eq((Option)None$.MODULE$);
        this.entityDao().saveOrUpdate((Object)archive, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisArchive[0]));
        this.businessLogger().info("\u4e0a\u4f20\u4e86\u5f52\u6863\u6750\u6599", writer.id(), (Object)None$.MODULE$);
        return this.redirect("index", "info.save.success");
    }

    private List<ThesisDocType> findDocTypes(Writer writer) {
        Seq blindPeerReviews = this.entityDao().findBy(BlindPeerReview.class, "writer", (Object)writer);
        Buffer allTypes = (Buffer)((IterableOnceOps)this.entityDao().getAll(ThesisDocType.class).filter((Function1 & Serializable)_$5 -> _$5.active())).toBuffer().sortBy((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)x.stage().id()).toString() + "." + x.code(), (Ordering)Ordering.String$.MODULE$);
        if (blindPeerReviews.isEmpty()) {
            return ((IterableOnceOps)allTypes.subtractAll((IterableOnce)allTypes.find((Function1 & Serializable)_$6 -> {
                String string = _$6.code();
                String string2 = "blindReview";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }))).toList();
        }
        return allTypes.toList();
    }

    private void uploadDoc(Writer writer, ThesisDocType docType) {
        Stage stage = docType.stage();
        Iterable parts = this.getAll(docType.code(), Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            String storeName = writer.std().code() + " " + docType.name() + "." + Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"docType");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)docType);
            ThesisDoc dd = (ThesisDoc)this.entityDao().findBy(ThesisDoc.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption().getOrElse(DocAction::$anonfun$8);
            dd.writer_$eq(writer);
            dd.stage_$eq(stage);
            dd.docType_$eq(docType);
            if (dd.filePath() != null && dd.filePath().startsWith("/")) {
                blob.remove(dd.filePath());
            }
            BlobMeta meta = blob.upload("/" + writer.season().id().toString() + ("/archive/" + docType.code() + "/"), part.getInputStream(), storeName, writer.std().code() + " " + writer.std().name());
            dd.fileExt_$eq(meta.mediaType());
            dd.filePath_$eq(meta.filePath());
            dd.updatedAt_$eq(Instant.now());
            this.entityDao().saveOrUpdate((Object)dd, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisDoc[0]));
            return;
        }
    }

    private MediaType docx() {
        return MediaTypes$.MODULE$.ApplicationDocx();
    }

    private static final AuditStatus index$$anonfun$3() {
        return AuditStatus$.Draft;
    }

    private static final ThesisArchive $anonfun$4() {
        return new ThesisArchive();
    }

    private static final ThesisArchive $anonfun$5() {
        return new ThesisArchive();
    }

    private static final boolean upload$$anonfun$1() {
        return false;
    }

    private static final boolean upload$$anonfun$2() {
        return false;
    }

    private static final ThesisDoc $anonfun$8() {
        return new ThesisDoc();
    }
}

