/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.bean.Initializing;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.ems.app.dao.AppDataSourceFactory;
import org.beangle.jdbc.query.JdbcExecutor;
import org.beangle.security.authc.Profile$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.service.DefenseGroupService;
import org.openurp.starter.web.helper.EmsCookieHelper;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AdvisorAction
extends RestfulAction<Advisor>
implements ExportSupport<Advisor>,
ProjectSupport,
Initializing {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private DefenseGroupService defenseGroupService;
    private JdbcExecutor baseJdbcExecutor;
    private int defaultmMaxWriters;

    public AdvisorAction() {
        ProjectSupport.$init$((ProjectSupport)this);
        this.defaultmMaxWriters = 8;
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public DefenseGroupService defenseGroupService() {
        return this.defenseGroupService;
    }

    public void defenseGroupService_$eq(DefenseGroupService x$1) {
        this.defenseGroupService = x$1;
    }

    public JdbcExecutor baseJdbcExecutor() {
        return this.baseJdbcExecutor;
    }

    public void baseJdbcExecutor_$eq(JdbcExecutor x$1) {
        this.baseJdbcExecutor = x$1;
    }

    public int defaultmMaxWriters() {
        return this.defaultmMaxWriters;
    }

    public void defaultmMaxWriters_$eq(int x$1) {
        this.defaultmMaxWriters = x$1;
    }

    public void init() {
        AppDataSourceFactory ds = new AppDataSourceFactory();
        ds.name_$eq("base");
        ds.init();
        this.baseJdbcExecutor_$eq(new JdbcExecutor(ds.result()));
    }

    public View disable() {
        Seq advisors = this.entityDao().find(Advisor.class, (Iterable)this.getLongIds("advisor"));
        LocalDate yestoday = LocalDate.now().minusDays(1L);
        advisors.foreach((Function1)(JProcedure1 & Serializable)advisor -> advisor.endOn_$eq((Option)Some$.MODULE$.apply((Object)yestoday)));
        this.entityDao().saveOrUpdate((Iterable)advisors);
        return this.redirect("search", "\u7981\u7528\u6210\u529f");
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        Seq departs = this.getDeparts(this.project$1(lazyRef));
        this.put("departs", departs);
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, "department", (Object)departs));
        super.indexSetting();
    }

    public OqlBuilder<Advisor> getQueryBuilder() {
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getInt("depart.id").foreach((Function1 & Serializable)did -> AdvisorAction.getQueryBuilder$$anonfun$1(query, BoxesRunTime.unboxToInt((Object)did)));
        this.getBoolean("active").foreach((Function1 & Serializable)x$1 -> AdvisorAction.getQueryBuilder$$anonfun$2(query, BoxesRunTime.unboxToBoolean((Object)x$1)));
        return query;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View saveAndRedirect(Advisor advisor) {
        Seq departs = this.entityDao().find(Department.class, (Iterable)this.getIntIds("depart"));
        advisor.departs().subtractAll((IterableOnce)advisor.departs().filterNot((Function1 & Serializable)elem -> departs.contains(elem)));
        Buffer buffer = advisor.departs();
        advisor.departs().$plus$plus$eq((IterableOnce)departs.filterNot((Function1 & Serializable)elem -> buffer.contains(elem)));
        if (!advisor.persisted()) {
            advisor.teacher_$eq((Teacher)this.entityDao().get(Teacher.class, advisor.teacher().id()));
        }
        if (!advisor.persisted()) {
            advisor.maxWriters_$eq(Int$.MODULE$.int2long(this.defaultmMaxWriters()));
        }
        Teacher teacher = advisor.teacher();
        Option option = this.getLong("office.id");
        if (None$.MODULE$.equals(option)) {
            teacher.office_$eq((Option)None$.MODULE$);
        } else {
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            long officeId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            TeachingOffice office = (TeachingOffice)this.entityDao().get(TeachingOffice.class, (Object)BoxesRunTime.boxToLong((long)officeId));
            teacher.office_$eq((Option)Some$.MODULE$.apply((Object)office));
            boolean bl = this.getBoolean("isDirector", false);
            if (bl) {
                office.director_$eq((Option)Some$.MODULE$.apply((Object)teacher));
            } else {
                if (bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                if (office.director().contains((Object)teacher)) {
                    office.director_$eq((Option)None$.MODULE$);
                }
            }
        }
        if (advisor.persisted()) {
            this.updateTeacher(advisor.teacher());
            return super.saveAndRedirect((Entity)advisor);
        }
        OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class, "ad");
        query.where("ad.teacher=:teacher", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        if (!this.entityDao().search((QueryBuilder)query).isEmpty()) return this.redirect("search", "\u8be5\u6559\u5e08\u5df2\u7ecf\u5b58\u5728\u4e8e\u540d\u5355\u4e2d");
        this.updateTeacher(advisor.teacher());
        return super.saveAndRedirect((Entity)advisor);
    }

    private void updateTeacher(Teacher teacher) {
        this.entityDao().saveOrUpdate((Object)teacher, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Teacher[0]));
        Option option = teacher.office();
        if (None$.MODULE$.equals(option)) {
            this.baseJdbcExecutor().update("update base.teachers set office_id = null where id=" + teacher.id(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            return;
        }
        if (option instanceof Some) {
            TeachingOffice o = (TeachingOffice)((Some)option).value();
            this.entityDao().saveOrUpdate((Object)o, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TeachingOffice[0]));
            this.baseJdbcExecutor().update("update base.teachers set office_id=" + o.id() + " where id=" + teacher.id(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            o.director().foreach((Function1 & Serializable)d -> this.baseJdbcExecutor().update("update base.teaching_offices set director_id=" + d.id() + " where id=" + o.id(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
            return;
        }
        throw new MatchError((Object)option);
    }

    public void editSetting(Advisor advisor) {
        LazyRef lazyRef = new LazyRef();
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, "department", (Object)this.getDeparts(this.project$2(lazyRef))));
        BooleanRef isDirector = BooleanRef.create((boolean)false);
        if (advisor.teacher() != null) {
            advisor.teacher().office().foreach((Function1)(JProcedure1 & Serializable)o -> {
                isDirector$1.elem = o.director().contains((Object)advisor.teacher());
            });
        }
        this.put("isDirector", BoxesRunTime.boxToBoolean((boolean)isDirector.elem));
        this.put("departs", this.project$2(lazyRef).departments());
        this.put("project", this.project$2(lazyRef));
        if (!advisor.persisted()) {
            OqlBuilder query = OqlBuilder$.MODULE$.from(Teacher.class, "t");
            query.where("not exists(from " + Advisor.class.getName() + " a where a.teacher=t)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            query.orderBy("t.department.id,t.staff.code");
            Seq teachers = this.entityDao().search((QueryBuilder)query);
            this.put("teachers", teachers);
        }
        new EmsCookieHelper(this.entityDao()).getProfile(this.request(), this.response()).foreach((Function1)(JProcedure1 & Serializable)p -> this.put("isAdmin", BoxesRunTime.boxToBoolean((boolean)p.getProperty("department").contains((Object)Profile$.MODULE$.AllValue()))));
        if (!advisor.persisted()) {
            advisor.maxWriters_$eq(Int$.MODULE$.int2long(this.defaultmMaxWriters()));
            advisor.beginOn_$eq(LocalDate.now());
        }
        super.editSetting((Entity)advisor);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder query$1, int did) {
        return (OqlBuilder)query$1.where("exists(from advisor.departs as d where d.id=:departId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)did)}));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder query$2, boolean x$1) {
        boolean bl = x$1;
        if (!bl) {
            return (OqlBuilder)query$2.where("advisor.endOn < :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        }
        if (bl) {
            return (OqlBuilder)query$2.where("advisor.endOn is null or advisor.endOn >= :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

