/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.excel.schema.ExcelColumn;
import org.beangle.doc.excel.schema.ExcelScheet;
import org.beangle.doc.excel.schema.ExcelSchema;
import org.beangle.doc.transfer.importer.ImportSetting;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.ImportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.BlindPeerReview;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.service.doc.ThesisDocGenerator$;
import org.openurp.degree.thesis.web.helper.BlindPeerReviewImportListener;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Random$;

public class BlindReviewAction
extends RestfulAction<BlindPeerReview>
implements ProjectSupport,
ExportSupport<BlindPeerReview>,
ImportSupport<BlindPeerReview> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public BlindReviewAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public View drawlot() {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("review.writer.season")));
        Map exists = this.entityDao().findBy(BlindPeerReview.class, "writer.season", (Object)season).groupBy((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToInt((Object)_$1.writer().department().id()));
        float ratio = BoxesRunTime.unboxToFloat((Object)this.getFloat("ratio").getOrElse(BlindReviewAction::$anonfun$2));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisPaper.class.getName(), "paper");
        query.where("paper.writer.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.select("paper.writer.std.state.department.id,count(*)");
        query.groupBy("paper.writer.std.state.department.id");
        Map totals = ((IterableOnceOps)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)x -> {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((Number)x[0]).intValue()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToInteger((int)((Number)x[1]).intValue()));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        totals.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int existed;
                int departId = tuple2._1$mcI$sp();
                int cnt = tuple2._2$mcI$sp();
                int required = (int)Numbers$.MODULE$.round(Numbers$.MODULE$.multiply(Float$.MODULE$.float2double(ratio), Int$.MODULE$.int2double(cnt)), 0);
                if (required > (existed = ((SeqOps)exists.getOrElse((Object)BoxesRunTime.boxToInteger((int)departId), BlindReviewAction::$anonfun$4)).size())) {
                    OqlBuilder q = OqlBuilder$.MODULE$.from(ThesisPaper.class, "paper");
                    q.where("paper.writer.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
                    q.where("paper.writer.std.state.department.id=:departId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)departId)}));
                    q.where("not exists(from " + BlindPeerReview.class.getName() + " bpr where bpr.writer=paper.writer)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                    Seq papers = this.entityDao().search((QueryBuilder)q);
                    Seq news = (Seq)((IterableOps)((IterableOps)Random$.MODULE$.shuffle((IterableOnce)papers, BuildFrom$.MODULE$.buildFromIterableOps())).take(required - existed)).map((Function1 & Serializable)paper -> {
                        BlindPeerReview r = new BlindPeerReview();
                        r.writer_$eq(paper.writer());
                        r.remark_$eq((Option)Some$.MODULE$.apply((Object)"\u7cfb\u7edf\u968f\u673a\u62bd\u53d6"));
                        r.updatedAt_$eq(Instant.now());
                        return r;
                    });
                    this.entityDao().saveOrUpdate((Iterable)news);
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return this.redirect("search", "\u968f\u673a\u62bd\u68c0\u6210\u529f\uff01");
    }

    @response
    public Object downloadTemplate() {
        ExcelSchema schema = new ExcelSchema();
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u8bba\u6587\u7ed3\u679c\u68c0\u6d4b\u6a21\u677f");
        sheet.remark("\u7279\u522b\u8bf4\u660e\uff1a\n1\u3001\u4e0d\u53ef\u6539\u53d8\u672c\u8868\u683c\u7684\u884c\u5217\u7ed3\u6784\u4ee5\u53ca\u6279\u6ce8\uff0c\u5426\u5219\u5c06\u4f1a\u5bfc\u5165\u5931\u8d25\uff01\n2\u3001\u5fc5\u987b\u6309\u7167\u89c4\u683c\u8bf4\u660e\u7684\u683c\u5f0f\u586b\u5199\u3002\n3\u3001\u53ef\u4ee5\u591a\u6b21\u5bfc\u5165\uff0c\u91cd\u590d\u7684\u4fe1\u606f\u4f1a\u88ab\u65b0\u6570\u636e\u66f4\u65b0\u8986\u76d6\u3002\n4\u3001\u4fdd\u5b58\u7684excel\u6587\u4ef6\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u3002");
        ExcelColumn excelColumn = sheet.add("\u5b66\u53f7", "writer.std.code").length(20).remark("\u226420\u4f4d");
        excelColumn.required(excelColumn.required$default$1());
        ExcelColumn excelColumn2 = sheet.add("\u5206\u6570", "review.score");
        excelColumn2.integer(excelColumn2.integer$default$1());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u76f2\u5ba1\u6210\u7ee9\u5bfc\u5165\u6a21\u677f.xlsx", Stream$.MODULE$.apply$default$4());
    }

    public View stat() {
        LazyRef lazyRef = new LazyRef();
        long seasonId = BoxesRunTime.unboxToLong((Object)this.getLong("review.writer.season.id").get());
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(BlindPeerReview.class.getName(), "review");
        query2.where("review.writer.season.id=:seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query2.where("review.writer.std.state.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        query2.select("review.writer.std.state.department.id,review.writer.std.state.department.name,count(*)");
        query2.groupBy("review.writer.std.state.department.id,review.writer.std.state.department.name");
        query2.orderBy("review.writer.std.state.department.id");
        Seq papers = this.entityDao().search((QueryBuilder)query2);
        scala.collection.mutable.Map zipTimes = Collections$.MODULE$.newMap();
        papers.foreach((Function1)(JProcedure1 & Serializable)p -> {
            int departId = ((Number)p[0]).intValue();
            File f = ThesisDocGenerator$.MODULE$.getDepartZipFile(seasonId, departId, "blind-review");
            if (f.exists()) {
                zipTimes.put((Object)BoxesRunTime.boxToInteger((int)departId), (Object)new Date(f.lastModified()));
                return;
            }
        });
        this.put("papers", papers);
        this.put("zipTimes", zipTimes);
        this.put("seasonId", BoxesRunTime.boxToLong((long)seasonId));
        return this.forward(this.forward$default$1());
    }

    public View genZip() {
        long seasonId = this.getLongId("season");
        int departmentId = this.getIntId("department");
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(ThesisPaper.class.getName() + (" paper," + BlindPeerReview.class.getName() + "  r"));
        query2.where("paper.writer.season.id=:seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query2.where("r.writer.season.id=:seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query2.where("r.writer=paper.writer", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query2.where("paper.writer.std.state.department.id=:departId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)departmentId)}));
        query2.select("paper");
        Seq papers = this.entityDao().search((QueryBuilder)query2);
        String dir = ThesisDocGenerator$.MODULE$.getDepartFolder(seasonId, departmentId, "blind-review");
        PaperDownloadHelper$.MODULE$.download(new File(dir), (Iterable<ThesisPaper>)papers);
        File targetZip = ThesisDocGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "blind-review");
        Zipper$.MODULE$.zip(new File(dir), targetZip, Zipper$.MODULE$.zip$default$3());
        return this.redirect("stat", "review.writer.season.id=" + seasonId, "\u751f\u6210\u6210\u529f");
    }

    public View downloadZip() {
        long seasonId = this.getLongId("season");
        int departmentId = this.getIntId("department");
        File file = ThesisDocGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "blind-review");
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)departmentId));
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)seasonId));
        String fileName = season.name() + "_" + depart.name() + " \u6821\u5916\u9001\u5ba1\u8bba\u6587.zip";
        return Stream$.MODULE$.apply(file, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public void configImport(ImportSetting setting) {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("review.writer.season")));
        setting.listeners_$eq((List)new .colon.colon((Object)new BlindPeerReviewImportListener(season, this.entityDao()), (List)Nil$.MODULE$));
    }

    public String simpleEntityName() {
        return "review";
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private static final float $anonfun$2() {
        return 0.1f;
    }

    private static final Seq $anonfun$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }
}

