/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.support.helper.QueryHelper$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.User;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.base.std.model.StudentState;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.DefenseGroup;
import org.openurp.degree.thesis.model.DefenseMember;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DefenseGroupService;
import org.openurp.degree.thesis.service.ThesisPlanService;
import org.openurp.degree.thesis.service.doc.DefenseReport$;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import org.openurp.degree.thesis.web.helper.RandomGroup;
import org.openurp.degree.thesis.web.helper.RandomGroupHelper$;
import org.openurp.degree.thesis.web.helper.ScoreTextHelper$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class DefenseAction
extends RestfulAction<DefenseGroup>
implements ExportSupport<DefenseGroup>,
ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private DefenseGroupService groupService;
    private ThesisPlanService thesisPlanService;
    private WebBusinessLogger businessLogger;

    public DefenseAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public DefenseGroupService groupService() {
        return this.groupService;
    }

    public void groupService_$eq(DefenseGroupService x$1) {
        this.groupService = x$1;
    }

    public ThesisPlanService thesisPlanService() {
        return this.thesisPlanService;
    }

    public void thesisPlanService_$eq(ThesisPlanService x$1) {
        this.thesisPlanService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$1(lazyRef));
        this.put("departs", departs);
        OqlBuilder oQuery = OqlBuilder$.MODULE$.from(TeachingOffice.class, "o");
        oQuery.where("o.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        oQuery.where("o.endOn is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        scala.collection.immutable.Seq offices = this.entityDao().search((QueryBuilder)oQuery);
        this.put("offices", offices);
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", this.entityDao().search((QueryBuilder)gQuery));
    }

    public OqlBuilder<DefenseGroup> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        query.where("defenseGroup.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        this.get("teacherName").foreach((Function1)(JProcedure1 & Serializable)teacherName -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)teacherName)) {
                query.where("exists(from defenseGroup.members m where m.teacher.name like :teacherName)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + teacherName + "%"}));
                return;
            }
        });
        this.get("writerName").foreach((Function1)(JProcedure1 & Serializable)writerName -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)writerName)) {
                query.where("exists(from defenseGroup.writers w where w.writer.std.name like :writerName or w.writer.std.code like :writerName)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + writerName + "%"}));
                return;
            }
        });
        return query;
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        LazyRef lazyRef = new LazyRef();
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("defenseGroup", defenseGroup);
        this.put("writers", defenseGroup.orderedWriters());
        Buffer<Teacher> teachers = this.searchMemberCandidates(defenseGroup);
        Buffer myDeparts = (Buffer)teachers.filter((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = defenseGroup.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        teachers.subtractAll((IterableOnce)myDeparts);
        teachers.prependAll((IterableOnce)myDeparts);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.project$3(lazyRef).school());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, myDeparts.map((Function1 & Serializable)_$4 -> _$4.code()));
        scala.collection.immutable.Seq secretaries = this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.put("secretaries", secretaries);
        this.put("advisors", teachers);
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$3(lazyRef));
        this.put("departs", departs);
        Object[] objectArray2 = new Tuple2[2];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"project");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.project$3(lazyRef));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)departs);
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        return this.forward(this.forward$default$1());
    }

    private Buffer<Teacher> searchMemberCandidates(DefenseGroup group) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Advisor.class.getName(), "advisor");
        query.orderBy("advisor.teacher.department.name,advisor.teacher.name");
        query.select("advisor.teacher");
        Buffer teachers = this.entityDao().search((QueryBuilder)query).toBuffer();
        scala.collection.immutable.Set writerAdvisors = ((IterableOnceOps)group.orderedWriters().map((Function1 & Serializable)_$5 -> ((Advisor)_$5.advisor().get()).teacher())).toSet();
        teachers.subtractAll((IterableOnce)writerAdvisors);
        return teachers;
    }

    @mapping(value="new", view="new,form")
    public View editNew() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$4(lazyRef));
        DefenseGroup defenseGroup = new DefenseGroup(((ThesisPlan)this.thesisPlanService().getPlan().get()).season(), (Department)departs.head());
        this.put("defenseGroup", defenseGroup);
        this.put("departs", departs);
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)departs);
        this.put("offices", this.entityDao().findBy(TeachingOffice.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Buffer<Teacher> teachers = this.searchMemberCandidates(defenseGroup);
        Buffer myDeparts = (Buffer)teachers.filter((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = defenseGroup.department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        teachers.subtractAll((IterableOnce)myDeparts);
        teachers.prependAll((IterableOnce)myDeparts);
        Object[] objectArray2 = new Tuple2[2];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.project$4(lazyRef).school());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, myDeparts.map((Function1 & Serializable)_$6 -> _$6.code()));
        scala.collection.immutable.Seq secretaries = this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        this.put("secretaries", secretaries);
        this.put("advisors", teachers);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Map reviews = group.writers().isEmpty() ? Predef$.MODULE$.Map().empty() : ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)group.orderedWriters()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("reviews", reviews);
        this.put("defenseGroup", group);
        return this.forward(this.forward$default$1());
    }

    @mapping(method="delete")
    public View remove() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq defenseGroups = this.entityDao().find(DefenseGroup.class, (Iterable)this.getLongIds("defenseGroup"));
        IntRef removed = IntRef.create((int)0);
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$5(lazyRef));
        defenseGroups.foreach((Function1)(JProcedure1 & Serializable)defenseGroup -> {
            if (departs.contains((Object)defenseGroup.department()) && !defenseGroup.published()) {
                this.entityDao().remove(defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
                ++removed$1.elem;
                return;
            }
        });
        return this.redirect("index", (String)(removed.elem > 0 ? "\u6210\u529f\u5220\u9664" + removed.elem + "\u7ec4" : "\u5df2\u53d1\u5e03\u7684\u7ec4\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u53d6\u6d88\u53d1\u5e03\u540e\u5220\u9664"));
    }

    public View removeAdvisor() {
        DefenseGroup group;
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$6(lazyRef));
        if (departs.contains((Object)(group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get())).department())) {
            DefenseMember removed = (DefenseMember)this.entityDao().get(DefenseMember.class, this.getLong("defenseMember.id").get());
            group.members().subtractOne((Object)removed);
            this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        }
        return this.redirect("edit", "id=" + group.id(), "info.remove.success");
    }

    private int genGroupIdx(DefenseGroup group) {
        if (group.idx() == 0) {
            OqlBuilder query = OqlBuilder$.MODULE$.from(DefenseGroup.class.getName(), "g");
            query.where("g.department=:depart", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{group.department()}));
            query.where("g.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{group.season()}));
            query.select("g.idx");
            query.orderBy("g.idx desc");
            scala.collection.immutable.Seq indexList = this.entityDao().search((QueryBuilder)query);
            if (indexList.isEmpty()) {
                return 1;
            }
            return BoxesRunTime.unboxToInt((Object)indexList.head()) + 1;
        }
        return group.idx();
    }

    public View save() {
        DefenseGroup defenseGroup;
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$7(lazyRef));
        Option option = this.getLong("defenseGroup.id");
        if (None$.MODULE$.equals(option)) {
            defenseGroup = new DefenseGroup(((ThesisPlan)this.thesisPlanService().getPlan().get()).season(), null);
        } else if (option instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)id));
        } else {
            throw new MatchError((Object)option);
        }
        DefenseGroup group = defenseGroup;
        group.department_$eq((Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)this.getIntId("defenseGroup.department"))));
        group.office_$eq(this.entityDao().find(TeachingOffice.class, (Iterable)this.getLongIds("defenseGroup.office")).headOption());
        group.place_$eq(this.get("defenseGroup.place"));
        group.beginAt_$eq(this.getInstant("defenseGroup.beginAt"));
        group.endAt_$eq(this.getInstant("defenseGroup.endAt"));
        group.secretary_$eq(this.getLong("defenseGroup.secretary.id").map((Function1 & Serializable)x -> this.save$$anonfun$1(BoxesRunTime.unboxToLong((Object)x))));
        group.idx_$eq(this.genGroupIdx(group));
        group.members().foreach((Function1)(JProcedure1 & Serializable)m -> this.getBoolean("member_" + m.teacher().id() + ".leader").foreach((Function1 & Serializable)v1 -> {
            m.leader_$eq(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        }));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.getLong("newmember_" + i + ".teacher.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)teacherId -> {
            Teacher teacher = (Teacher)this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)teacherId));
            if (group.members().forall((Function1 & Serializable)x -> {
                Teacher teacher = x.teacher();
                Teacher teacher2 = teacher;
                return teacher == null ? teacher2 != null : !teacher.equals(teacher2);
            })) {
                DefenseMember nm = new DefenseMember();
                nm.teacher_$eq(teacher);
                nm.leader_$eq(this.getBoolean("newmember_" + i + ".leader", false));
                nm.group_$eq(group);
                group.members().$plus$eq((Object)nm);
                return;
            }
        }));
        this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        return this.redirect("index", "info.save.success");
    }

    public View removeWriter() {
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        Writer removed = (Writer)this.entityDao().get(Writer.class, this.getLong("writer.id").get());
        defenseGroup.removeWriter((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[]{removed})));
        this.entityDao().saveOrUpdate((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        String msg = "\u4ece\u7b2c" + defenseGroup.idx() + "\u7ec4\u4e2d\u79fb\u9664" + removed.std().name();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer.std.code");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)removed.std().code());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"group.id");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)defenseGroup.id().toString());
        this.businessLogger().info(msg, defenseGroup.id(), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.redirect("edit", "id=" + defenseGroup.id(), "info.remove.success");
    }

    public View addWriterList() {
        LazyRef lazyRef = new LazyRef();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        this.put("defenseGroup", group);
        Buffer advisors = (Buffer)group.members().map((Function1 & Serializable)_$7 -> _$7.teacher());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
        query.where("writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("writer.std.state.department = :depart", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{group.department()}));
        if (advisors.nonEmpty()) {
            query.where("writer.advisor.teacher not in(:advisors)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisors}));
        }
        query.where("not exists(from " + DefenseGroup.class.getName() + " dg join dg.writers as wr where wr.writer=writer)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.populateConditions(query);
        QueryHelper$.MODULE$.sort(query);
        scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
        this.put("writers", writers);
        return this.forward(this.forward$default$1());
    }

    public View addWriter() {
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        scala.collection.immutable.Set advisors = ((IterableOnceOps)defenseGroup.members().map((Function1 & Serializable)_$8 -> _$8.teacher())).toSet();
        scala.collection.immutable.Seq added = this.entityDao().find(Writer.class, this.getAll("writer.id", Long.TYPE, ClassTag$.MODULE$.apply(Long.TYPE)));
        added.foreach((Function1)(JProcedure1 & Serializable)add -> {
            if (!advisors.contains((Object)((Advisor)add.advisor().get()).teacher())) {
                defenseGroup.addWriters((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Writer[]{add})));
                return;
            }
        });
        this.entityDao().saveOrUpdate((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        return this.redirect("edit", "id=" + defenseGroup.id(), "info.save.success");
    }

    public View autoAddWriter() {
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        int newCount = this.getInt("newCount", 0);
        DefenseGroup defenseGroup = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("defenseGroup.id").get());
        if (newCount > 0) {
            int i;
            Buffer advisors = (Buffer)defenseGroup.members().map((Function1 & Serializable)_$9 -> _$9.teacher());
            OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class, "writer");
            query.where("writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
            query.where("writer.std.state.department =:depart", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{defenseGroup.department()}));
            defenseGroup.office().foreach((Function1 & Serializable)office -> (OqlBuilder)query.where("writer.advisor.teacher.office=:office", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{office})));
            if (advisors.nonEmpty()) {
                query.where("writer.advisor.teacher not in(:advisors)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisors}));
            }
            query.where("not exists(from " + DefenseGroup.class.getName() + " dg join dg.writers as wr where wr.writer=writer)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            scala.collection.immutable.Seq writers = this.entityDao().search((QueryBuilder)query);
            Iterator writerIter = writers.iterator();
            for (i = 0; i < newCount && writerIter.hasNext(); ++i) {
                Writer writer = (Writer)writerIter.next();
                defenseGroup.addWriters((Iterable)new .colon.colon((Object)writer, (List)Nil$.MODULE$));
            }
            this.entityDao().saveOrUpdate((Object)defenseGroup, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
            return this.redirect("edit", "id=" + defenseGroup.id(), "\u6210\u529f\u6dfb\u52a0\u4e86" + i + "\u540d\u5b66\u751f");
        }
        return this.redirect("edit", "id=" + defenseGroup.id(), "\u6210\u529f\u6dfb\u52a0\u4e860\u540d\u5b66\u751f");
    }

    public View randomManager() {
        LazyRef lazyRef = new LazyRef();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$9(lazyRef));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisReview.class.getName(), "tr");
        query.where("tr.writer.std.state.department in(:departs)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{departs}));
        query.where("tr.writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("tr.crossReviewManager is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("not exists(from " + DefenseGroup.class.getName() + " dg join dg.writers as wr where wr.writer=tr.writer)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.select("tr.crossReviewManager.id,count(*)");
        query.groupBy("tr.crossReviewManager.id");
        scala.collection.immutable.Seq rs = this.entityDao().search((QueryBuilder)query);
        rs.map((Function1 & Serializable)a -> {
            a[0] = this.entityDao().get(Teacher.class, (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a[0])));
            return a;
        });
        this.put("reviewManagers", rs.sortBy((Function1 & Serializable)x -> ((Teacher)x[0]).department().code(), (Ordering)Ordering.String$.MODULE$));
        return this.forward(this.forward$default$1());
    }

    private OqlBuilder<Writer> getCandinatesQuery(Advisor advisor, DefenseGroup group) {
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        Buffer advisors = (Buffer)group.members().map((Function1 & Serializable)_$10 -> _$10.teacher());
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisReview.class.getName(), "tr");
        query.where("tr.writer.season=:season", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season}));
        query.where("tr.writer.advisor is not null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.where("tr.crossReviewManager = :manager", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        if (advisors.nonEmpty()) {
            query.where("tr.writer.advisor.teacher not in(:advisors)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisors}));
        }
        query.where("not exists(from " + DefenseGroup.class.getName() + " dg join dg.writers as wr where wr.writer=tr.writer)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query.select("tr.writer");
        return query;
    }

    public View randomGroupSetting() {
        Advisor advisor = (Advisor)this.entityDao().findBy(Advisor.class, "teacher.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("manager"))).head();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup group = new DefenseGroup(season, advisor.teacher().department());
        OqlBuilder<Writer> query = this.getCandinatesQuery(advisor, group);
        scala.collection.immutable.Seq writers = this.entityDao().search(query);
        Map majorWriters = writers.groupBy((Function1 & Serializable)_$11 -> ((StudentState)_$11.std().state().get()).major());
        this.put("majorWriters", majorWriters);
        this.put("writers", writers);
        scala.collection.immutable.Set teachers = ((IterableOnceOps)writers.map((Function1 & Serializable)_$12 -> ((Advisor)_$12.advisor().get()).teacher())).toSet();
        scala.collection.immutable.Set offices = ((IterableOnceOps)writers.flatMap((Function1 & Serializable)_$13 -> ((Advisor)_$13.advisor().get()).teacher().office())).toSet();
        if (offices.nonEmpty()) {
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(Advisor.class.getName(), "advisor");
            query2.where("advisor.teacher.office in(:offices)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{offices}));
            query2.where("advisor.endOn is null", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            query2.select("advisor.teacher");
            teachers = (scala.collection.immutable.Set)teachers.$plus$plus((IterableOnce)this.entityDao().search((QueryBuilder)query2));
        }
        this.put("teachers", teachers);
        this.put("manager", advisor.teacher());
        return this.forward(this.forward$default$1());
    }

    public View randomGroupSchedule() {
        Advisor advisor = (Advisor)this.entityDao().findBy(Advisor.class, "teacher.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("manager"))).head();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        DefenseGroup group = new DefenseGroup(season, advisor.teacher().department());
        OqlBuilder<Writer> query = this.getCandinatesQuery(advisor, group);
        scala.collection.immutable.Seq writers = this.entityDao().search(query);
        Map majorWriters = writers.groupBy((Function1 & Serializable)_$14 -> ((StudentState)_$14.std().state().get()).major());
        this.put("majorWriters", majorWriters);
        this.put("writers", writers);
        Iterable<Teacher> teachers = this.groupService().getManageTeacher(advisor, ((ThesisPlan)this.thesisPlanService().getPlan().get()).season());
        this.put("teachers", teachers);
        scala.collection.immutable.Seq selectTeachers = this.entityDao().find(Teacher.class, (Iterable)this.getLongIds("teacher"));
        scala.collection.immutable.Seq selectMajors = this.entityDao().find(Major.class, (Iterable)this.getLongIds("major"));
        this.put("selectTeachers", selectTeachers.toSet());
        this.put("selectMajors", selectMajors.toSet());
        int count = this.getInt("groupCount", 1);
        if (count <= 1) {
            count = 1;
        }
        if (count > teachers.size()) {
            count = teachers.size();
        }
        scala.collection.immutable.Seq<RandomGroup> groups = RandomGroupHelper$.MODULE$.generate((Seq<Writer>)writers, (Seq<Teacher>)selectTeachers, count);
        this.put("groupCount", BoxesRunTime.boxToInteger((int)count));
        this.put("groups", groups);
        this.put("manager", advisor.teacher());
        return this.forward(this.forward$default$1());
    }

    public View saveRandomGroup() {
        int count = this.getInt("groupCount", 1);
        Advisor advisor = (Advisor)this.entityDao().findBy(Advisor.class, "teacher.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("manager"))).head();
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            DefenseGroup group = new DefenseGroup(season, advisor.teacher().department());
            scala.collection.immutable.Seq teachers = this.entityDao().find(Teacher.class, (Iterable)Strings$.MODULE$.splitToLong((String)this.get("group_" + i + "_teacherIds", "")));
            scala.collection.immutable.Seq writers = this.entityDao().find(Writer.class, (Iterable)Strings$.MODULE$.splitToLong((String)this.get("group_" + i + "_writerIds", "")));
            group.office_$eq(advisor.teacher().office());
            group.members().$plus$plus$eq((IterableOnce)teachers.map((Function1 & Serializable)x -> {
                DefenseMember m = new DefenseMember();
                m.group_$eq(group);
                m.teacher_$eq(x);
                return m;
            }));
            group.addWriters((Iterable)writers);
            group.idx_$eq(this.genGroupIdx(group));
            this.entityDao().saveOrUpdate((Object)group, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefenseGroup[0]));
        });
        return this.redirect("search", "\u5206\u7ec4\u6210\u529f");
    }

    public View publish() {
        LazyRef lazyRef = new LazyRef();
        scala.collection.immutable.Seq defenseGroups = this.entityDao().find(DefenseGroup.class, (Iterable)this.getLongIds("defenseGroup"));
        boolean published = this.getBoolean("published", true);
        scala.collection.immutable.Seq departs = this.getDeparts(this.project$10(lazyRef));
        defenseGroups.foreach((Function1)(JProcedure1 & Serializable)defenseGroup -> {
            if (departs.contains((Object)defenseGroup.department())) {
                defenseGroup.published_$eq(published);
                return;
            }
        });
        this.entityDao().saveOrUpdate((Iterable)defenseGroups);
        return this.redirect("search", "\u64cd\u4f5c\u6210\u529f");
    }

    public View report() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        Map reviews = group.writers().isEmpty() ? Predef$.MODULE$.Map().empty() : ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)group.orderedWriters()).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HSSFWorkbook hsw = DefenseReport$.MODULE$.render(group, (Map<Writer, ThesisReview>)reviews);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hsw.write((OutputStream)bos);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(bos.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u7b54\u8fa9\u4fe1\u606f\u8868.xls", Stream$.MODULE$.apply$default$4());
    }

    public View reportZip() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        List reviews = group.writers().isEmpty() ? package$.MODULE$.List().empty() : this.entityDao().findBy(ThesisReview.class, "writer", (Object)group.orderedWriters());
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        File targetZip = PaperDownloadHelper$.MODULE$.zipGroupReport(season, group, (scala.collection.immutable.Seq<ThesisReview>)reviews);
        String fileName = season.name() + "_" + group.department().name() + "_\u7b2c" + group.idx() + "\u7ec4\u7b54\u8fa9\u8bc4\u5206\u8868.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName).cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> targetZip.delete());
    }

    public View paperZip() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, this.getLong("id").get());
        List papers = group.writers().isEmpty() ? package$.MODULE$.List().empty() : this.entityDao().findBy(ThesisPaper.class, "writer", (Object)group.orderedWriters());
        GraduateSeason season = ((ThesisPlan)this.thesisPlanService().getPlan().get()).season();
        File targetZip = PaperDownloadHelper$.MODULE$.zipGroupPapers(season, group, (Iterable<ThesisPaper>)papers);
        String fileName = season.name() + "_" + group.department().name() + "_\u7b2c" + group.idx() + "\u7ec4\u8bba\u6587.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public View inputScore() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("defenseGroup")));
        Set writers = (Set)group.writers().map((Function1 & Serializable)_$15 -> _$15.writer());
        this.put("group", group);
        Map reviews = writers.isEmpty() ? Predef$.MODULE$.Map().empty() : ((IterableOnceOps)this.entityDao().findBy(ThesisReview.class, "writer", (Object)writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("reviews", reviews);
        return this.forward(this.forward$default$1());
    }

    public View saveScore() {
        DefenseGroup group = (DefenseGroup)this.entityDao().get(DefenseGroup.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("group")));
        scala.collection.immutable.Seq reviews = this.entityDao().find(ThesisReview.class, (Iterable)this.getLongIds("review"));
        reviews.foreach((Function1)(JProcedure1 & Serializable)r -> {
            Option option = this.getInt("defense_score_" + r.id());
            if (None$.MODULE$.equals(option)) {
                r.defenseScore_$eq((Option)None$.MODULE$);
                r.finalScore_$eq((Option)None$.MODULE$);
                r.finalScoreText_$eq((Option)None$.MODULE$);
                return;
            }
            if (option instanceof Some) {
                int s = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                r.defenseScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Int$.MODULE$.int2float(s))));
                int score = Predef$.MODULE$.double2Double(Numbers$.MODULE$.round((double)BoxesRunTime.unboxToFloat((Object)r.crossReviewScore().getOrElse(DefenseAction::$anonfun$18)) * 0.6 + (double)s * 0.4, 0)).intValue();
                String scoreText = ScoreTextHelper$.MODULE$.convert(Int$.MODULE$.int2float(score));
                r.remark_$eq((Option)None$.MODULE$);
                r.finalScore_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Int$.MODULE$.int2float(score))));
                r.finalScoreText_$eq((Option)Some$.MODULE$.apply((Object)scoreText));
                return;
            }
            throw new MatchError((Object)option);
        });
        this.entityDao().saveOrUpdate((Iterable)reviews);
        String msg = "\u5f55\u5165\u7b2c" + group.idx() + "\u7ec4\u7b54\u8fa9\u6210\u7ee9";
        this.businessLogger().info(msg, group.id(), (Object)((IterableOnceOps)reviews.map((Function1 & Serializable)x -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)x.writer().code());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x.defenseScore().map((Function1 & Serializable)_$16 -> DefenseAction.saveScore$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToFloat((Object)_$16))).getOrElse(DefenseAction::saveScore$$anonfun$2$$anonfun$2));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return this.redirect("search", "\u5f55\u5165\u6210\u529f");
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private final Project project$lzyINIT4$1(LazyRef project$lzy4$1) {
        Project project;
        LazyRef lazyRef = project$lzy4$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy4$1.initialized() ? project$lzy4$1.value() : project$lzy4$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$4(LazyRef project$lzy4$2) {
        return (Project)(project$lzy4$2.initialized() ? project$lzy4$2.value() : this.project$lzyINIT4$1(project$lzy4$2));
    }

    private final Project project$lzyINIT5$1(LazyRef project$lzy5$1) {
        Project project;
        LazyRef lazyRef = project$lzy5$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy5$1.initialized() ? project$lzy5$1.value() : project$lzy5$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$5(LazyRef project$lzy5$2) {
        return (Project)(project$lzy5$2.initialized() ? project$lzy5$2.value() : this.project$lzyINIT5$1(project$lzy5$2));
    }

    private final Project project$lzyINIT6$1(LazyRef project$lzy6$1) {
        Project project;
        LazyRef lazyRef = project$lzy6$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy6$1.initialized() ? project$lzy6$1.value() : project$lzy6$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$6(LazyRef project$lzy6$2) {
        return (Project)(project$lzy6$2.initialized() ? project$lzy6$2.value() : this.project$lzyINIT6$1(project$lzy6$2));
    }

    private final Project project$lzyINIT7$1(LazyRef project$lzy7$1) {
        Project project;
        LazyRef lazyRef = project$lzy7$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy7$1.initialized() ? project$lzy7$1.value() : project$lzy7$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$7(LazyRef project$lzy7$2) {
        return (Project)(project$lzy7$2.initialized() ? project$lzy7$2.value() : this.project$lzyINIT7$1(project$lzy7$2));
    }

    private final /* synthetic */ User save$$anonfun$1(long x) {
        return (User)this.entityDao().get(User.class, (Object)BoxesRunTime.boxToLong((long)x));
    }

    private final Project project$lzyINIT8$1(LazyRef project$lzy8$1) {
        Project project;
        LazyRef lazyRef = project$lzy8$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy8$1.initialized() ? project$lzy8$1.value() : project$lzy8$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$8(LazyRef project$lzy8$2) {
        return (Project)(project$lzy8$2.initialized() ? project$lzy8$2.value() : this.project$lzyINIT8$1(project$lzy8$2));
    }

    private final Project project$lzyINIT9$1(LazyRef project$lzy9$1) {
        Project project;
        LazyRef lazyRef = project$lzy9$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy9$1.initialized() ? project$lzy9$1.value() : project$lzy9$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$9(LazyRef project$lzy9$2) {
        return (Project)(project$lzy9$2.initialized() ? project$lzy9$2.value() : this.project$lzyINIT9$1(project$lzy9$2));
    }

    private final Project project$lzyINIT10$1(LazyRef project$lzy10$1) {
        Project project;
        LazyRef lazyRef = project$lzy10$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy10$1.initialized() ? project$lzy10$1.value() : project$lzy10$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$10(LazyRef project$lzy10$2) {
        return (Project)(project$lzy10$2.initialized() ? project$lzy10$2.value() : this.project$lzyINIT10$1(project$lzy10$2));
    }

    private static final float $anonfun$18() {
        return 0.0f;
    }

    private static final /* synthetic */ String saveScore$$anonfun$2$$anonfun$1(float _$16) {
        return BoxesRunTime.boxToFloat((float)_$16).toString();
    }

    private static final String saveScore$$anonfun$2$$anonfun$2() {
        return "";
    }
}

