/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.View;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.PlanStatus;
import org.openurp.degree.thesis.model.PlanStatus$;
import org.openurp.degree.thesis.model.Stage;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class PlanAction
extends RestfulAction<ThesisPlan>
implements ProjectSupport {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;

    public PlanAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public String simpleEntityName() {
        return "plan";
    }

    public View index() {
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public void editSetting(ThesisPlan plan) {
        this.getLong("plan.season.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)seasonId -> plan.season_$eq((GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)seasonId))));
        this.put("stages", Stage$.MODULE$.values());
    }

    public View saveAndRedirect(ThesisPlan plan) {
        Map plans = ((IterableOnceOps)plan.departPlans().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.department(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Object object = Predef$.MODULE$.refArrayOps((Object[])Stage$.MODULE$.values());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)stage -> {
            if (stage.subCount() == 0) {
                this.getInstant(stage.id() + "_beginOn").foreach((Function1 & Serializable)begin -> {
                    Instant end = this.getEndAt((Stage)stage);
                    Option option = plan.times().find((Function1 & Serializable)x -> {
                        Stage stage = x.stage();
                        Stage stage2 = stage;
                        return !(stage != null ? !stage.equals(stage2) : stage2 != null);
                    });
                    if (None$.MODULE$.equals(option)) {
                        return plan.times().addOne((Object)new StageTime(stage, begin, end));
                    }
                    if (option instanceof Some) {
                        StageTime st = (StageTime)((Some)option).value();
                        st.beginAt_$eq(begin);
                        st.endAt_$eq(end);
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)option);
                });
                return;
            }
        });
        plan.project_$eq(this.getProject());
        plan.beginOn_$eq(((Instant)((IterableOnceOps)plan.times().map((Function1 & Serializable)_$1 -> _$1.beginAt())).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).atZone(ZoneId.systemDefault()).toLocalDate());
        plan.endOn_$eq(((Instant)((IterableOnceOps)plan.times().map((Function1 & Serializable)_$2 -> _$2.endAt())).max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).atZone(ZoneId.systemDefault()).toLocalDate());
        this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPlan[0]));
        OqlBuilder departQuery = OqlBuilder$.MODULE$.from(Writer.class.getName(), "w");
        departQuery.where("w.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{plan.season()}));
        departQuery.select("distinct w.std.state.department");
        Seq departs = this.entityDao().search((QueryBuilder)departQuery);
        departs.foreach((Function1)(JProcedure1 & Serializable)depart -> {
            Option option = plans.get(depart);
            if (None$.MODULE$.equals(option)) {
                DepartPlan dp = new DepartPlan();
                dp.department_$eq(depart);
                dp.thesisPlan_$eq(plan);
                dp.status_$eq(PlanStatus$.\u5f85\u5b66\u9662\u4fee\u6539);
                Object object = Predef$.MODULE$.refArrayOps((Object[])Stage$.MODULE$.values());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)stage -> {
                    if (stage.subCount() == 0) {
                        this.getInstant(stage.id() + "_beginOn").foreach((Function1)(JProcedure1 & Serializable)beginAt -> dp.addTime(stage, beginAt, this.getEndAt((Stage)stage)));
                        return;
                    }
                });
                this.entityDao().saveOrUpdate((Object)dp, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DepartPlan[0]));
                return;
            }
            if (option instanceof Some) {
                DepartPlan dp = (DepartPlan)((Some)option).value();
                PlanStatus planStatus = dp.status();
                PlanStatus planStatus2 = PlanStatus$.\u5f85\u5b66\u9662\u4fee\u6539;
                if (!(planStatus != null ? !planStatus.equals(planStatus2) : planStatus2 != null)) {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])Stage$.MODULE$.values());
                    ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)stage -> {
                        if (stage.subCount() == 0) {
                            this.getInstant(stage.id() + "_beginOn").foreach((Function1)(JProcedure1 & Serializable)beginAt -> dp.addTime(stage, beginAt, this.getEndAt((Stage)stage)));
                            return;
                        }
                    });
                    this.entityDao().saveOrUpdate((Object)dp, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DepartPlan[0]));
                    return;
                }
                return;
            }
            throw new MatchError((Object)option);
        });
        return this.redirect("search", "info.save.success");
    }

    public View print() {
        this.getLong("id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> this.put("plan", this.entityDao().get(DepartPlan.class, (Object)BoxesRunTime.boxToLong((long)id))));
        return this.forward(this.forward$default$1());
    }

    public View check() {
        this.put("Passed", PlanStatus$.\u5ba1\u67e5\u901a\u8fc7);
        this.put("Rejected", PlanStatus$.\u5ba1\u67e5\u672a\u901a\u8fc7);
        this.getLong("id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> this.put("departPlan", this.entityDao().get(DepartPlan.class, (Object)BoxesRunTime.boxToLong((long)id))));
        return this.forward(this.forward$default$1());
    }

    public View removeDepartPlan() {
        DepartPlan departPlan = (DepartPlan)this.entityDao().get(DepartPlan.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("departPlan")));
        PlanStatus planStatus = departPlan.status();
        PlanStatus planStatus2 = PlanStatus$.\u5ba1\u67e5\u901a\u8fc7;
        if (planStatus == null ? planStatus2 != null : !planStatus.equals(planStatus2)) {
            this.entityDao().remove((Object)departPlan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DepartPlan[0]));
        }
        return this.redirect("search", "plan.season.id=" + departPlan.thesisPlan().season().id().toString(), "\u5220\u9664\u6210\u529f");
    }

    private void addTime(DepartPlan departPlan, Stage stage, Instant begin, Instant end) {
        Option option;
        block4: {
            block6: {
                StageTime st;
                block5: {
                    option = departPlan.times().find((Function1 & Serializable)x -> {
                        Stage stage = x.stage();
                        Stage stage2 = stage;
                        return !(stage != null ? !stage.equals(stage2) : stage2 != null);
                    });
                    if (None$.MODULE$.equals(option)) {
                        departPlan.times().addOne((Object)new StageTime(stage, begin, end));
                        return;
                    }
                    if (!(option instanceof Some)) break block4;
                    st = (StageTime)((Some)option).value();
                    LocalDate localDate = st.beginOn();
                    Instant instant = begin;
                    if (localDate != null ? !((Object)localDate).equals(instant) : instant != null) break block5;
                    LocalDate localDate2 = st.endOn();
                    Instant instant2 = end;
                    if (!(localDate2 == null ? instant2 != null : !((Object)localDate2).equals(instant2))) break block6;
                }
                departPlan.times().subtractOne((Object)st);
                departPlan.times().addOne((Object)new StageTime(stage, begin, end));
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private Instant getEndAt(Stage stage) {
        ZonedDateTime endTime = ((Instant)this.getInstant(stage.id() + "_endOn").get()).atZone(ZoneId.systemDefault());
        if (endTime.getHour() == 0) {
            endTime = endTime.plusDays(1L).minusMinutes(1L);
        }
        return endTime.toInstant();
    }

    public View saveCheck() {
        DepartPlan plan = (DepartPlan)this.populateEntity(DepartPlan.class, "departPlan");
        Object object = Predef$.MODULE$.refArrayOps((Object[])Stage$.MODULE$.values());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)stage -> {
            if (stage.subCount() == 0) {
                this.getInstant(stage.id() + "_beginOn").foreach((Function1)(JProcedure1 & Serializable)beginOn -> this.addTime(plan, (Stage)stage, (Instant)beginOn, this.getEndAt((Stage)stage)));
                return;
            }
        });
        PlanStatus planStatus = plan.status();
        PlanStatus planStatus2 = PlanStatus$.\u5ba1\u67e5\u901a\u8fc7;
        if (planStatus == null ? planStatus2 != null : !planStatus.equals(planStatus2)) {
            plan.status_$eq(PlanStatus$.\u5f85\u5b66\u6821\u5ba1\u67e5);
        }
        this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DepartPlan[0]));
        return this.redirect("search", "plan.season.id=" + plan.thesisPlan().season().id().toString(), "\u64cd\u4f5c\u6210\u529f");
    }

    public View submit() {
        DepartPlan plan = (DepartPlan)this.populateEntity(DepartPlan.class, "plan");
        Object object = Predef$.MODULE$.refArrayOps((Object[])Stage$.MODULE$.values());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)stage -> {
            if (stage.subCount() == 0) {
                plan.addTime(stage, (Instant)this.getInstant(stage.id() + "_beginOn").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.getEndAt((Stage)stage));
                return;
            }
        });
        PlanStatus planStatus = plan.status();
        PlanStatus planStatus2 = PlanStatus$.\u5ba1\u67e5\u901a\u8fc7;
        if (planStatus == null ? planStatus2 != null : !planStatus.equals(planStatus2)) {
            plan.status_$eq(PlanStatus$.\u5f85\u5b66\u6821\u5ba1\u67e5);
        }
        this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DepartPlan[0]));
        return this.redirect("info", "id=" + plan.id(), "info.save.success");
    }

    public View cloneLast() {
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("plan.season")));
        OqlBuilder q = OqlBuilder$.MODULE$.from(ThesisPlan.class, "plan");
        q.where("plan.season.graduateIn < :graduateIn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{season.graduateIn()}));
        q.orderBy("plan.season.graduateIn desc");
        Option lastPlan = this.entityDao().first((QueryBuilder)q);
        if (lastPlan.nonEmpty()) {
            ThesisPlan last = (ThesisPlan)lastPlan.get();
            Duration duration = Duration.between(last.season().graduateIn().atDay(1).atTime(LocalTime.MIN), season.graduateIn().atDay(1).atTime(LocalTime.MIN));
            ThesisPlan plan = new ThesisPlan();
            plan.season_$eq(season);
            plan.project_$eq(last.project());
            last.times().foreach((Function1 & Serializable)time -> (Buffer)plan.times().addOne((Object)new StageTime(time.stage(), time.beginAt().plus(duration), time.endAt().plus(duration))));
            plan.beginOn_$eq(((Instant)((IterableOnceOps)plan.times().map((Function1 & Serializable)_$3 -> _$3.beginAt())).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).atZone(ZoneId.systemDefault()).toLocalDate());
            plan.endOn_$eq(((Instant)((IterableOnceOps)plan.times().map((Function1 & Serializable)_$4 -> _$4.endAt())).max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).atZone(ZoneId.systemDefault()).toLocalDate());
            OqlBuilder departQuery = OqlBuilder$.MODULE$.from(Writer.class.getName(), "w");
            departQuery.where("w.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{plan.season()}));
            departQuery.select("distinct w.std.state.department");
            Seq departs = this.entityDao().search((QueryBuilder)departQuery);
            departs.foreach((Function1 & Serializable)depart -> {
                DepartPlan dp = new DepartPlan();
                dp.department_$eq(depart);
                dp.thesisPlan_$eq(plan);
                dp.status_$eq(PlanStatus$.\u5f85\u5b66\u9662\u4fee\u6539);
                plan.times().foreach((Function1)(JProcedure1 & Serializable)x -> dp.addTime(x.stage(), x.beginAt(), x.endAt()));
                return (Buffer)plan.departPlans().addOne((Object)dp);
            });
            this.entityDao().saveOrUpdate((Object)plan, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPlan[0]));
            return this.redirect("search", "\u4ece" + last.season().name() + "\u590d\u5236\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574");
        }
        return this.redirect("search", "\u627e\u4e0d\u5230\u4e0a\u5c4a\u7684\u65f6\u95f4\u8bbe\u7f6e");
    }
}

