/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.advisor;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.io.Files$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.User;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.ThesisArchive;
import org.openurp.degree.thesis.model.ThesisDoc;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.doc.ThesisPdfGenerator$;
import org.openurp.degree.thesis.web.action.advisor.AdvisorSupport;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class ArchiveAction
extends AdvisorSupport
implements EntitySupport<ThesisArchive> {
    private Class entityClass;

    public ArchiveAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public View index() {
        ThesisPlan thesisPlan;
        Option planId;
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisPlan.class, "tp");
        query.orderBy("tp.beginOn desc");
        query.cacheable(query.cacheable$default$1());
        scala.collection.immutable.Seq plans = this.entityDao().search((QueryBuilder)query);
        Option option = planId = this.getLong("plan.id");
        if (None$.MODULE$.equals(option)) {
            thesisPlan = (ThesisPlan)plans.head();
        } else if (option instanceof Some) {
            long pid = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            thesisPlan = (ThesisPlan)Option$.MODULE$.option2Iterable(plans.find((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToLong((Object)_$1.id()) == pid)).head();
        } else {
            throw new MatchError((Object)option);
        }
        ThesisPlan plan = thesisPlan;
        this.put("plan", plan);
        this.put("plans", plans);
        Advisor advisor = this.getAdvisor();
        Iterable<Writer> writers = this.getWriters(plan);
        scala.collection.immutable.Map archivesMap = ((IterableOnceOps)((IterableOps)this.entityDao().findBy(ThesisArchive.class, "writer", writers).filter((Function1 & Serializable)_$2 -> _$2.uploadAt().nonEmpty())).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("archives", archivesMap);
        this.put("writers", writers);
        scala.collection.immutable.Seq docs = this.entityDao().findBy(ThesisDoc.class, "writer", writers);
        this.put("docs", docs.groupBy((Function1 & Serializable)_$3 -> _$3.writer()));
        this.put("withoutArchives", writers.toBuffer().subtractAll((IterableOnce)archivesMap.keySet()));
        return this.forward(this.forward$default$1());
    }

    public View auditSetting() {
        Writer writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        scala.collection.immutable.Seq docs = this.entityDao().findBy(ThesisDoc.class, "writer", (Object)writer);
        Option paper = this.entityDao().findBy(ThesisPaper.class, "writer", (Object)writer).headOption();
        this.put("writer", writer);
        this.put("paper", paper);
        this.put("docs", docs);
        this.put("archive", this.entityDao().findBy(ThesisArchive.class, "writer", (Object)writer).headOption());
        return this.forward(this.forward$default$1());
    }

    public View preview() {
        ThesisDoc doc = (ThesisDoc)this.entityDao().get(ThesisDoc.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("doc")));
        this.put("doc_url", EmsApp$.MODULE$.getBlobRepository(true).url(doc.filePath()));
        return this.forward(this.forward$default$1());
    }

    public View audit() {
        ThesisArchive archive = (ThesisArchive)this.entityDao().get(ThesisArchive.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("archive")));
        boolean confirmed = this.getBoolean("archive.confirmed", false);
        if (BoxesRunTime.unboxToBoolean((Object)archive.archived().getOrElse(ArchiveAction::audit$$anonfun$1)) && !confirmed) {
            return this.redirect("index", "\u4f60\u5df2\u7ecf\u4e0a\u4f20\u8fc7\u5f52\u6863\u6750\u6599\uff0c\u65e0\u9700\u5ba1\u6838");
        }
        archive.confirmed_$eq(this.getBoolean("archive.confirmed"));
        archive.feedback_$eq(this.get("archive.feedback"));
        archive.confirmAt_$eq((Option)None$.MODULE$);
        if (BoxesRunTime.unboxToBoolean((Object)archive.confirmed().getOrElse(ArchiveAction::audit$$anonfun$2))) {
            Teacher teacher = this.getAdvisor().teacher();
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"school");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)teacher.staff().school());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)teacher.code());
            Option teacherUser = this.entityDao().findBy(User.class, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption();
            archive.confirmedBy_$eq(teacherUser);
            archive.confirmAt_$eq((Option)Some$.MODULE$.apply((Object)Instant.now()));
        }
        this.entityDao().saveOrUpdate((Object)archive, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisArchive[0]));
        return this.redirect("auditSetting", "&writer.id=" + archive.writer().id(), "\u5ba1\u6838\u5b8c\u6210");
    }

    public View downloadDoc() {
        ThesisDoc doc = (ThesisDoc)this.entityDao().get(ThesisDoc.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("doc")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(doc.filePath());
        HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
        response2.sendRedirect(((URL)path.get()).toString());
        return null;
    }

    public View downloadArchive() {
        ThesisArchive archive = (ThesisArchive)this.entityDao().get(ThesisArchive.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("archive")));
        scala.collection.immutable.Map docs = this.entityDao().findBy(ThesisDoc.class, "writer", (Object)archive.writer()).groupBy((Function1 & Serializable)_$4 -> _$4.writer());
        Writer writer = archive.writer();
        String stdDir = ThesisPdfGenerator$.MODULE$.getDepartFolder(BoxesRunTime.unboxToLong((Object)writer.season().id()), BoxesRunTime.unboxToInt((Object)writer.department().id()), writer.std().code());
        Seq<File> zipFiles = PaperDownloadHelper$.MODULE$.downloadDocs(new File(stdDir), (Map<Writer, Iterable<ThesisDoc>>)docs, (Option<Function1<Writer, String>>)None$.MODULE$);
        return Stream$.MODULE$.apply((File)zipFiles.head(), MediaTypes$.MODULE$.ApplicationZip(), writer.code() + "\u7684\u8bba\u6587\u6750\u6599.zip").cleanup((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ((File)zipFiles.head()).delete();
            Files$.MODULE$.travel(new File(stdDir), (Function1)(JProcedure1 & Serializable)f -> f.delete());
            new File(stdDir).delete();
        });
    }

    private static final boolean audit$$anonfun$1() {
        return false;
    }

    private static final boolean audit$$anonfun$2() {
        return false;
    }
}

